/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

class UTFGridFeatureSource
extends DecoratingFeatureSource<FeatureType, Feature> {
    String[] propertyNames;

    public UTFGridFeatureSource(FeatureSource delegate, String[] propertyNames) {
        super(delegate);
        this.propertyNames = propertyNames;
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        Query q = new Query(query);
        if (this.propertyNames == null || this.propertyNames.length == 0) {
            q.setProperties(Query.ALL_PROPERTIES);
        } else if (query.getPropertyNames() == null || query.getPropertyNames().length == 0) {
            q.setPropertyNames(this.propertyNames);
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>(Arrays.asList(this.propertyNames));
            names.addAll(Arrays.asList(q.getPropertyNames()));
            String[] newNames = names.toArray(new String[names.size()]);
            q.setPropertyNames(newNames);
        }
        return super.getFeatures(q);
    }
}

