/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.WMSServiceExceptionHandler;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.KMLStyleFilteringVisitor;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.PaletteExtractor;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geoserver.wms.map.RenderingTimeoutEnforcer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ColorUtilities;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.StyleLayer;
import org.geotools.parameter.Parameter;
import org.geotools.process.Processors;
import org.geotools.process.function.ProcessFunction;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionUpdateStyleVisitor;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class RenderedImageMapOutputFormat
extends AbstractMapOutputFormat {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List<String> AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static final String MAP_WRAPPING_FORMAT_OPTION = "mapWrapping";
    private static final String ADV_PROJECTION_HANDLING_FORMAT_OPTION = "advancedProjectionHandling";
    private static final String ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION = "advancedProjectionHandlingDensification";
    private static final String DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION = "disableDatelineWrappingHeuristic";
    public static final String DECORATIONS_ONLY_FORMAT_OPTION = "decorationsOnly";
    public static final String DISABLE_GUTTER_KEY = "wms.raster.disableGutter";
    private static Boolean DISABLE_GUTTER = Boolean.getBoolean("wms.raster.disableGutter");
    private static final int KB = 1024;
    private static final int MAX_TILE_SIZE = 1024;
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(RenderedImageMapOutputFormat.getTable());
    public static final String RASTER_CHAIN_DEBUG_KEY = "wms.raster.enableRasterChainDebug";
    private static Boolean RASTER_CHAIN_DEBUG = Boolean.getBoolean("wms.raster.enableRasterChainDebug");
    private Function<WMSMapContent, LabelCache> labelCache = null;
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private boolean palleteSupported = true;
    private boolean transparencySupported = true;
    private String extension = null;
    private final Map<String, MapProducerCapabilities> capabilities = new HashMap<String, MapProducerCapabilities>();

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public RenderedImageMapOutputFormat(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapOutputFormat(String mime, WMS wms) {
        this(mime, new String[]{mime}, wms);
    }

    public RenderedImageMapOutputFormat(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
        Collection<RenderedImageMapResponse> responses = this.wms.getAvailableMapResponses();
        for (RenderedImageMapResponse response : responses) {
            for (String outFormat : outputFormats) {
                MapProducerCapabilities cap;
                if (!response.getOutputFormats().contains(outFormat) || (cap = response.getCapabilities(outFormat)) == null) continue;
                this.capabilities.put(outFormat, cap);
            }
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return this.capabilities.get(format);
    }

    public void setLabelCache(Function<WMSMapContent, LabelCache> labelCache) {
        this.labelCache = labelCache;
    }

    @Override
    public final RenderedImageMap produceMap(WMSMapContent mapContent) throws ServiceException {
        return this.produceMap(mapContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImageMap produceMap(final WMSMapContent mapContent, boolean tiled) throws ServiceException {
        String antialias;
        Rectangle paintArea = new Rectangle(0, 0, mapContent.getMapWidth(), mapContent.getMapHeight());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + paintArea.width + "x" + paintArea.height + " image");
        }
        GetMapRequest request = mapContent.getRequest();
        String decorationsOnly = (String)request.getFormatOptions().get(DECORATIONS_ONLY_FORMAT_OPTION);
        boolean emptyMap = false;
        if (decorationsOnly != null && decorationsOnly.toLowerCase().equals("true")) {
            emptyMap = true;
        }
        if ((antialias = (String)request.getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel potentialPalette = null;
        boolean transparent = mapContent.isTransparent() && this.isTransparencySupported();
        Color bgColor = mapContent.getBgColor();
        if (AA_NONE.equals(antialias)) {
            potentialPalette = mapContent.getPalette();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
            List layers = mapContent.layers();
            for (int i = 0; i < layers.size(); ++i) {
                pe.visit(((Layer)layers.get(i)).getStyle());
                if (!pe.canComputePalette()) break;
            }
            if (pe.canComputePalette()) {
                potentialPalette = pe.getPalette();
            }
        }
        final IndexColorModel palette = potentialPalette;
        long maxMemory = this.wms.getMaxRequestMemory() * 1024;
        long memory = this.getDrawingSurfaceMemoryUse(paintArea.width, paintArea.height, palette, transparent);
        StreamingRenderer testRenderer = this.buildRenderer();
        testRenderer.setMapContent((MapContent)mapContent);
        if (maxMemory > 0L && (memory += (long)testRenderer.getMaxBackBufferMemory(paintArea.width, paintArea.height)) > maxMemory) {
            long kbUsed = memory / 1024L;
            long kbMax = maxMemory / 1024L;
            throw new ServiceException("Rendering request would use " + kbUsed + "KB, whilst the maximum memory allowed is " + kbMax + "KB");
        }
        MapDecorationLayout layout = this.findDecorationLayout(request, tiled);
        RenderedImage image = null;
        if (DefaultWebMapService.isDirectRasterPathEnabled() && mapContent.layers().size() == 1 && mapContent.getAngle() == 0.0 && (layout == null || layout.isEmpty())) {
            ArrayList<GridCoverage2D> renderedCoverages = new ArrayList<GridCoverage2D>(2);
            try {
                Interpolation interpolation = null;
                if (request.getInterpolations() != null && request.getInterpolations().size() > 0) {
                    interpolation = request.getInterpolations().get(0);
                }
                image = this.directRasterRender(mapContent, 0, renderedCoverages, interpolation);
            }
            catch (Exception e) {
                throw new ServiceException("Error rendering coverage on the fast path", (Throwable)e);
            }
            if (image != null) {
                image = new RenderedImageTimeDecorator(image);
                ((RenderedImageTimeDecorator)image).setLayer((Layer)mapContent.layers().get(0));
                return this.buildMap(mapContent, image);
            }
        }
        boolean useAlpha = transparent || MetatileMapOutputFormat.isRequestTiled(request, this);
        final RenderedImage preparedImage = this.prepareImage(paintArea.width, paintArea.height, palette, useAlpha);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphic = this.getGraphics(transparent, bgColor, preparedImage, hintsMap);
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.wms != null) {
            if (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else if (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        graphic.setRenderingHints(hintsMap);
        RenderingHints hints = new RenderingHints(hintsMap);
        StreamingRenderer renderer = this.buildRenderer();
        renderer.setThreadPool(DefaultWebMapService.getRenderingPool());
        renderer.setMapContent((MapContent)mapContent);
        renderer.setJava2DHints(hints);
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        rendererParams.put("renderingBuffer", mapContent.getBuffer());
        rendererParams.put("maxFiltersToSendToDatastore", DefaultWebMapService.getMaxFilterRules());
        rendererParams.put("scaleComputationMethod", mapContent.getRendererScaleMethod());
        if (AA_NONE.equals(antialias)) {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_STRING);
        } else {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_OUTLINE);
        }
        if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", true);
        }
        if (this.wms.isAdvancedProjectionHandlingEnabled()) {
            rendererParams.put(ADV_PROJECTION_HANDLING_FORMAT_OPTION, true);
            if (request.getFormatOptions().get(ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION) != null) {
                rendererParams.put("advancedProjectionDensificationEnabled", this.getFormatOptionAsBoolean(request, ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION));
            } else if (this.wms.isAdvancedProjectionDensificationEnabled()) {
                rendererParams.put("advancedProjectionDensificationEnabled", true);
            }
            if (this.wms.isContinuousMapWrappingEnabled()) {
                rendererParams.put("continuousMapWrapping", true);
            }
            if (request.getFormatOptions().get(DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION) != null) {
                rendererParams.put("datelineWrappingCheckEnabled", !this.getFormatOptionAsBoolean(request, DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION));
            } else if (this.wms.isDateLineWrappingHeuristicDisabled()) {
                rendererParams.put("datelineWrappingCheckEnabled", false);
            }
        }
        if (!this.getFormatOptionAsBoolean(request, ADV_PROJECTION_HANDLING_FORMAT_OPTION)) {
            rendererParams.put(ADV_PROJECTION_HANDLING_FORMAT_OPTION, false);
            rendererParams.put("continuousMapWrapping", false);
        }
        if (!this.getFormatOptionAsBoolean(request, MAP_WRAPPING_FORMAT_OPTION)) {
            rendererParams.put("continuousMapWrapping", false);
        }
        if (request.getFormatOptions().get("dpi") != null) {
            rendererParams.put("dpi", request.getFormatOptions().get("dpi"));
        }
        if (this.labelCache != null) {
            try {
                rendererParams.put("labelCache", this.labelCache.apply(mapContent));
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        boolean kmplacemark = false;
        if (request.getFormatOptions().get("kmplacemark") != null) {
            kmplacemark = (Boolean)request.getFormatOptions().get("kmplacemark");
        }
        if (kmplacemark) {
            KMLStyleFilteringVisitor dupVisitor = new KMLStyleFilteringVisitor();
            List layers = mapContent.layers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!(layers.get(i) instanceof StyleLayer)) continue;
                StyleLayer layer = (StyleLayer)layers.get(i);
                Style style = layer.getStyle();
                style.accept((StyleVisitor)dupVisitor);
                Style copy = (Style)dupVisitor.getCopy();
                layer.setStyle(copy);
            }
        }
        for (int i = 0; i < request.getLayers().size(); ++i) {
            LayerInfo layerInfo;
            LayerInfo.WMSInterpolation byLayerInterpolation;
            Interpolation interpolationToSet = null;
            if (request.getInterpolations() != null && request.getInterpolations().size() > i) {
                interpolationToSet = request.getInterpolations().get(i);
            }
            if (interpolationToSet == null && (byLayerInterpolation = RenderedImageMapOutputFormat.getConfiguredLayerInterpolation(layerInfo = request.getLayers().get(i).getLayerInfo())) != null) {
                interpolationToSet = RenderedImageMapOutputFormat.toInterpolationObject(byLayerInterpolation);
            }
            if (interpolationToSet == null) continue;
            Layer layer = (Layer)mapContent.layers().get(i);
            layer.getUserData().put("byLayerInterpolation", interpolationToSet);
        }
        renderer.setRendererHints(rendererParams);
        int maxErrors = this.wms.getMaxRenderingErrors();
        MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
        RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
        renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
        RenderTimeStatistics statistics = null;
        if (!request.getRequest().equalsIgnoreCase("GETFEATUREINFO")) {
            statistics = new RenderTimeStatistics();
            renderer.addRenderListener((RenderListener)statistics);
        }
        this.onBeforeRender(renderer);
        int maxRenderingTime = this.wms.getMaxRenderingTime(request);
        ServiceException serviceException = null;
        boolean saveMap = request.getRawKvp() != null && WMSServiceExceptionHandler.isPartialMapExceptionType(request.getRawKvp().get("EXCEPTIONS"));
        RenderingTimeoutEnforcer timeout = new RenderingTimeoutEnforcer(maxRenderingTime, (GTRenderer)renderer, graphic, saveMap){

            @Override
            public void saveMap() {
                this.map = RenderedImageMapOutputFormat.this.optimizeAndBuildMap(palette, preparedImage, mapContent);
            }
        };
        timeout.start();
        try {
            Object renderError;
            if (!emptyMap) {
                renderer.paint(graphic, paintArea, mapContent.getRenderingArea(), mapContent.getRenderingTransform());
            } else {
                LOGGER.fine("we only want to get the layout, if it's not null");
            }
            if (layout != null) {
                try {
                    layout.paint(graphic, paintArea, mapContent);
                }
                catch (Exception e) {
                    throw new ServiceException("Problem occurred while trying to watermark data", (Throwable)e);
                }
            }
            timeout.stop();
            if (errorChecker.exceedsMaxErrors()) {
                serviceException = new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out.", (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (timeout.isTimedOut()) {
                serviceException = new ServiceException("This request used more time than allowed and has been forcefully stopped. Max rendering time is " + (double)maxRenderingTime / 1000.0 + "s");
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                renderError = nonIgnorableExceptionListener.getException();
                serviceException = new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
            }
            if (serviceException == null) {
                renderError = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                return renderError;
            }
            if (saveMap) {
                RenderedImageMap map = (RenderedImageMap)timeout.getMap();
                if (map == null) {
                    map = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                }
                serviceException = new WMSPartialMapException(serviceException, (WebMap)map);
            }
        }
        finally {
            timeout.stop();
            graphic.dispose();
            if (statistics != null) {
                statistics.renderingComplete();
            }
        }
        throw serviceException;
    }

    protected StreamingRenderer buildRenderer() {
        return new StreamingRenderer();
    }

    private boolean getFormatOptionAsBoolean(GetMapRequest request, String formatOptionKey) {
        if (request.getFormatOptions().get(formatOptionKey) != null) {
            String formatOptionValue = (String)request.getFormatOptions().get(formatOptionKey);
            return !"false".equalsIgnoreCase(formatOptionValue);
        }
        return true;
    }

    private RenderedImageMap optimizeAndBuildMap(IndexColorModel palette, RenderedImage preparedImage, WMSMapContent mapContent) {
        RenderedImage image = palette != null && palette.getMapSize() < 256 ? RenderedImageMapOutputFormat.optimizeSampleModel(preparedImage) : preparedImage;
        return this.buildMap(mapContent, image);
    }

    protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
        return ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
    }

    protected void onBeforeRender(StreamingRenderer renderer) {
    }

    protected RenderedImageMap buildMap(WMSMapContent mapContent, RenderedImage image) {
        RenderedImageMap map = new RenderedImageMap(mapContent, image, this.getMimeType());
        if (this.extension != null) {
            map.setContentDispositionHeader(mapContent, "." + this.extension, false);
        }
        return map;
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public void setTransparencySupported(boolean supportsTransparency) {
        this.transparencySupported = supportsTransparency;
    }

    public boolean isPaletteSupported() {
        return this.palleteSupported;
    }

    public void setPaletteSupported(boolean supportsPalette) {
        this.palleteSupported = supportsPalette;
    }

    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.getDrawingSurfaceMemoryUse(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    private static RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        LookupTable table = LookupTableFactory.create((LookupTableJAI)IDENTITY_TABLE);
        ImageWorker worker = new ImageWorker(source);
        worker.setRenderingHints(hints);
        worker.lookup(table);
        return worker.getRenderedImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RenderedImage directRasterRender(WMSMapContent mapContent, int layerIndex, List<GridCoverage2D> renderedCoverages, Interpolation layerInterpolation) throws IOException, FactoryException {
        RenderedImage image;
        int tileSizeY;
        int tileSizeX;
        Color bgColor;
        boolean transparent;
        Rectangle mapRasterArea;
        int mapHeight;
        int mapWidth;
        block63: {
            Interpolation interpolation;
            double scaleDenominator = mapContent.getScaleDenominator(true);
            Layer layer = (Layer)mapContent.layers().get(layerIndex);
            FeatureType featureType = layer.getFeatureSource().getSchema();
            Style style = layer.getStyle();
            RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(scaleDenominator, featureType);
            style.accept((StyleVisitor)visitor);
            List<RasterSymbolizer> symbolizers = visitor.getRasterSymbolizers();
            if (symbolizers.size() != 1) {
                return null;
            }
            RasterSymbolizer symbolizer = symbolizers.get(0);
            Expression transformation = visitor.getRasterRenderingTransformation();
            if (RenderedImageMapOutputFormat.isVectorSource(transformation)) {
                return null;
            }
            mapWidth = mapContent.getMapWidth();
            mapHeight = mapContent.getMapHeight();
            ReferencedEnvelope mapEnvelope = this.getEastNorthEnvelope(mapContent.getRenderingArea());
            CoordinateReferenceSystem mapCRS = mapEnvelope.getCoordinateReferenceSystem();
            mapRasterArea = new Rectangle(0, 0, mapWidth, mapHeight);
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapEnvelope, (Rectangle)mapRasterArea);
            transparent = mapContent.isTransparent() && this.isTransparencySupported();
            bgColor = mapContent.getBgColor();
            bgColor = transparent ? new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0) : new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255);
            if (layerInterpolation != null) {
                interpolation = layerInterpolation;
            } else {
                LayerInfo.WMSInterpolation byLayerInterpolation = null;
                if (mapContent.getRequest().getLayers().size() > layerIndex) {
                    LayerInfo layerInfo = mapContent.getRequest().getLayers().get(layerIndex).getLayerInfo();
                    byLayerInterpolation = RenderedImageMapOutputFormat.getConfiguredLayerInterpolation(layerInfo);
                }
                WMSInfo.WMSInterpolation byServiceInterpolation = null;
                if (byLayerInterpolation == null && this.wms != null) {
                    byServiceInterpolation = this.wms.getInterpolation();
                }
                interpolation = byLayerInterpolation != null ? RenderedImageMapOutputFormat.toInterpolationObject(byLayerInterpolation) : (byServiceInterpolation != null ? RenderedImageMapOutputFormat.toInterpolationObject(byServiceInterpolation) : Interpolation.getInstance((int)0));
            }
            tileSizeX = -1;
            tileSizeY = -1;
            if (mapContent.getTileSize() != -1) {
                tileSizeX = tileSizeY = mapContent.getTileSize();
            } else if (mapWidth < 1024 && mapHeight < 1024) {
                tileSizeX = mapWidth;
                tileSizeY = mapHeight;
            }
            int[] bandIndices = transformation == null ? ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels((RasterSymbolizer)symbolizer) : null;
            ReadingContext context = new ReadingContext();
            image = null;
            GridCoverage2D coverage = null;
            RenderingHints interpolationHints = new RenderingHints(JAI.KEY_INTERPOLATION, interpolation);
            try {
                GridGeometry2D readGG;
                boolean useGutter;
                Color readerBgColor;
                Color color = readerBgColor = transparent ? null : bgColor;
                if (transformation == null && this.wms.isAdvancedProjectionHandlingEnabled()) {
                    Feature feature = DataUtilities.first((FeatureCollection)((Layer)mapContent.layers().get(0)).getFeatureSource().getFeatures());
                    if (feature == null || feature.getProperty("grid") == null) {
                        return null;
                    }
                    GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
                    Object params = feature.getProperty("params").getValue();
                    GeneralParameterValue[] readParameters = RenderedImageMapOutputFormat.getReadParameters(params, null, null, interpolation, readerBgColor, bandIndices);
                    GridCoverageRenderer gcr = new GridCoverageRenderer(mapEnvelope.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapEnvelope, mapRasterArea, worldToScreen, interpolationHints);
                    gcr.setAdvancedProjectionHandlingEnabled(true);
                    gcr.setWrapEnabled(this.wms.isContinuousMapWrappingEnabled());
                    image = gcr.renderImage(reader, readParameters, symbolizer, interpolation, null, tileSizeX, tileSizeY);
                    if (image == null) {
                        image = RenderedImageMapOutputFormat.createBkgImage(mapWidth, mapHeight, bgColor, null);
                    }
                    break block63;
                }
                CoordinateReferenceSystem coverageCRS = layer.getFeatureSource().getSchema().getCoordinateReferenceSystem();
                boolean bl = useGutter = DISABLE_GUTTER == false;
                if (useGutter) {
                    boolean sameCRS;
                    boolean equalsMetadata = CRS.equalsIgnoreMetadata((Object)mapCRS, (Object)coverageCRS);
                    try {
                        sameCRS = equalsMetadata || CRS.findMathTransform((CoordinateReferenceSystem)mapCRS, (CoordinateReferenceSystem)coverageCRS, (boolean)true).isIdentity();
                    }
                    catch (FactoryException e1) {
                        IOException ioe = new IOException();
                        ioe.initCause(e1);
                        throw ioe;
                    }
                    boolean bl2 = useGutter = !sameCRS || !(interpolation instanceof InterpolationNearest);
                }
                if (!useGutter) {
                    readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(mapRasterArea), (Envelope)mapEnvelope);
                } else {
                    Rectangle bufferedTargetArea = (Rectangle)mapRasterArea.clone();
                    bufferedTargetArea.add(mapRasterArea.x + mapRasterArea.width + 10, mapRasterArea.y + mapRasterArea.height + 10);
                    bufferedTargetArea.add(mapRasterArea.x - 10, mapRasterArea.y - 10);
                    try {
                        readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, (MathTransform)new AffineTransform2D(worldToScreen.createInverse()), mapCRS, null);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (transformation != null) {
                    GCRRenderingTransformationHelper helper = new GCRRenderingTransformationHelper(mapContent, interpolation, this.wms.isAdvancedProjectionHandlingEnabled(), this.wms.isContinuousMapWrappingEnabled());
                    Object result = helper.applyRenderingTransformation(transformation, layer.getFeatureSource(), layer.getQuery(), Query.ALL, readGG, coverageCRS, interpolationHints);
                    if (result == null) {
                        coverage = null;
                    } else {
                        if (!(result instanceof GridCoverage2D)) return null;
                        coverage = (GridCoverage2D)result;
                        symbolizer = this.updateSymbolizerForBandSelection(context, symbolizer, bandIndices);
                    }
                } else {
                    Feature feature = ((Layer)mapContent.layers().get(0)).getFeatureSource().getFeatures().features().next();
                    GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
                    Object params = feature.getProperty("params").getValue();
                    context.reader = reader;
                    context.params = params;
                    coverage = RenderedImageMapOutputFormat.readBestCoverage(context, ReferencedEnvelope.reference((Envelope)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), interpolation, readerBgColor, bandIndices);
                    symbolizer = this.updateSymbolizerForBandSelection(context, symbolizer, bandIndices);
                }
                if (coverage == null) {
                    image = RenderedImageMapOutputFormat.createBkgImage(mapWidth, mapHeight, bgColor, null);
                }
                if (image == null) {
                    GridCoverageRenderer gcr = new GridCoverageRenderer(mapCRS, (org.locationtech.jts.geom.Envelope)ReferencedEnvelope.reference((Envelope)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), worldToScreen, interpolationHints);
                    gcr.setAdvancedProjectionHandlingEnabled(false);
                    image = gcr.renderImage(coverage, symbolizer, interpolation, null, tileSizeX, tileSizeY);
                }
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
        }
        if (image == null) {
            return null;
        }
        Rectangle imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds();
        Rectangle intersection = imageBounds.intersection(mapRasterArea);
        if (intersection.isEmpty()) {
            return null;
        }
        ImageLayout layout = new ImageLayout();
        layout.setMinX(0);
        layout.setMinY(0);
        layout.setWidth(mapWidth);
        layout.setHeight(mapHeight);
        if (tileSizeX > 0 && tileSizeY > 0) {
            layout.setTileGridXOffset(0);
            layout.setTileGridYOffset(0);
            layout.setTileWidth(tileSizeX);
            layout.setTileHeight(tileSizeY);
        }
        ColorModel cm = image.getColorModel();
        double[] bgValues = null;
        PlanarImage[] alphaChannels = null;
        ImageWorker worker = new ImageWorker(image);
        int transparencyType = cm.getTransparency();
        if (cm instanceof IndexColorModel) {
            int bgColorIndex;
            IndexColorModel icm = (IndexColorModel)cm;
            if (transparent) {
                bgColorIndex = icm.getTransparentPixel();
            } else if (icm.hasAlpha() && icm.isAlphaPremultiplied()) {
                bgColorIndex = -1;
            } else {
                if (icm.getTransparency() != 1) {
                    icm = ColorUtilities.applyBackgroundColor((IndexColorModel)icm, (Color)bgColor);
                    cm = icm;
                    ImageLayout ilColorModel = new ImageLayout(image);
                    ilColorModel.setColorModel((ColorModel)icm);
                    RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, ilColorModel);
                    worker.setRenderingHints(hints);
                    worker.format(image.getSampleModel().getDataType());
                    image = worker.getRenderedImage();
                }
                bgColorIndex = ColorUtilities.findColorIndex((Color)bgColor, (IndexColorModel)icm);
            }
            if (bgColorIndex == -1) {
                bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), transparent ? 0.0 : 255.0};
                worker.setBackground(bgValues);
                image = worker.forceComponentColorModel().getRenderedImage();
                if (transparent && !image.getColorModel().hasAlpha()) {
                    image = this.addAlphaChannel(image);
                    worker.setImage(image);
                }
                cm = image.getColorModel();
            } else {
                bgValues = new double[]{bgColorIndex};
            }
            if (cm.hasAlpha() && bgColorIndex == -1) {
                worker.forceComponentColorModel();
                RenderedImage alpha = worker.retainLastBand().getRenderedImage();
                alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
            }
        }
        boolean noDataTransparencyApplied = false;
        if (cm instanceof ComponentColorModel) {
            RenderedImage alpha;
            ImageWorker iw;
            ComponentColorModel ccm = (ComponentColorModel)cm;
            boolean hasAlpha = cm.hasAlpha();
            if (ccm.getNumColorComponents() == 1) {
                if (!RenderedImageMapOutputFormat.isLevelOfGray(bgColor) && !transparent || ccm.getTransferType() == 5 || ccm.getTransferType() == 4 || ccm.getTransferType() == 32) {
                    iw = new ImageWorker(image);
                    if (hasAlpha) {
                        alpha = iw.retainLastBand().getRenderedImage();
                        RenderedImage gray = new ImageWorker(image).retainFirstBand().getRenderedImage();
                        image = new ImageWorker(gray).bandMerge(3).addBand(alpha, false).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    } else {
                        image = iw.bandMerge(3).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    }
                } else if (!hasAlpha) {
                    if (transparent) {
                        RenderedImage transparentImage = this.grayNoDataTransparent(image);
                        if (transparentImage == null) {
                            image = this.addAlphaChannel(image);
                            bgValues = new double[]{this.mapToGrayColor(bgColor, ccm), 0.0};
                        } else {
                            image = transparentImage;
                            noDataTransparencyApplied = true;
                        }
                    } else {
                        bgValues = new double[]{this.mapToGrayColor(bgColor, ccm)};
                    }
                } else {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{this.mapToGrayColor(bgColor, ccm), 0.0} : new double[]{this.mapToGrayColor(bgColor, ccm), 255.0};
                }
                cm = image.getColorModel();
                ccm = (ComponentColorModel)cm;
                hasAlpha = cm.hasAlpha();
            }
            if (bgValues == null && !noDataTransparencyApplied) {
                if (hasAlpha) {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0.0} : new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255.0};
                } else if (transparent) {
                    RenderedImage imageTransparent = this.rgbNoDataTransparent(image);
                    if (imageTransparent != null) {
                        image = imageTransparent;
                        noDataTransparencyApplied = true;
                    } else {
                        image = this.addAlphaChannel(image);
                        bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                    }
                } else {
                    bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
                }
            }
        }
        ImageWorker iw = new ImageWorker(image);
        Object roiCandidate = image.getProperty("ROI");
        if (!imageBounds.contains(mapRasterArea) && !imageBounds.equals(mapRasterArea) || transparencyType != 1 || iw.getNoData() != null || roiCandidate instanceof ROI) {
            image = this.applyBackgroundTransparency(mapRasterArea, image, intersection, layout, bgValues, alphaChannels, transparencyType, iw, roiCandidate, noDataTransparencyApplied);
        } else if (imageBounds.contains(mapRasterArea) && !imageBounds.equals(mapRasterArea)) {
            iw.setBackground(bgValues);
            iw.crop(0.0f, 0.0f, (float)mapWidth, (float)mapHeight);
            image = iw.getRenderedImage();
        }
        if (LOGGER.isLoggable(Level.FINE) && image != null) {
            LOGGER.log(Level.FINE, "Direct rendering path produced the following image chain:\n" + RenderedImageBrowser.dumpChain((RenderedImage)image));
        }
        Map<String, String> rawKvp = null;
        if (!RASTER_CHAIN_DEBUG.booleanValue() || (rawKvp = mapContent.getRequest().getRawKvp()) == null || !Boolean.valueOf(rawKvp.get("showchain")).booleanValue()) return image;
        RenderedImageBrowser.showChainAndWaitOnClose((RenderedImage)image);
        return image;
    }

    private RenderedImage applyBackgroundTransparency(Rectangle mapRasterArea, RenderedImage image, Rectangle intersection, ImageLayout layout, double[] bgValues, PlanarImage[] alphaChannels, int transparencyType, ImageWorker iw, Object roiCandidate, boolean preProcessedWithTransparency) {
        double[][] dArrayArray;
        ROI[] rois;
        ROI[] rOIArray;
        ROIShape roi;
        if (roiCandidate instanceof ROI) {
            ROI imageROI = (ROI)roiCandidate;
            try {
                roi = new ROIGeometry(mapRasterArea).intersect(imageROI);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed to intersect image ROI with target bounds, returning empty result", e);
                }
                return null;
            }
        } else {
            roi = new ROIShape((Shape)(!intersection.isEmpty() ? intersection : mapRasterArea));
        }
        if (!preProcessedWithTransparency) {
            ROI[] rOIArray2 = new ROI[1];
            rOIArray = rOIArray2;
            rOIArray2[0] = roi;
        } else {
            rOIArray = rois = null;
        }
        if (!preProcessedWithTransparency) {
            double[][] dArrayArray2 = new double[1][];
            dArrayArray = dArrayArray2;
            dArrayArray2[0] = new double[]{ColorUtilities.getThreshold((int)image.getSampleModel().getDataType())};
        } else {
            dArrayArray = null;
        }
        double[][] thresholds = dArrayArray;
        iw.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
        iw.setBackground(bgValues);
        iw.mosaic(new RenderedImage[]{image}, alphaChannels != null && transparencyType == 3 ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, alphaChannels, rois, (double[][])thresholds, null);
        image = iw.getRenderedImage();
        return image;
    }

    private static boolean isVectorSource(Expression tranformation) {
        if (tranformation instanceof ProcessFunction) {
            ProcessFunction processFunction = (ProcessFunction)tranformation;
            Name processName = processFunction.getProcessName();
            Map params = Processors.getParameterInfo((Name)processName);
            for (org.geotools.data.Parameter param : params.values()) {
                if (!SimpleFeatureCollection.class.isAssignableFrom(param.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private RasterSymbolizer updateSymbolizerForBandSelection(ReadingContext context, RasterSymbolizer symbolizer, int[] bandIndices) {
        Object params;
        GridCoverage2DReader reader = context != null ? context.reader : null;
        Object object = params = context != null ? context.params : null;
        if (params != null && reader != null && bandIndices != null) {
            Format format = reader.getFormat();
            ParameterValueGroup readParameters = null;
            ParameterDescriptorGroup descriptorGroup = null;
            List descriptors = null;
            if (format != null && (readParameters = format.getReadParameters()) != null && (descriptorGroup = readParameters.getDescriptor()) != null && (descriptors = descriptorGroup.descriptors()) != null && descriptors.contains(AbstractGridFormat.BANDS) && bandIndices != null) {
                symbolizer = GridCoverageRenderer.setupSymbolizerForBandsSelection((RasterSymbolizer)symbolizer);
            }
        }
        return symbolizer;
    }

    private ReferencedEnvelope getEastNorthEnvelope(ReferencedEnvelope envelope) throws FactoryException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) != CRS.AxisOrder.NORTH_EAST) {
            return envelope;
        }
        Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        if (epsg == null) {
            return envelope;
        }
        CoordinateReferenceSystem eastNorthCrs = CRS.decode((String)("EPSG:" + epsg), (boolean)true);
        return new ReferencedEnvelope(envelope.getMinY(), envelope.getMaxY(), envelope.getMinX(), envelope.getMaxX(), eastNorthCrs);
    }

    private RenderedImage rgbNoDataTransparent(RenderedImage image) {
        return this.makeNoDataTransparent(image, 3);
    }

    private RenderedImage grayNoDataTransparent(RenderedImage image) {
        return this.makeNoDataTransparent(image, 1);
    }

    private RenderedImage makeNoDataTransparent(RenderedImage image, int numBands) {
        int maxValue;
        int minValue;
        ImageWorker iw = new ImageWorker(image);
        Range noData = iw.getNoData();
        ColorModel cm = image.getColorModel();
        int numColorBands = cm.getNumColorComponents();
        if (noData != null && image.getSampleModel().getDataType() == 0 && numColorBands == numBands && cm instanceof ComponentColorModel && (minValue = noData.getMin().intValue()) == (maxValue = noData.getMax().intValue()) && minValue >= -128 && minValue <= 127) {
            Color transparentColor = new Color(minValue, minValue, minValue);
            iw.makeColorTransparent(transparentColor);
            return iw.getRenderedImage();
        }
        return null;
    }

    private RenderedImage addAlphaChannel(RenderedImage image) {
        ImageLayout tempLayout = new ImageLayout(image);
        tempLayout.unsetValid(512).unsetValid(256);
        RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(image.getWidth()), (Float)Float.valueOf(image.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
        ImageWorker iw = new ImageWorker(image);
        iw.addBand((RenderedImage)alpha, false, true, null);
        return iw.getRenderedImage();
    }

    double mapToGrayColor(Color gray, ComponentColorModel cm) {
        double[] rescaleFactors = new double[33];
        rescaleFactors[0] = 1.0;
        rescaleFactors[2] = 255.0;
        rescaleFactors[3] = 8421504.0;
        rescaleFactors[1] = 512.0;
        rescaleFactors[5] = 0.00392156862745098;
        rescaleFactors[4] = 0.00392156862745098;
        rescaleFactors[32] = 1.0;
        return (double)gray.getRed() / rescaleFactors[cm.getTransferType()];
    }

    private static boolean isLevelOfGray(Color color) {
        return color.getRed() == color.getBlue() && color.getRed() == color.getGreen();
    }

    private static final RenderedImage createBkgImage(float width, float height, Color bgColor, RenderingHints renderingHints) {
        Number[] bands = new Byte[]{(byte)bgColor.getRed(), (byte)bgColor.getGreen(), (byte)bgColor.getBlue(), (byte)bgColor.getAlpha()};
        return ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bands, (RenderingHints)renderingHints);
    }

    private static GridCoverage2D readBestCoverage(ReadingContext context, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor, int[] bandIndices) throws IOException {
        GridCoverage2DReader reader = context.reader;
        Object params = context.params;
        GeneralParameterValue[] readParams = RenderedImageMapOutputFormat.getReadParameters(params, envelope, requestedRasterArea, interpolation, bgColor, bandIndices);
        GridCoverage2D coverage = reader.read(readParams);
        context.params = readParams;
        return coverage;
    }

    private static GeneralParameterValue[] getReadParameters(Object params, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor, int[] bandIndices) {
        GeneralParameterValue[] readParams;
        int length;
        Parameter bgColorParam;
        Parameter readGG = null;
        if (envelope != null) {
            readGG = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            readGG.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(requestedRasterArea), (Envelope)envelope));
        }
        Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
        readInterpolation.setValue((Object)interpolation);
        if (bgColor != null) {
            bgColorParam = (Parameter)AbstractGridFormat.BACKGROUND_COLOR.createValue();
            bgColorParam.setValue((Object)bgColor);
        } else {
            bgColorParam = null;
        }
        Parameter bandIndicesParam = null;
        if (bandIndices != null) {
            bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
            bandIndicesParam.setValue((Object)bandIndices);
        }
        int n = length = (readParams = (GeneralParameterValue[])params) == null ? 0 : readParams.length;
        if (length > 0) {
            String readGGName = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            String readInterpolationName = ImageMosaicFormat.INTERPOLATION.getName().toString();
            String bgColorName = AbstractGridFormat.BACKGROUND_COLOR.getName().toString();
            String bandsListName = AbstractGridFormat.BANDS.getName().toString();
            boolean foundInterpolation = false;
            boolean foundGG = false;
            boolean foundBgColor = false;
            boolean foundBandIndices = false;
            for (int i = 0; i < length; ++i) {
                String paramName = readParams[i].getDescriptor().getName().toString();
                if (paramName.equalsIgnoreCase(readGGName) && readGG != null) {
                    ((Parameter)readParams[i]).setValue((Object)readGG);
                    foundGG = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(readInterpolationName)) {
                    ((Parameter)readParams[i]).setValue((Object)interpolation);
                    foundInterpolation = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(bgColorName) && bgColor != null) {
                    ((Parameter)readParams[i]).setValue((Object)bgColor);
                    foundBgColor = true;
                    continue;
                }
                if (!paramName.equalsIgnoreCase(bandsListName) || bandIndices == null) continue;
                ((Parameter)readParams[i]).setValue((Object)bandIndices);
                foundBandIndices = true;
            }
            if (!(foundGG && foundInterpolation && foundBgColor && bgColor != null && foundBandIndices)) {
                ArrayList<Object> paramList = new ArrayList<Object>();
                paramList.addAll(Arrays.asList(readParams));
                if (!foundGG && readGG != null) {
                    paramList.add(readGG);
                }
                if (!foundInterpolation) {
                    paramList.add(readInterpolation);
                }
                if (!foundBgColor && bgColor != null) {
                    paramList.add(bgColorParam);
                }
                if (!foundBandIndices && bandIndices != null) {
                    paramList.add(bandIndicesParam);
                }
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
        } else {
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            if (readGG != null) {
                paramList.add(readGG);
            }
            if (bgColor != null) {
                paramList.add(bgColorParam);
            }
            if (bandIndices != null) {
                paramList.add(bandIndicesParam);
            }
            paramList.add(readInterpolation);
            readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
        }
        return readParams;
    }

    private static LayerInfo.WMSInterpolation getConfiguredLayerInterpolation(LayerInfo layer) {
        LayerInfo.WMSInterpolation configuredInterpolation = null;
        if (layer != null && layer.getDefaultWMSInterpolationMethod() != null) {
            try {
                configuredInterpolation = layer.getDefaultWMSInterpolationMethod();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return configuredInterpolation;
    }

    private static Interpolation toInterpolationObject(LayerInfo.WMSInterpolation interpolationMethod) {
        if (interpolationMethod == null) {
            return null;
        }
        switch (interpolationMethod) {
            case Bilinear: {
                return Interpolation.getInstance((int)1);
            }
            case Bicubic: {
                return Interpolation.getInstance((int)2);
            }
        }
        return Interpolation.getInstance((int)0);
    }

    private static Interpolation toInterpolationObject(WMSInfo.WMSInterpolation interpolationMethod) {
        if (interpolationMethod == null) {
            return null;
        }
        switch (interpolationMethod) {
            case Bilinear: {
                return Interpolation.getInstance((int)1);
            }
            case Bicubic: {
                return Interpolation.getInstance((int)2);
            }
        }
        return Interpolation.getInstance((int)0);
    }

    private class GCRRenderingTransformationHelper
    extends RenderingTransformationHelper {
        private final Interpolation interpolation;
        private final boolean advancedProjectionHandling;
        private final boolean mapWrapping;
        private final WMSMapContent mapContent;

        public GCRRenderingTransformationHelper(WMSMapContent mapContent, Interpolation interpolation, boolean advancedProjectionHandling, boolean mapWrapping) {
            this.mapContent = mapContent;
            this.interpolation = interpolation;
            this.advancedProjectionHandling = advancedProjectionHandling;
            this.mapWrapping = mapWrapping;
        }

        protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object readParams, GridGeometry2D readGG) throws IOException {
            RenderingHints interpolationHints = new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation);
            try {
                int mapWidth = this.mapContent.getMapWidth();
                int mapHeight = this.mapContent.getMapHeight();
                ReferencedEnvelope mapEnvelope = RenderedImageMapOutputFormat.this.getEastNorthEnvelope(this.mapContent.getRenderingArea());
                Rectangle mapRasterArea = new Rectangle(0, 0, mapWidth, mapHeight);
                AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapEnvelope, (Rectangle)mapRasterArea);
                GridCoverageRenderer gcr = new GridCoverageRenderer(mapEnvelope.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapEnvelope, mapRasterArea, worldToScreen, interpolationHints);
                gcr.setAdvancedProjectionHandlingEnabled(this.advancedProjectionHandling);
                gcr.setWrapEnabled(this.mapWrapping);
                RenderedImage ri = gcr.renderImage(reader, (GeneralParameterValue[])readParams, null, this.interpolation, null, 256, 256);
                if (ri != null) {
                    PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)ri);
                    GridCoverage2D gc2d = (GridCoverage2D)pi.getProperty("ParentCoverage");
                    return gc2d;
                }
                return null;
            }
            catch (NoninvertibleTransformException | FactoryException | TransformException e) {
                throw new IOException("Failure rendering the coverage", e);
            }
        }
    }

    static class ReadingContext {
        GridCoverage2DReader reader;
        Object params;

        ReadingContext() {
        }
    }
}

