/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.media.jai.Interpolation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSErrorCode;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.clip.ClipWMSGetMapCallBack;
import org.geoserver.wms.map.ProcessStandaloneSLDVisitor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.renderer.style.StyleAttributeExtractor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class GetMapKvpRequestReader
extends KvpRequestReader
implements DisposableBean {
    private static Map<String, Integer> interpolationMethods = new HashMap<String, Integer>();
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private boolean parseStyles = true;
    private WMS wms;
    EntityResolverProvider entityResolverProvider;
    CloseableHttpClient httpClient;
    private CacheConfiguration cacheCfg;
    private boolean laxStyleMatchAllowed = true;

    public GetMapKvpRequestReader(WMS wms) {
        this(wms, null);
        this.wms = wms;
    }

    public GetMapKvpRequestReader(final WMS wms, final HttpClientConnectionManager manager) {
        super(GetMapRequest.class);
        this.wms = wms;
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        int timeoutMillis = this.getTimeoutMillis();
        builder.setConnectTimeout(timeoutMillis);
        builder.setSocketTimeout(timeoutMillis);
        final RequestConfig requestConfig = builder.build();
        wms.getGeoServer().addListener((ConfigurationListener)new ConfigurationListenerAdapter(){

            public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                WMSInfo info;
                CacheConfiguration newCacheCfg;
                if (service instanceof WMSInfo && !(newCacheCfg = (info = (WMSInfo)service).getCacheConfiguration()).equals(GetMapKvpRequestReader.this.cacheCfg)) {
                    GetMapKvpRequestReader.this.createHttpClient(wms, manager, requestConfig, (CacheConfiguration)newCacheCfg.clone());
                }
            }
        });
        this.entityResolverProvider = new EntityResolverProvider(wms.getGeoServer());
        this.createHttpClient(wms, manager, requestConfig, (CacheConfiguration)wms.getRemoteResourcesCacheConfiguration().clone());
    }

    private int getTimeoutMillis() {
        return this.wms.getServiceInfo().getRemoteStyleTimeout();
    }

    private synchronized void createHttpClient(WMS wms, HttpClientConnectionManager manager, RequestConfig requestConfig, CacheConfiguration cfg) {
        this.cacheCfg = cfg;
        if (cfg != null && cfg.isEnabled()) {
            CacheConfig cacheConfig;
            block5: {
                cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.cacheCfg.getMaxEntries()).setMaxObjectSize(this.cacheCfg.getMaxEntrySize()).build();
                if (this.httpClient != null) {
                    try {
                        this.httpClient.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                        LOGGER.log(Level.SEVERE, "Error closing HTTPClient", e);
                    }
                }
            }
            this.httpClient = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setConnectionManager(manager).setDefaultRequestConfig(requestConfig).build();
        } else {
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        }
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isParseStyle() {
        return this.parseStyles;
    }

    public void setParseStyle(boolean styleRequired) {
        this.parseStyles = styleRequired;
    }

    public GetMapRequest createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest();
        HttpServletRequest httpRequest = Optional.ofNullable((Request)Dispatcher.REQUEST.get()).map(r -> r.getHttpRequest()).orElse(null);
        if (httpRequest != null) {
            request.setRequestCharset(httpRequest.getCharacterEncoding());
            request.setGet("GET".equalsIgnoreCase(httpRequest.getMethod()));
            List headerNames = EnumerationUtils.toList((Enumeration)httpRequest.getHeaderNames());
            for (String headerName : headerNames) {
                request.putHttpRequestHeader(headerName, httpRequest.getHeader(headerName));
            }
        }
        return request;
    }

    protected boolean skipResource(Object theResource) {
        return false;
    }

    public GetMapRequest read(Object request, Map kvp, Map rawKvp) throws Exception {
        List<List<SortBy>> sortBy;
        String remoteOwsType;
        String trans;
        GetMapRequest getMap = (GetMapRequest)super.read(request, kvp, rawKvp);
        getMap.setRawKvp(rawKvp);
        boolean citeCompliant = this.wms.getServiceInfo().isCiteCompliant();
        if (kvp.containsKey("crs")) {
            getMap.setSRS((String)kvp.get("crs"));
        } else if (citeCompliant && WMS.VERSION_1_3_0.equals((Object)WMS.version(getMap.getVersion()))) {
            throw new ServiceException("GetMap CRS parameter is mandatory in WMS 1.3");
        }
        if (citeCompliant && rawKvp != null && rawKvp.containsKey("transparent") && !(trans = (String)rawKvp.get("transparent")).equalsIgnoreCase("false") && !trans.equalsIgnoreCase("true")) {
            throw new Exception("Invalid value of GetMap TRANSPARENT parameter, choose between true or false");
        }
        String epsgCode = getMap.getSRS();
        epsgCode = WMS.toInternalSRS(epsgCode, WMS.version(getMap.getVersion()));
        getMap.setSRS(epsgCode);
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new ServiceException("Error occurred decoding the espg code " + epsgCode, (Throwable)e, WMSErrorCode.INVALID_CRS.get(getMap.getVersion()));
            }
        }
        String string = remoteOwsType = (remoteOwsType = getMap.getRemoteOwsType()) != null ? remoteOwsType.toUpperCase() : null;
        if (remoteOwsType != null && !"WFS".equals(remoteOwsType)) {
            throw new ServiceException("Unsupported remote OWS type '" + remoteOwsType + "'");
        }
        URL remoteOwsUrl = getMap.getRemoteOwsURL();
        if (remoteOwsUrl != null && remoteOwsType == null) {
            throw new ServiceException("REMOTE_OWS_URL specified, but REMOTE_OWS_TYPE is missing");
        }
        ArrayList<Object> requestedLayerInfos = new ArrayList<Object>();
        String layerParam = (String)rawKvp.get("LAYERS");
        if (layerParam != null) {
            List layerNames = KvpUtils.readFlat((String)layerParam);
            requestedLayerInfos.addAll(this.parseLayers(layerNames, remoteOwsUrl, remoteOwsType));
        } else if (citeCompliant && getMap.getSldBody() == null && getMap.getSld() == null) {
            throw new ServiceException("GetMap LAYERS parameter is mandatory if SLD nor SLD_BODY are not specified");
        }
        String stylesParam = (String)kvp.get("STYLES");
        ArrayList<String> styleNameList = new ArrayList<String>();
        if (stylesParam != null) {
            styleNameList.addAll(KvpUtils.readFlat((String)stylesParam));
        } else if (citeCompliant && getMap.getSldBody() == null && getMap.getSld() == null) {
            throw new ServiceException("GetMap STYLES parameter is mandatory if SLD nor SLD_BODY are not specified");
        }
        String interpolationParam = (String)kvp.get("INTERPOLATIONS");
        ArrayList<String> interpolationList = new ArrayList<String>();
        if (interpolationParam != null) {
            interpolationList.addAll(KvpUtils.readFlat((String)interpolationParam));
        }
        ArrayList<Filter> rawFilters = getMap.getFilter() != null ? new ArrayList<Filter>(getMap.getFilter()) : Collections.emptyList();
        ArrayList<Filter> cqlFilters = getMap.getCQLFilter() != null ? new ArrayList<Filter>(getMap.getCQLFilter()) : Collections.emptyList();
        List<List<SortBy>> rawSortBy = Optional.ofNullable(getMap.getSortBy()).orElse(Collections.emptyList());
        ArrayList<MapLayerInfo> newLayers = new ArrayList<MapLayerInfo>();
        int i = 0;
        while (i < requestedLayerInfos.size()) {
            Object o = requestedLayerInfos.get(i);
            if (this.skipResource(o)) {
                requestedLayerInfos.remove(i);
                if (i < styleNameList.size()) {
                    styleNameList.remove(i);
                }
                if (i < interpolationList.size()) {
                    interpolationList.remove(i);
                }
                if (i < rawFilters.size()) {
                    rawFilters.remove(i);
                }
                if (i < cqlFilters.size()) {
                    cqlFilters.remove(i);
                }
                if (i >= rawSortBy.size()) continue;
                rawSortBy.remove(i);
                continue;
            }
            if (o instanceof LayerInfo) {
                newLayers.add(new MapLayerInfo((LayerInfo)o));
            } else if (o instanceof LayerGroupInfo) {
                for (LayerInfo l : ((LayerGroupInfo)o).layers()) {
                    newLayers.add(new MapLayerInfo(l));
                }
            } else if (o instanceof MapLayerInfo) {
                newLayers.add((MapLayerInfo)o);
            }
            ++i;
        }
        getMap.setLayers(newLayers);
        if (interpolationList.size() > 0) {
            getMap.setInterpolations(this.parseInterpolations(requestedLayerInfos, interpolationList));
        }
        List<Filter> filters = this.parseFilters(getMap, rawFilters, cqlFilters);
        List<List<SortBy>> list = sortBy = rawSortBy.isEmpty() ? null : rawSortBy;
        if ((getMap.getSldBody() != null || getMap.getSld() != null) && this.wms.isDynamicStylingDisabled()) {
            throw new ServiceException("Dynamic style usage is forbidden");
        }
        if (getMap.getSldBody() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            if (getMap.getValidateSchema().booleanValue()) {
                try (StringReader reader = new StringReader(getMap.getSldBody());){
                    List errors = this.validateStyle(reader, getMap);
                    if (errors.size() != 0) {
                        throw new ServiceException(SLDValidator.getErrorMessage((Reader)new StringReader(getMap.getSldBody()), (List)errors));
                    }
                }
            }
            try (StringReader input = new StringReader(getMap.getSldBody());){
                StyledLayerDescriptor sld = this.parseStyle(getMap, input);
                this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
            }
            getMap.setFilter(filters);
            getMap.setSortBy(sortBy);
        } else if (getMap.getSld() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from reomte SLD");
            }
            URL styleUrl = getMap.getStyleUrl();
            InputStream input = null;
            if (styleUrl.getProtocol().toLowerCase().indexOf("http") == 0) {
                input = this.getHttpInputStream(styleUrl);
            } else {
                try {
                    input = Requests.getInputStream((URL)styleUrl);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Exception while getting SLD.", ex);
                    throw new ServiceException("Error while getting SLD.");
                }
            }
            if (input != null) {
                try (InputStreamReader reader = new InputStreamReader(input);){
                    List errors;
                    if (getMap.getValidateSchema().booleanValue() && (errors = this.validateStyle(input, getMap)) != null && errors.size() != 0) {
                        throw new ServiceException(SLDValidator.getErrorMessage((InputStream)input, (List)errors));
                    }
                    StyledLayerDescriptor sld = this.parseStyle(getMap, reader);
                    this.processSld(getMap, requestedLayerInfos, sld, styleNameList);
                }
                catch (Exception ex) {
                    Level l = Level.WARNING;
                    if (ex.getCause() instanceof SAXException && ex.getCause().getMessage().contains("Entity resolution disallowed")) {
                        throw ex;
                    }
                    LOGGER.log(l, "Exception while getting SLD.", ex);
                    if (LOGGER.isLoggable(l)) {
                        throw new ServiceException("Error while getting SLD.  See the log for details.");
                    }
                    throw new ServiceException("Error while getting SLD.");
                }
                finally {
                    input.close();
                }
            }
            getMap.setFilter(filters);
            getMap.setSortBy(sortBy);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
            }
            if (styleNameList.size() > 0) {
                List<Style> parseStyles = this.parseStyles(styleNameList, requestedLayerInfos);
                getMap.setStyles(parseStyles);
            }
            if (this.isParseStyle() && requestedLayerInfos.size() > 0) {
                ArrayList<Style> oldStyles = getMap.getStyles() != null ? new ArrayList<Style>(getMap.getStyles()) : new ArrayList();
                ArrayList<Style> newStyles = new ArrayList<Style>();
                ArrayList<Filter> newFilters = filters == null ? null : new ArrayList<Filter>();
                ArrayList<List<SortBy>> newSortBy = sortBy == null ? null : new ArrayList<List<SortBy>>();
                for (int i2 = 0; i2 < requestedLayerInfos.size(); ++i2) {
                    Style style;
                    Object o = requestedLayerInfos.get(i2);
                    Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i2);
                    if (o instanceof LayerGroupInfo) {
                        int j;
                        LayerGroupInfo groupInfo = (LayerGroupInfo)o;
                        List layers = groupInfo.layers();
                        List styles = groupInfo.styles();
                        for (j = 0; j < styles.size(); ++j) {
                            StyleInfo si = (StyleInfo)styles.get(j);
                            if (si != null) {
                                newStyles.add(si.getStyle());
                                continue;
                            }
                            LayerInfo layer = (LayerInfo)layers.get(j);
                            newStyles.add(this.getDefaultStyle(layer));
                        }
                        if (filters != null) {
                            for (j = 0; j < layers.size(); ++j) {
                                newFilters.add(this.getFilter(filters, i2));
                            }
                        }
                        if (sortBy == null) continue;
                        for (j = 0; j < layers.size(); ++j) {
                            newSortBy.add(this.getSortBy(sortBy, i2));
                        }
                        continue;
                    }
                    if (o instanceof LayerInfo) {
                        Style style3 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i2) : null;
                        if (style != null) {
                            newStyles.add(style);
                        } else {
                            LayerInfo layer = (LayerInfo)o;
                            newStyles.add(this.getDefaultStyle(layer));
                        }
                        if (filters != null) {
                            newFilters.add(this.getFilter(filters, i2));
                        }
                        if (sortBy == null) continue;
                        newSortBy.add(this.getSortBy(sortBy, i2));
                        continue;
                    }
                    if (!(o instanceof MapLayerInfo)) continue;
                    Style style4 = style = oldStyles.size() > 0 ? (Style)oldStyles.get(i2) : null;
                    if (style == null) {
                        throw new ServiceException("no style requested for layer " + ((MapLayerInfo)o).getName(), "NoDefaultStyle");
                    }
                    newStyles.add(style);
                    if (filters != null) {
                        newFilters.add(this.getFilter(filters, i2));
                    }
                    if (sortBy == null) continue;
                    newSortBy.add(this.getSortBy(sortBy, i2));
                }
                getMap.setStyles(newStyles);
                getMap.setFilter(newFilters);
                getMap.setSortBy(newSortBy);
            }
            List<MapLayerInfo> layers = getMap.getLayers();
            if (this.isParseStyle() && layers != null && layers.size() > 0) {
                List<Style> styles = getMap.getStyles();
                if (layers.size() != styles.size()) {
                    String msg = layers.size() + " layers requested, but found " + styles.size() + " styles specified. ";
                    throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
                }
                for (int i3 = 0; i3 < styles.size(); ++i3) {
                    Style currStyle = getMap.getStyles().get(i3);
                    if (currStyle == null) {
                        throw new ServiceException("Could not find a style for layer " + getMap.getLayers().get(i3).getName() + ", either none was specified or no default style is available for it", "NoDefaultStyle");
                    }
                    GetMapKvpRequestReader.checkStyle(currStyle, layers.get(i3));
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(new StringBuffer("establishing ").append(currStyle.getName()).append(" style for ").append(layers.get(i3).getName()).toString());
                }
            }
            List mapFilters = getMap.getFilter();
            List<MapLayerInfo> mapLayers = getMap.getLayers();
            if (mapFilters != null && mapFilters.size() != mapLayers.size()) {
                String msg = mapLayers.size() + " layers requested, but found " + mapFilters.size() + " filters specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
            List<List<SortBy>> mapSortBy = getMap.getSortBy();
            if (mapSortBy != null && mapSortBy.size() != mapLayers.size()) {
                String msg = mapLayers.size() + " layers requested, but found " + mapSortBy.size() + " sortBy specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        List<Map<String, String>> viewParams = getMap.getViewParams();
        if (viewParams != null && viewParams.size() > 0) {
            int layerCount = getMap.getLayers().size();
            if (viewParams.size() == 1 && layerCount > 1) {
                ArrayList<Map<String, String>> replacement = new ArrayList<Map<String, String>>();
                for (int i4 = 0; i4 < layerCount; ++i4) {
                    replacement.add(viewParams.get(0));
                }
                getMap.setViewParams(replacement);
            } else if (viewParams.size() != layerCount) {
                String msg = layerCount + " layers requested, but found " + viewParams.size() + " view params specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        boolean hasTime = false;
        boolean hasElevation = false;
        for (MapLayerInfo layer : getMap.getLayers()) {
            GridCoverage2DReader reader;
            MetadataMap metadata;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                metadata = layer.getResource().getMetadata();
                DimensionInfo elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class);
                hasElevation |= elevationInfo != null && elevationInfo.isEnabled();
                DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
                hasTime |= timeInfo != null && timeInfo.isEnabled();
                continue;
            }
            if (layer.getType() != MapLayerInfo.TYPE_RASTER) continue;
            metadata = layer.getResource().getMetadata();
            try {
                reader = (GridCoverage2DReader)layer.getCoverageReader();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            if (reader == null) continue;
            ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
            DimensionInfo elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class);
            hasElevation |= elevationInfo != null && elevationInfo.isEnabled() && dimensions.hasElevation();
            DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
            hasTime |= timeInfo != null && timeInfo.isEnabled() && dimensions.hasTime();
        }
        if (hasTime && (getMap.getTime() == null || getMap.getTime().isEmpty())) {
            getMap.setTime(Arrays.asList(new Object[]{null}));
        }
        if (hasElevation && (getMap.getElevation() == null || getMap.getElevation().isEmpty())) {
            getMap.setElevation(Arrays.asList(new Object[]{null}));
        }
        if (getMap.getElevation() != null && getMap.getElevation().size() > 1 && getMap.getTime() != null && getMap.getTime().size() > 1) {
            throw new ServiceException("TIME and ELEVATION values cannot be both multivalued");
        }
        if (rawKvp.get("clip") != null) {
            getMap.setClip(this.getClipGeometry(getMap));
        }
        return getMap;
    }

    private InputStream getHttpInputStream(URL styleUrl) throws IOException {
        InputStream input = null;
        HttpCacheContext cacheContext = HttpCacheContext.create();
        try (CloseableHttpResponse response = null;){
            CacheResponseStatus responseStatus;
            HttpGet httpget = new HttpGet(styleUrl.toExternalForm());
            response = this.executeRequest(cacheContext, httpget);
            if (cacheContext != null && (responseStatus = cacheContext.getCacheResponseStatus()) != null) {
                switch (responseStatus) {
                    case CACHE_HIT: {
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("A response was generated from the cache with no requests sent upstream");
                        break;
                    }
                    case CACHE_MODULE_RESPONSE: {
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("The response was generated directly by the caching module");
                        break;
                    }
                    case CACHE_MISS: {
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("The response came from an upstream server");
                        break;
                    }
                    case VALIDATED: {
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("The response was generated from the cache after validating the entry with the origin server");
                    }
                }
            }
            input = response.getEntity().getContent();
            ByteArrayInputStream styleData = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)input));
            input.close();
            input = styleData;
            input.reset();
            InputStream inputStream = input;
            return inputStream;
        }
    }

    private CloseableHttpResponse executeRequest(HttpCacheContext cacheContext, final HttpGet httpget) throws IOException, ClientProtocolException {
        int hardTimeout = this.wms.getServiceInfo().getRemoteStyleMaxRequestTime();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (httpget != null) {
                    httpget.abort();
                }
            }
        };
        new Timer(true).schedule(task, hardTimeout);
        return this.httpClient.execute((HttpUriRequest)httpget, (HttpContext)cacheContext);
    }

    private List<Interpolation> parseInterpolations(List<Object> requestedLayers, List<String> interpolationList) {
        ArrayList<Interpolation> interpolations = new ArrayList<Interpolation>();
        for (int i = 0; i < requestedLayers.size(); ++i) {
            Object o;
            String interpolationName;
            Interpolation interpolation = null;
            if (i < interpolationList.size() && !(interpolationName = interpolationList.get(i)).trim().equals("")) {
                interpolation = this.getInterpolationObject(interpolationName);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                interpolations.add(interpolation);
                continue;
            }
            if (o instanceof LayerGroupInfo) {
                List subLayers = ((LayerGroupInfo)o).layers();
                interpolations.addAll(Collections.nCopies(subLayers.size(), interpolation));
                continue;
            }
            throw new IllegalArgumentException("Unknown layer info type: " + o);
        }
        return interpolations;
    }

    private Interpolation getInterpolationObject(String interpolation) {
        return Interpolation.getInstance((int)interpolationMethods.get(interpolation.toUpperCase()));
    }

    private Style getDefaultStyle(LayerInfo layer) throws IOException {
        if (layer.getResource() instanceof WMSLayerInfo) {
            NamedStyle namedStyle = CommonFactoryFinder.getStyleFactory(null).createNamedStyle();
            namedStyle.setName(null);
            return namedStyle;
        }
        StyleInfo defaultStyle = layer.getDefaultStyle();
        return defaultStyle.getStyle();
    }

    Filter getFilter(List<Filter> filters, int index) {
        if (filters.size() == 1 && filters.get(0) instanceof Id) {
            return filters.get(0);
        }
        if (index < filters.size()) {
            return filters.get(index);
        }
        throw new ServiceException("Layers and filters are mismatched, you need to provide one filter for each layer");
    }

    List<SortBy> getSortBy(List<List<SortBy>> items, int index) {
        if (index < items.size()) {
            return items.get(index);
        }
        throw new ServiceException("Layers and sortBy are mismatched, you need to provide one sortBy for each layer");
    }

    private List<Filter> parseFilters(GetMapRequest getMap, List<Filter> rawFilters, List<Filter> cqlFilters) {
        List featureId;
        List<Filter> filters = rawFilters;
        List list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.EMPTY_LIST;
        if (!featureId.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + rawFilters + ", fid: " + featureId);
            }
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            Iterator i = featureId.iterator();
            while (i.hasNext()) {
                ids.add(this.filterFactory.featureId((String)i.next()));
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
        }
        if (!cqlFilters.isEmpty()) {
            if (!filters.isEmpty()) {
                throw new ServiceException("GetMap KVP request contained conflicting filters.  Filter: " + rawFilters + ", fid: " + featureId + ", cql: " + cqlFilters);
            }
            filters = cqlFilters;
        }
        if (filters.size() == 0) {
            filters = null;
        }
        return filters;
    }

    private List validateStyle(Object input, GetMapRequest getMap) {
        try {
            String language = this.getStyleFormat(getMap);
            EntityResolver entityResolver = this.entityResolverProvider.getEntityResolver();
            return Styles.handler((String)language).validate(input, getMap.styleVersion(), entityResolver);
        }
        catch (IOException e) {
            throw new ServiceException("Error validating style", (Throwable)e);
        }
    }

    private StyledLayerDescriptor parseStyle(GetMapRequest getMap, Reader reader) {
        try {
            String format = this.getStyleFormat(getMap);
            EntityResolver entityResolver = this.entityResolverProvider.getEntityResolver();
            return Styles.handler((String)format).parse((Object)reader, getMap.styleVersion(), null, entityResolver);
        }
        catch (IOException e) {
            throw new ServiceException("Error parsing style", (Throwable)e);
        }
    }

    private String getStyleFormat(GetMapRequest request) {
        return request.getStyleFormat() != null ? request.getStyleFormat() : "sld";
    }

    private void processSld(GetMapRequest request, List<?> requestedLayers, StyledLayerDescriptor sld, List styleNames) throws ServiceException, IOException {
        if (requestedLayers.size() == 0) {
            sld.accept((StyleVisitor)new ProcessStandaloneSLDVisitor(this.wms, request));
        } else {
            this.processLibrarySld(request, sld, requestedLayers, styleNames);
        }
    }

    private void processLibrarySld(GetMapRequest request, StyledLayerDescriptor sld, List<?> requestedLayers, List<String> styleNames) throws ServiceException, IOException {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new ServiceException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        String styleName = null;
        for (int i = 0; i < requestedLayers.size(); ++i) {
            Object o;
            if (styleNames != null && styleNames.size() > 0) {
                styleName = styleNames.get(i);
            }
            if ((o = requestedLayers.get(i)) instanceof LayerInfo) {
                currLayer = new MapLayerInfo((LayerInfo)o);
                if (styledLayers[i] instanceof NamedLayer) {
                    NamedLayer namedLayer = (NamedLayer)styledLayers[i];
                    currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
                }
                layers.add(currLayer);
                Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                styles.add(style);
                continue;
            }
            if (o instanceof LayerGroupInfo) {
                List subLayers = ((LayerGroupInfo)o).layers();
                for (LayerInfo layer : subLayers) {
                    currLayer = new MapLayerInfo(layer);
                    layers.add(currLayer);
                    Style style = this.findStyleOf(request, currLayer, styleName, styledLayers);
                    styles.add(style);
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown layer info type: " + o);
        }
        request.setLayers(layers);
        request.setStyles(styles);
    }

    public static void addStyles(WMS wms, GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List<MapLayerInfo> layers, List<Style> styles) throws ServiceException, IOException {
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        if (layer instanceof NamedLayer) {
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        for (int t = 0; t < length; ++t) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(wms, request, layerStyles[t].getName());
                if (s == null) {
                    throw new ServiceException("couldn't find style named '" + layerStyles[t].getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyles[t]);
        }
    }

    private static Style findStyle(WMS wms, GetMapRequest request, String currStyleName) throws IOException {
        return wms.getStyleByName(currStyleName);
    }

    private Style findStyleOf(GetMapRequest request, MapLayerInfo layer, String styleName, StyledLayer[] styledLayers) throws ServiceException, IOException {
        Style[] styles;
        StyledLayer sl;
        int i;
        Style style = null;
        String layerName = layer.getName();
        for (i = 0; i < styledLayers.length; ++i) {
            int j;
            sl = styledLayers[i];
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                styles = ((UserLayer)sl).getUserStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if (styleName == null || styleName.equals("") && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                break;
            }
            if (sl instanceof NamedLayer) {
                styles = ((NamedLayer)sl).getStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if ((styleName == null || styleName.equals("")) && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + sl);
        }
        if (style == null && this.laxStyleMatchAllowed) {
            for (i = 0; i < styledLayers.length; ++i) {
                sl = styledLayers[i];
                if (!layerName.equals(sl.getName())) continue;
                if (sl instanceof UserLayer) {
                    styles = ((UserLayer)sl).getUserStyles();
                    if (null == styles || 0 >= styles.length) break;
                    style = styles[0];
                    break;
                }
                if (sl instanceof NamedLayer) {
                    styles = ((NamedLayer)sl).getStyles();
                    if (null != styles && 0 < styles.length) {
                        style = styles[0];
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpRequestReader.findStyle(this.wms, request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + sl);
            }
        }
        if (style == null) {
            if (styleName == null || "".equals(styleName)) {
                style = layer.getDefaultStyle();
                if (style == null) {
                    throw new ServiceException("Could not find a default style for " + layer.getName());
                }
            } else {
                style = this.wms.getStyleByName(styleName);
                if (style == null) {
                    String msg = "No such style: " + styleName;
                    throw new ServiceException(msg, "StyleNotDefined");
                }
            }
        }
        GetMapKvpRequestReader.checkStyle(style, layer);
        return style;
    }

    private static void checkStyle(Style style, MapLayerInfo mapLayerInfo) throws ServiceException {
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_RASTER) {
            return;
        }
        if (GetMapKvpRequestReader.hasTransformation(style)) {
            return;
        }
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        Set styleAttributes = sae.getAttributes();
        FeatureType type = null;
        if (mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR || mapLayerInfo.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            try {
                type = mapLayerInfo.getType() == MapLayerInfo.TYPE_VECTOR ? mapLayerInfo.getFeature().getFeatureType() : mapLayerInfo.getRemoteFeatureSource().getSchema();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error getting FeatureType, this should never happen!", ioe);
            }
        }
        for (PropertyName attName : styleAttributes) {
            if (attName.evaluate((Object)type) != null) continue;
            throw new ServiceException("The requested Style can not be used with this layer.  The style specifies an attribute named '" + attName + "', not found in the '" + mapLayerInfo.getName() + "' layer");
        }
    }

    private static boolean hasTransformation(Style style) {
        for (FeatureTypeStyle fs : style.featureTypeStyles()) {
            if (fs.getTransformation() == null) continue;
            return true;
        }
        return false;
    }

    protected List<?> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) throws Exception {
        ArrayList<MapLayerInfo> layersOrGroups = new ArrayList<MapLayerInfo>();
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = new ArrayList<String>();
        if ("WFS".equals(remoteOwsType) && remoteOwsUrl != null) {
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(remoteOwsUrl);
            remoteTypeNames.addAll(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        for (String layerName : requestedLayerNames) {
            SimpleFeatureSource remoteSource;
            if (remoteTypeNames.contains(layerName) && (remoteSource = remoteWFS.getFeatureSource(layerName)) != null) {
                layersOrGroups.add(new MapLayerInfo(remoteSource));
                continue;
            }
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo != null) {
                layersOrGroups.add((MapLayerInfo)layerInfo);
                continue;
            }
            LayerGroupInfo layerGroup = this.wms.getLayerGroupByName(layerName);
            if (layerGroup == null || LayerGroupInfo.Mode.CONTAINER.equals((Object)layerGroup.getMode())) {
                throw new ServiceException("Could not find layer " + layerName, "LayerNotDefined", "layers");
            }
            layersOrGroups.add((MapLayerInfo)layerGroup);
        }
        if (layersOrGroups.size() == 0) {
            throw new ServiceException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        return layersOrGroups;
    }

    private static DataStore connectRemoteWFS(URL remoteOwsUrl) throws ServiceException {
        try {
            WFSDataStoreFactory factory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>(factory.getImplementationHints());
            params.put(WFSDataStoreFactory.URL.key, remoteOwsUrl + "&request=GetCapabilities&service=WFS");
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            return factory.createDataStore(params);
        }
        catch (Exception e) {
            throw new ServiceException("Could not connect to remote OWS", (Throwable)e, "RemoteOWSFailure");
        }
    }

    protected List<Style> parseStyles(List<String> styleNames, List<Object> requestedLayerInfos) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (int i = 0; i < styleNames.size(); ++i) {
            String styleName = styleNames.get(i);
            if ("".equals(styleName)) {
                styles.add(null);
                continue;
            }
            if (this.isRemoteWMSLayer(requestedLayerInfos.get(i))) {
                WMSLayerInfo remoteWMSLayer = (WMSLayerInfo)((LayerInfo)requestedLayerInfos.get(i)).getResource();
                Optional remoteStyle = remoteWMSLayer.findRemoteStyleByName(styleName);
                if (remoteStyle.isPresent()) {
                    styles.add((Style)remoteStyle.get());
                    continue;
                }
                throw new ServiceException("No such remote style: " + styleName, "StyleNotDefined");
            }
            Style style = this.wms.getStyleByName(styleName);
            if (style == null) {
                String msg = "No such style: " + styleName;
                throw new ServiceException(msg, "StyleNotDefined");
            }
            styles.add(style);
        }
        return styles;
    }

    public boolean isLaxStyleMatchAllowed() {
        return this.laxStyleMatchAllowed;
    }

    public void setLaxStyleMatchAllowed(boolean laxStyleMatchAllowed) {
        this.laxStyleMatchAllowed = laxStyleMatchAllowed;
    }

    public void destroy() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    private boolean isRemoteWMSLayer(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LayerInfo)) {
            return false;
        }
        return ((LayerInfo)o).getResource() instanceof WMSLayerInfo;
    }

    private Geometry getClipGeometry(GetMapRequest getMapRequest) {
        if (getMapRequest.getRawKvp() == null || getMapRequest.getCrs() == null) {
            return null;
        }
        String wktString = getMapRequest.getRawKvp().get("clip");
        if (wktString == null) {
            return null;
        }
        try {
            Geometry geom = ClipWMSGetMapCallBack.readGeometry(wktString, getMapRequest.getCrs());
            if (LOGGER.isLoggable(Level.FINE) && geom != null) {
                LOGGER.fine("parsed Clip param to geometry " + geom.toText());
            }
            return geom;
        }
        catch (Exception e) {
            LOGGER.severe("Ignoring clip param,Error parsing wkt in clip parameter : " + wktString);
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    static {
        interpolationMethods.put("NEAREST NEIGHBOR", 0);
        interpolationMethods.put("BILINEAR", 1);
        interpolationMethods.put("BICUBIC", 2);
    }
}

