/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.Cell;
import org.geoserver.wms.legendgraphic.ColorMapLegendCreator;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.PackagedUtils;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;

public class RasterLayerLegendHelper {
    private static final BufferedImage defaultLegend;
    private BufferedImage image;
    private RasterSymbolizer rasterSymbolizer;
    private int width;
    private int height;
    private boolean transparent;
    private Color bgColor;
    private ColorMapLegendCreator cMapLegendCreator;

    public RasterLayerLegendHelper(GetLegendGraphicRequest request, Style style, String ruleName) {
        PackagedUtils.ensureNotNull(request, "The provided GetLegendGraphicRequest is null");
        this.parseRequest(request, style, ruleName);
    }

    private void parseRequest(GetLegendGraphicRequest request, Style gt2Style, String ruleName) {
        Rule[] applicableRules;
        FeatureTypeStyle[] ftStyles = gt2Style.featureTypeStyles().toArray(new FeatureTypeStyle[gt2Style.featureTypeStyles().size()]);
        double scaleDenominator = request.getScale();
        if (ruleName != null) {
            Rule rule = LegendUtils.getRule(ftStyles, ruleName);
            if (rule == null) {
                throw new ServiceException("Specified style does not contains a rule named " + ruleName);
            }
            applicableRules = new Rule[]{rule};
        } else {
            applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
        }
        if (applicableRules.length != 0) {
            this.width = request.getWidth();
            this.height = request.getHeight();
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalArgumentException("Invalid width and or height for the GetLegendGraphicRequest");
            }
            List symbolizers = applicableRules[0].symbolizers();
            if (symbolizers.size() != 1 || symbolizers.get(0) == null) {
                throw new IllegalArgumentException("Unable to create a legend for this style, we need exactly 1 Symbolizer");
            }
            Symbolizer symbolizer = (Symbolizer)symbolizers.get(0);
            if (!(symbolizer instanceof RasterSymbolizer)) {
                throw new IllegalArgumentException("Unable to create a legend for this style, we need a RasterSymbolizer");
            }
            this.rasterSymbolizer = (RasterSymbolizer)symbolizer;
            this.transparent = request.isTransparent();
            this.bgColor = LegendUtils.getBackgroundColor(request);
            ColorMap cmap = this.rasterSymbolizer.getColorMap();
            ColorMapLegendCreator.Builder cmapLegendBuilder = new ColorMapLegendCreator.Builder();
            if (cmap != null && cmap.getColorMapEntries() != null && cmap.getColorMapEntries().length > 0) {
                cmapLegendBuilder.setAdditionalOptions(request.getLegendOptions());
                cmapLegendBuilder.setColorMapType(cmap.getType());
                cmapLegendBuilder.setExtended(cmap.getExtendedColors());
                cmapLegendBuilder.setRequestedDimension(new Dimension(this.width, this.height));
                cmapLegendBuilder.setTransparent(this.transparent);
                cmapLegendBuilder.setBackgroundColor(this.bgColor);
                cmapLegendBuilder.setLabelFont(LegendUtils.getLabelFont(request));
                cmapLegendBuilder.setLabelFontColor(LegendUtils.getLabelFontColor(request));
                cmapLegendBuilder.setLayout(LegendUtils.getLayout(request));
                cmapLegendBuilder.setColumnHeight(LegendUtils.getColumnHeight(request));
                cmapLegendBuilder.setRowWidth(LegendUtils.getRowWidth(request));
                cmapLegendBuilder.setColumns(LegendUtils.getColumns(request));
                cmapLegendBuilder.setRows(LegendUtils.getRows(request));
                cmapLegendBuilder.setLabelFontColor(LegendUtils.getLabelFontColor(request));
                ChannelSelection channelSelection = this.rasterSymbolizer.getChannelSelection();
                cmapLegendBuilder.setBand(channelSelection != null ? channelSelection.getGrayChannel() : null);
                cmapLegendBuilder.checkAdditionalOptions();
                ColorMapEntry[] colorMapEntries = cmap.getColorMapEntries();
                Cell.ColorMapEntryLegendBuilder lastEntry = null;
                boolean first = true;
                for (ColorMapEntry ce : colorMapEntries) {
                    if (ce == null) continue;
                    Double qty = (Double)ce.getQuantity().evaluate(null, Double.class);
                    if (cmap.getType() == 2 && first && qty < 0.0 && Double.isInfinite(qty)) continue;
                    lastEntry = cmapLegendBuilder.addColorMapEntry(ce);
                    first = false;
                }
                if (lastEntry != null) {
                    lastEntry.setLastRow();
                }
                this.cMapLegendCreator = cmapLegendBuilder.create();
            } else {
                this.cMapLegendCreator = null;
            }
        }
    }

    public BufferedImage getLegend() {
        if (this.rasterSymbolizer == null) {
            return null;
        }
        return this.createResponse();
    }

    private synchronized BufferedImage createResponse() {
        if (this.image == null) {
            if (this.cMapLegendCreator != null) {
                this.image = this.cMapLegendCreator.getLegend();
            } else {
                this.image = ImageUtils.createImage(this.width, this.height, null, this.transparent);
                Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.bgColor, this.image, new HashMap<RenderingHints.Key, Object>());
                if (defaultLegend == null) {
                    this.drawRasterIcon(graphics);
                } else {
                    graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.drawImage(defaultLegend, 0, 0, this.width, this.height, null);
                }
                graphics.dispose();
            }
        }
        return this.image;
    }

    void drawRasterIcon(Graphics2D graphics) {
        Color blue = new Color(Integer.parseInt("5e72be", 16));
        Color cyan = new Color(Integer.parseInt("a2c0eb", 16));
        graphics.setColor(blue);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(cyan);
        for (int j = 0; j < this.height / 2; ++j) {
            for (int i = j % 2; i < this.width / 2; i += 2) {
                graphics.fillRect(i * 2, j * 2, 2, 2);
            }
        }
        GradientPaint paint = new GradientPaint(new Point(0, 0), new Color(0, 0, 255, 0), new Point(this.width, this.height), new Color(0, 0, 255, 100));
        graphics.setPaint(paint);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.BLUE);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    protected ColorMapLegendCreator getcMapLegendCreator() {
        return this.cMapLegendCreator;
    }

    static {
        BufferedImage imgShape = null;
        try {
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            Resource rasterLegend = loader.get(Paths.path((String[])new String[]{"styles", "rasterLegend.png"}));
            if (rasterLegend.getType() == Resource.Type.RESOURCE) {
                imgShape = ImageIO.read(rasterLegend.file());
            }
        }
        catch (Throwable e) {
            imgShape = null;
        }
        defaultLegend = imgShape;
    }
}

