/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Description;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.util.InternationalString;

public class LegendUtils {
    public static final String DEFAULT_FONT_NAME = "Sans-Serif";
    public static final String DEFAULT_CHANNEL_NAME = "1";
    public static final int DEFAULT_FONT_TYPE = 0;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final Font DEFAULT_FONT = new Font("Sans-Serif", 0, 12);
    public static final Color DEFAULT_BG_COLOR = Color.WHITE;
    public static final Color DEFAULT_FONT_COLOR = Color.BLACK;
    public static final float hpaddingFactor = 0.15f;
    public static final float vpaddingFactor = 0.15f;
    public static final float rowPaddingFactor = 0.15f;
    public static final float columnPaddingFactor = 0.15f;
    public static final float marginFactor = 0.015f;
    private static final LegendLayout DEFAULT_LAYOUT = LegendLayout.VERTICAL;
    private static final int DEFAULT_COLUMN_HEIGHT = 0;
    private static final int DEFAULT_ROW_WIDTH = 0;
    private static final int DEFAULT_COLUMNS = 0;
    private static final int DEFAULT_ROWS = 0;
    private static final Logger LOGGER = Logging.getLogger((String)LegendUtils.class.getPackage().getName());
    public static final Color DEFAULT_BORDER_COLOR = Color.black;

    protected static void ensureNotNull(Object argument) {
        LegendUtils.ensureNotNull(argument, "Argument cannot be null");
    }

    protected static void ensureNotNull(Object argument, String message) {
        if (message == null) {
            throw new NullPointerException("Message cannot be null");
        }
        if (argument == null) {
            throw new NullPointerException(message + " cannot be null");
        }
    }

    public static LegendLayout getLayout(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        LegendLayout layout = DEFAULT_LAYOUT;
        if (legendOptions != null && legendOptions.get("layout") != null) {
            try {
                layout = LegendLayout.valueOf(((String)legendOptions.get("layout")).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return layout;
    }

    public static LegendLayout getGroupLayout(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        LegendLayout layout = DEFAULT_LAYOUT;
        if (legendOptions != null && legendOptions.get("grouplayout") != null) {
            try {
                layout = LegendLayout.valueOf(((String)legendOptions.get("grouplayout")).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return layout;
    }

    public static int getColumnHeight(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        int columnheight = 0;
        if (legendOptions != null && legendOptions.get("columnheight") != null) {
            try {
                columnheight = Integer.parseInt((String)legendOptions.get("columnheight"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columnheight;
    }

    public static int getRowWidth(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        int rowwidth = 0;
        if (legendOptions != null && legendOptions.get("rowwidth") != null) {
            try {
                rowwidth = Integer.parseInt((String)legendOptions.get("rowwidth"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rowwidth;
    }

    public static int getColumns(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        int columns = 0;
        if (legendOptions != null && legendOptions.get("columns") != null) {
            try {
                columns = Integer.parseInt((String)legendOptions.get("columns"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columns;
    }

    public static int getRows(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        int rows = 0;
        if (legendOptions != null && legendOptions.get("rows") != null) {
            try {
                rows = Integer.parseInt((String)legendOptions.get("rows"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rows;
    }

    public static Font getLabelFont(GetLegendGraphicRequest req) {
        double standardDpi;
        double dpi;
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        if (legendOptions == null) {
            return DEFAULT_FONT;
        }
        String legendFontName = DEFAULT_FONT_NAME;
        if (legendOptions.get("fontName") != null) {
            legendFontName = (String)legendOptions.get("fontName");
        }
        int legendFontFamily = 0;
        if (legendOptions.get("fontStyle") != null) {
            String legendFontFamily_ = (String)legendOptions.get("fontStyle");
            if (legendFontFamily_.equalsIgnoreCase("italic")) {
                legendFontFamily = 2;
            } else if (legendFontFamily_.equalsIgnoreCase("bold")) {
                legendFontFamily = 1;
            }
        }
        int legendFontSize = 12;
        if (legendOptions.get("fontSize") != null) {
            try {
                legendFontSize = Integer.valueOf((String)legendOptions.get("fontSize"));
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Error trying to interpret legendOption 'fontSize': " + legendOptions.get("fontSize"));
                legendFontSize = 12;
            }
        }
        if ((dpi = RendererUtilities.getDpi(req.getLegendOptions())) != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
            double scaleFactor = dpi / standardDpi;
            legendFontSize = (int)Math.ceil((double)legendFontSize * scaleFactor);
        }
        if (legendFontFamily == 0 && legendFontName.equalsIgnoreCase(DEFAULT_FONT_NAME) && (legendFontSize == 12 || legendFontSize <= 0)) {
            return DEFAULT_FONT;
        }
        return new Font(legendFontName, legendFontFamily, legendFontSize);
    }

    public static Color getLabelFontColor(GetLegendGraphicRequest req) {
        String color;
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        String string = color = legendOptions != null ? (String)legendOptions.get("fontColor") : null;
        if (color == null) {
            return DEFAULT_FONT_COLOR;
        }
        try {
            return LegendUtils.color(color);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Could not decode label color: " + color + ", default to " + DEFAULT_FONT_COLOR.toString());
            }
            return DEFAULT_FONT_COLOR;
        }
    }

    public static boolean isFontAntiAliasing(GetLegendGraphicRequest req) {
        String aaVal;
        return req.getLegendOptions().get("fontAntiAliasing") instanceof String && ((aaVal = (String)req.getLegendOptions().get("fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase(DEFAULT_CHANNEL_NAME));
    }

    public static Color getBackgroundColor(GetLegendGraphicRequest req) {
        LegendUtils.ensureNotNull(req, "GetLegendGraphicRequestre");
        Map<String, Object> legendOptions = req.getLegendOptions();
        if (legendOptions == null) {
            return DEFAULT_BG_COLOR;
        }
        Object clr = legendOptions.get("bgColor");
        if (clr instanceof Color) {
            return (Color)clr;
        }
        if (clr == null) {
            return DEFAULT_BG_COLOR;
        }
        try {
            return LegendUtils.color((String)clr);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Could not decode background color: " + clr + ", default to " + DEFAULT_BG_COLOR.toString());
            return DEFAULT_BG_COLOR;
        }
    }

    public static double getOpacity(ColorMapEntry entry) throws IllegalArgumentException, MissingResourceException {
        LegendUtils.ensureNotNull(entry, "ColorMapEntry");
        Expression opacity = entry.getOpacity();
        Double opacityValue = null;
        if (opacity == null) {
            return 1.0;
        }
        opacityValue = (Double)opacity.evaluate(null, Double.class);
        if (opacityValue == null && opacity instanceof Literal) {
            String opacityExp = (String)opacity.evaluate(null, String.class);
            opacity = ExpressionExtractor.extractCqlExpressions((String)opacityExp);
            opacityValue = (Double)opacity.evaluate(null, Double.class);
        }
        if (opacityValue == null || opacityValue - 1.0 > 0.0 || opacityValue < 0.0) {
            throw new IllegalArgumentException(Errors.format((int)10, (Object)"Opacity", (Object)opacityValue));
        }
        return opacityValue;
    }

    public static Color color(String hex) {
        LegendUtils.ensureNotNull(hex, "hex value");
        if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        }
        if (!hex.startsWith("#")) {
            hex = "#" + hex;
        }
        return Color.decode(hex);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH", "NP_NULL_PARAM_DEREF"})
    public static Color color(ColorMapEntry entry) {
        LegendUtils.ensureNotNull(entry, "entry");
        Expression color = entry.getColor();
        LegendUtils.ensureNotNull(color, "color");
        String colorString = (String)color.evaluate(null, String.class);
        if (colorString != null && colorString.startsWith("${")) {
            color = ExpressionExtractor.extractCqlExpressions((String)colorString);
            colorString = (String)color.evaluate(null, String.class);
        }
        LegendUtils.ensureNotNull(colorString, "colorString");
        return LegendUtils.color(colorString);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public static double getQuantity(ColorMapEntry entry) {
        LegendUtils.ensureNotNull(entry, "entry");
        Expression quantity = entry.getQuantity();
        LegendUtils.ensureNotNull(quantity, "quantity");
        Double quantityString = (Double)quantity.evaluate(null, Double.class);
        if (quantityString == null && quantity instanceof Literal) {
            String quantityExp = (String)quantity.evaluate(null, String.class);
            quantity = ExpressionExtractor.extractCqlExpressions((String)quantityExp);
            quantityString = (Double)quantity.evaluate(null, Double.class);
        }
        LegendUtils.ensureNotNull(quantityString, "quantityString");
        return quantityString;
    }

    public static String getLabel(ColorMapEntry entry) {
        LegendUtils.ensureNotNull(entry, "entry");
        String labelString = entry.getLabel();
        if (labelString != null && labelString.startsWith("${")) {
            Expression label = ExpressionExtractor.extractCqlExpressions((String)labelString);
            labelString = (String)label.evaluate(null, String.class);
        }
        return labelString;
    }

    public static Rule[] getApplicableRules(FeatureTypeStyle[] ftStyles, double scaleDenominator) {
        LegendUtils.ensureNotNull(ftStyles, "FeatureTypeStyle array ");
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (int i = 0; i < ftStyles.length; ++i) {
            FeatureTypeStyle fts = ftStyles[i];
            for (Rule r : fts.rules()) {
                if (!LegendUtils.isWithInScale(r, scaleDenominator)) continue;
                ruleList.add(r);
            }
        }
        return ruleList.toArray(new Rule[ruleList.size()]);
    }

    public static boolean isWithInScale(Rule r, double scaleDenominator) {
        return scaleDenominator == -1.0 || r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    public static BufferedImage renderLabel(String label, Graphics2D g, GetLegendGraphicRequest req) {
        BufferedImage renderedLabel;
        LegendUtils.ensureNotNull(label);
        LegendUtils.ensureNotNull(g);
        LegendUtils.ensureNotNull(req);
        Color labelColor = LegendUtils.getLabelFontColor(req);
        if (label.indexOf("\n") != -1 || label.indexOf("\\n") != -1) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            ArrayList<Integer> lineHeight = new ArrayList<Integer>();
            String realLabel = label.replaceAll("\\\\n", "\n");
            StringTokenizer st = new StringTokenizer(realLabel, "\n\r\f");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                Rectangle2D thisLineBounds = g.getFontMetrics().getStringBounds(token, g);
                int thisLineHeight = (int)Math.ceil(thisLineBounds.getHeight());
                bounds.add(0.0, (double)thisLineHeight + ((RectangularShape)bounds).getHeight());
                bounds.add(thisLineBounds.getWidth(), 0.0);
                lineHeight.add((int)Math.ceil(thisLineBounds.getHeight()));
            }
            renderedLabel = new BufferedImage((int)Math.ceil(((RectangularShape)bounds).getWidth()), (int)Math.ceil(((RectangularShape)bounds).getHeight()), 2);
            st = new StringTokenizer(realLabel, "\n\r\f");
            Graphics2D rlg = renderedLabel.createGraphics();
            rlg.setColor(labelColor);
            rlg.setFont(g.getFont());
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            rlg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
            int y = 0 - g.getFontMetrics().getDescent();
            int c = 0;
            while (st.hasMoreElements()) {
                rlg.drawString(st.nextToken(), 0, y += ((Integer)lineHeight.get(c++)).intValue());
            }
            rlg.dispose();
        } else {
            int height = (int)Math.ceil(g.getFontMetrics().getStringBounds(label, g).getHeight());
            int width = (int)Math.ceil(g.getFontMetrics().getStringBounds(label, g).getWidth());
            renderedLabel = new BufferedImage(width, height, 2);
            Graphics2D rlg = renderedLabel.createGraphics();
            rlg.setColor(labelColor);
            rlg.setFont(g.getFont());
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            if (g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS) != null) {
                rlg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
            }
            rlg.drawString(label, 0, height - rlg.getFontMetrics().getDescent());
            rlg.dispose();
        }
        return renderedLabel;
    }

    public static BufferedImage hMergeBufferedImages(BufferedImage left, BufferedImage center, BufferedImage right, Map<RenderingHints.Key, Object> hintsMap, boolean transparent, Color backgroundColor, double dx) {
        if (right == null && center == null) {
            return left;
        }
        if (left == null) {
            throw new NullPointerException("Left image cannot be null");
        }
        int totalHeight = (int)(Math.max((double)left.getHeight(), Math.max(center != null ? (double)center.getHeight() : Double.NEGATIVE_INFINITY, right != null ? (double)right.getHeight() : 0.0)) + 0.5);
        int totalWidth = (int)((double)(left.getWidth() + (center != null ? center.getWidth() : 0) + (right != null ? right.getWidth() : 0)) + 2.0 * dx + 0.5);
        BufferedImage finalImage = ImageUtils.createImage(totalWidth, totalHeight, null, transparent);
        Graphics2D finalGraphics = ImageUtils.prepareTransparency(transparent, backgroundColor, finalImage, hintsMap);
        int offsetX = 0;
        finalGraphics.drawImage((Image)left, offsetX, 0, null);
        offsetX = (int)((double)left.getWidth() + dx + 0.5);
        if (center != null) {
            finalGraphics.drawImage((Image)center, offsetX, 0, null);
            offsetX += (int)((double)center.getWidth() + dx + 0.5);
        }
        if (right != null) {
            finalGraphics.drawImage((Image)right, offsetX, 0, null);
        }
        finalGraphics.dispose();
        return finalImage;
    }

    public static boolean checkGridLayer(FeatureType layer) {
        if (!(layer instanceof SimpleFeatureType)) {
            return false;
        }
        boolean found = false;
        Collection descriptors = layer.getDescriptors();
        for (PropertyDescriptor descriptor : descriptors) {
            PropertyType type = descriptor.getType();
            if (!type.getBinding().isAssignableFrom(GridCoverage2D.class) && !type.getBinding().isAssignableFrom(GridCoverage2DReader.class)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean checkRasterSymbolizer(Style style) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule r : fts.rules()) {
                for (Symbolizer s : r.symbolizers()) {
                    if (!(s instanceof RasterSymbolizer)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Rule getRule(FeatureTypeStyle[] fts, String rule) {
        Rule sldRule = null;
        block0: for (int i = 0; i < fts.length; ++i) {
            for (Rule r : fts[i].rules()) {
                if (!rule.equalsIgnoreCase(r.getName())) continue;
                sldRule = r;
                if (!LOGGER.isLoggable(Level.FINE)) continue block0;
                LOGGER.fine(new StringBuffer("found requested rule: ").append(rule).toString());
                continue block0;
            }
        }
        return sldRule;
    }

    static String getRuleLabel(Rule rule, GetLegendGraphicRequest req) {
        Description description = rule.getDescription();
        String label = "";
        if (description != null && description.getTitle() != null) {
            InternationalString title = description.getTitle();
            label = req.getLocale() != null ? title.toString(req.getLocale()) : title.toString();
        } else if (rule.getName() != null) {
            label = rule.getName();
        }
        return label;
    }

    public static enum HAlign {
        LEFT,
        CENTERED,
        RIGHT,
        JUSTIFIED;

    }

    public static enum VAlign {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum LegendLayout {
        HORIZONTAL,
        VERTICAL;

    }
}

