/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;

public class MapLayerInfoKvpParser
extends KvpParser {
    private FlatKvpParser rawNamesParser;
    private final WMS wms;

    public MapLayerInfoKvpParser(String key, WMS wms) {
        super(key, MapLayerInfo.class);
        this.wms = wms;
        this.rawNamesParser = new FlatKvpParser(key, String.class);
    }

    protected boolean skipResource(Object theResource) {
        return false;
    }

    public List<MapLayerInfo> parse(String paramValue) throws Exception {
        List layerNames = (List)this.rawNamesParser.parse(paramValue);
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>(layerNames.size());
        MapLayerInfo layer = null;
        for (String layerName : layerNames) {
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo == null) {
                LayerGroupInfo groupInfo = this.wms.getLayerGroupByName(layerName);
                if (groupInfo == null || LayerGroupInfo.Mode.CONTAINER.equals((Object)groupInfo.getMode())) {
                    throw new ServiceException(layerName + ": no such layer on this server", "LayerNotDefined", ((Object)((Object)this)).getClass().getSimpleName());
                }
                if (this.skipResource(groupInfo)) continue;
                for (LayerInfo li : groupInfo.layers()) {
                    if (this.skipResource(li)) continue;
                    layer = new MapLayerInfo(li);
                    layers.add(layer);
                }
                continue;
            }
            if (this.skipResource(layerInfo)) continue;
            layer = new MapLayerInfo(layerInfo);
            layers.add(layer);
        }
        return layers;
    }
}

