/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.Icon;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.styling.ExternalGraphic;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Mark;
import org.opengis.style.Stroke;

public class Icons {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.icons");
    public static final int RENDER_SCALE_FACTOR = 4;
    public static final double DEFAULT_SYMBOL_SIZE = 16.0;

    private Icons() {
    }

    @Nullable
    public static Integer rotationScale(@Nullable Integer size, @Nullable Double rotation) {
        if (size == null) {
            return null;
        }
        if (rotation == null || rotation % 90.0 == 0.0) {
            return size;
        }
        return (int)Math.ceil(Icons.rotationScaleFactor(rotation) * (double)size.intValue());
    }

    @Nullable
    public static Double rotationScale(@Nullable Double size, @Nullable Double rotation) {
        if (size == null) {
            return null;
        }
        if (rotation == null || rotation % 90.0 == 0.0) {
            return size;
        }
        return Icons.rotationScaleFactor(rotation) * size;
    }

    public static double rotationScaleFactor(double rotation) {
        return Math.abs(Math.sin(Math.toRadians(rotation))) + Math.abs(Math.cos(Math.toRadians(rotation)));
    }

    @Nullable
    public static Double getRotation(Graphic g, @Nullable Feature f) {
        if (g.getRotation() != null) {
            return (Double)g.getRotation().evaluate((Object)f, Double.class);
        }
        return null;
    }

    @Nullable
    public static Double getSpecifiedSize(Graphic g, @Nullable Feature f) {
        if (g.getSize() != null) {
            return (Double)g.getSize().evaluate((Object)f, Double.class);
        }
        return null;
    }

    @Nullable
    private static Icon getIcon(ExternalGraphic eg, @Nullable Feature f) {
        Icon i = eg.getInlineContent();
        if (i == null) {
            try {
                Expression location = ExpressionExtractor.extractCqlExpressions((String)eg.getLocation().toString());
                Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                while (i == null && it.hasNext()) {
                    try {
                        ExternalGraphicFactory fact = (ExternalGraphicFactory)it.next();
                        i = fact.getIcon((Feature)null, location, eg.getFormat(), -1);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                    }
                }
            }
            catch (MalformedURLException e1) {
                LOGGER.log(Level.FINER, e1.getMessage(), e1);
            }
        }
        return i;
    }

    @Nullable
    public static Integer getExternalSize(ExternalGraphic eg, @Nullable Feature f) {
        Icon i = Icons.getIcon(eg, f);
        if (i == null) {
            return 16;
        }
        return Math.max(i.getIconHeight(), i.getIconWidth());
    }

    @Nullable
    public static Double graphicSize(Graphic g, @Nullable Double rotation, @Nullable Feature f) {
        Double width;
        Stroke stroke;
        GraphicalSymbol gs;
        Double size = Icons.getSpecifiedSize(g, f);
        double border = 0.0;
        if (rotation == null) {
            rotation = Icons.getRotation(g, f);
        }
        if ((gs = (GraphicalSymbol)g.graphicalSymbols().iterator().next()) instanceof Mark && (stroke = ((Mark)gs).getStroke()) != null && stroke.getWidth() != null && (width = (Double)stroke.getWidth().evaluate((Object)f, Double.class)) != null) {
            border = width;
        }
        if (size == null) {
            size = gs instanceof ExternalGraphic ? Double.valueOf(Icons.getExternalSize((ExternalGraphic)gs, f).intValue()) : Double.valueOf(16.0);
        }
        if ((size = Icons.rotationScale(size, rotation)) != null) {
            size = size + border;
        }
        return size;
    }

    @Nullable
    public static Double graphicScale(Graphic g, @Nullable Feature f) {
        Double size = Icons.graphicSize(g, null, f);
        if (size != null) {
            return size / 16.0;
        }
        return null;
    }
}

