/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.icons.IconProperties;
import org.geoserver.wms.icons.Icons;
import org.geoserver.wms.icons.MiniRule;
import org.geotools.filter.visitor.IsStaticExpressionVisitor;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.style.GraphicalSymbol;

public final class IconPropertyExtractor {
    private static final Logger LOGGER = Logging.getLogger(IconPropertyExtractor.class);
    public static final String NON_POINT_GRAPHIC_KEY = "npg";
    private List<List<MiniRule>> style;

    private IconPropertyExtractor(List<List<MiniRule>> style) {
        this.style = style;
    }

    private IconProperties propertiesFor(SimpleFeature feature) {
        return new FeatureProperties(feature).properties();
    }

    public static IconProperties extractProperties(List<List<MiniRule>> style, SimpleFeature feature) {
        return new IconPropertyExtractor(style).propertiesFor(feature);
    }

    public static IconProperties extractProperties(Style style, SimpleFeature feature) {
        return new IconPropertyExtractor(MiniRule.minify(style)).propertiesFor(feature);
    }

    public static Graphic getGraphic(Symbolizer symbolizer, boolean includeNonPointGraphics) {
        if (symbolizer instanceof PointSymbolizer) {
            return ((PointSymbolizer)symbolizer).getGraphic();
        }
        if (!includeNonPointGraphics) {
            return null;
        }
        if (symbolizer instanceof PolygonSymbolizer) {
            Fill fill = ((PolygonSymbolizer)symbolizer).getFill();
            if (fill != null && fill.getGraphicFill() != null) {
                return fill.getGraphicFill();
            }
            Stroke stroke = ((PolygonSymbolizer)symbolizer).getStroke();
            if (stroke != null) {
                return stroke.getGraphicStroke();
            }
        } else if (symbolizer instanceof LineSymbolizer) {
            Stroke stroke = ((LineSymbolizer)symbolizer).getStroke();
            if (stroke != null) {
                if (stroke.getGraphicStroke() != null) {
                    return stroke.getGraphicStroke();
                }
                if (stroke.getGraphicFill() != null) {
                    return stroke.getGraphicFill();
                }
            }
        } else if (symbolizer instanceof TextSymbolizer2) {
            return ((TextSymbolizer2)symbolizer).getGraphic();
        }
        return null;
    }

    private class FeatureProperties {
        private static final String URL = ".url";
        private static final String WIDTH = ".width";
        private static final String LINEJOIN = ".linejoin";
        private static final String LINECAP = ".linecap";
        private static final String DASHOFFSET = ".dashoffset";
        private static final String GRAPHIC = ".graphic";
        private static final String COLOR = ".color";
        private static final String STROKE = ".stroke";
        private static final String FILL = ".fill";
        private static final String NAME = ".name";
        private static final String SIZE = ".size";
        private static final String ROTATION = ".rotation";
        private static final String OPACITY = ".opacity";
        private final SimpleFeature feature;

        public FeatureProperties(SimpleFeature feature) {
            this.feature = feature;
        }

        private <T> T evaluate(Expression expression, SimpleFeature feature, T defaultValue) {
            if (expression == null) {
                return defaultValue;
            }
            try {
                Object value = expression.evaluate((Object)feature, defaultValue.getClass());
                if (value == null || value instanceof Double && Double.isNaN((Double)value)) {
                    return defaultValue;
                }
                return (T)value;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed to evaluate " + expression + ", will use default value", e);
                }
                return defaultValue;
            }
        }

        public IconProperties properties() {
            IconProperties singleExternalGraphic = this.trySingleExternalGraphic();
            if (singleExternalGraphic != null) {
                return singleExternalGraphic;
            }
            return this.embeddedIconProperties();
        }

        public IconProperties trySingleExternalGraphic() {
            MiniRule singleRule = null;
            for (List rules : IconPropertyExtractor.this.style) {
                boolean applied = false;
                for (MiniRule rule : rules) {
                    boolean applicable = rule.isElseFilter && !applied || rule.filter == null || rule.filter.evaluate((Object)this.feature);
                    if (!applicable) continue;
                    if (singleRule == null) {
                        singleRule = rule;
                        continue;
                    }
                    return null;
                }
            }
            if (singleRule == null) {
                return null;
            }
            return this.isExternalGraphic(singleRule);
        }

        public IconProperties isExternalGraphic(MiniRule rule) {
            if (rule.symbolizers.size() != 1) {
                return null;
            }
            Graphic g = IconPropertyExtractor.getGraphic(rule.symbolizers.get(0), true);
            if (g == null) {
                return null;
            }
            if (g.graphicalSymbols().size() != 1) {
                return null;
            }
            GraphicalSymbol gSym = (GraphicalSymbol)g.graphicalSymbols().get(0);
            if (!(gSym instanceof ExternalGraphic)) {
                return null;
            }
            ExternalGraphic exGraphic = (ExternalGraphic)gSym;
            try {
                Double opacity = this.evaluate(g.getOpacity(), this.feature, 1.0);
                Double size = 1.0 * (double)Icons.getExternalSize(exGraphic, (Feature)this.feature).intValue();
                if (size != null) {
                    size = size / 16.0;
                }
                Double rotation = this.evaluate(g.getRotation(), this.feature, 0.0);
                Expression urlExpression = ExpressionExtractor.extractCqlExpressions((String)exGraphic.getLocation().toExternalForm());
                return IconProperties.externalReference(opacity, size, rotation, (String)urlExpression.evaluate((Object)this.feature, String.class));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public IconProperties embeddedIconProperties() {
            TreeMap<String, String> props = new TreeMap<String, String>();
            Double size = null;
            boolean allRotated = true;
            boolean nonPointGraphic = false;
            for (int i = 0; i < IconPropertyExtractor.this.style.size(); ++i) {
                List rules = (List)IconPropertyExtractor.this.style.get(i);
                for (int j = 0; j < rules.size(); ++j) {
                    MiniRule rule = (MiniRule)rules.get(j);
                    boolean matches = rule.filter == null ? !rule.isElseFilter || props.isEmpty() : rule.filter.evaluate((Object)this.feature);
                    if (!matches) continue;
                    for (int k = 0; k < rule.symbolizers.size(); ++k) {
                        props.put(i + "." + j + "." + k, "");
                        Symbolizer sym = rule.symbolizers.get(k);
                        Graphic graphic = IconPropertyExtractor.getGraphic(sym, false);
                        if (graphic == null) {
                            graphic = IconPropertyExtractor.getGraphic(sym, true);
                            nonPointGraphic |= graphic != null;
                        }
                        if (graphic == null) continue;
                        this.addGraphicProperties(i + "." + j + "." + k, graphic, props);
                        Double gRotation = this.graphicRotation(graphic);
                        allRotated &= gRotation != null;
                        Double gSize = Icons.graphicSize((org.opengis.style.Graphic)graphic, gRotation, (Feature)this.feature);
                        if (size != null && (gSize == null || !(gSize > size))) continue;
                        size = gSize;
                    }
                }
            }
            if (nonPointGraphic) {
                props.put(IconPropertyExtractor.NON_POINT_GRAPHIC_KEY, "true");
            }
            if (size != null) {
                size = size / 16.0;
            }
            Double rotation = allRotated ? Double.valueOf(0.0) : null;
            return IconProperties.generator(null, size, rotation, props);
        }

        public boolean isStatic(Expression ex) {
            return (Boolean)ex.accept((ExpressionVisitor)IsStaticExpressionVisitor.VISITOR, null);
        }

        private Double graphicRotation(Graphic g) {
            if (g.getRotation() != null) {
                return this.evaluate(g.getRotation(), this.feature, 0.0);
            }
            return null;
        }

        public void addGraphicProperties(String prefix, Graphic g, Map<String, String> props) {
            if (g.getOpacity() != null && !this.isStatic(g.getOpacity())) {
                props.put(prefix + OPACITY, String.valueOf(this.evaluate(g.getOpacity(), this.feature, 1.0)));
            }
            if (g.getRotation() != null && !this.isStatic(g.getRotation())) {
                props.put(prefix + ROTATION, String.valueOf(this.evaluate(g.getRotation(), this.feature, 0.0)));
            }
            if (g.getSize() != null && !this.isStatic(g.getSize())) {
                props.put(prefix + SIZE, String.valueOf(this.evaluate(g.getSize(), this.feature, 16.0)));
            }
            if (!g.graphicalSymbols().isEmpty()) {
                if (g.graphicalSymbols().get(0) instanceof Mark) {
                    Mark mark = (Mark)g.graphicalSymbols().get(0);
                    this.addMarkProperties(prefix, mark, props);
                } else if (g.graphicalSymbols().get(0) instanceof ExternalGraphic) {
                    ExternalGraphic exGraphic = (ExternalGraphic)g.graphicalSymbols().get(0);
                    this.addExternalGraphicProperties(prefix, exGraphic, props);
                }
            }
        }

        public void addMarkProperties(String prefix, Mark mark, Map<String, String> props) {
            if (mark.getWellKnownName() != null && !this.isStatic(mark.getWellKnownName())) {
                props.put(prefix + NAME, this.evaluate(mark.getWellKnownName(), this.feature, "square"));
            }
            if (mark.getFill() != null) {
                this.addFillProperties(prefix + FILL, mark.getFill(), props);
            }
            if (mark.getStroke() != null) {
                this.addStrokeProperties(prefix + STROKE, mark.getStroke(), props);
            }
        }

        public void addFillProperties(String prefix, Fill fill, Map<String, String> props) {
            if (fill.getColor() != null && !this.isStatic(fill.getColor())) {
                props.put(prefix + COLOR, this.evaluate(fill.getColor(), this.feature, "0xAAAAAA"));
            }
            if (fill.getOpacity() != null && !this.isStatic(fill.getOpacity())) {
                props.put(prefix + OPACITY, String.valueOf(this.evaluate(fill.getOpacity(), this.feature, 1.0)));
            }
            if (fill.getGraphicFill() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, fill.getGraphicFill(), props);
            }
        }

        public void addStrokeProperties(String prefix, Stroke stroke, Map<String, String> props) {
            if (stroke.getColor() != null && !this.isStatic(stroke.getColor())) {
                props.put(prefix + COLOR, this.evaluate(stroke.getColor(), this.feature, "0x000000"));
            }
            if (stroke.getDashOffset() != null && !this.isStatic(stroke.getDashOffset())) {
                props.put(prefix + DASHOFFSET, String.valueOf(this.evaluate(stroke.getDashOffset(), this.feature, 0.0)));
            }
            if (stroke.getLineCap() != null && !this.isStatic(stroke.getLineCap())) {
                props.put(prefix + LINECAP, this.evaluate(stroke.getLineCap(), this.feature, "butt"));
            }
            if (stroke.getLineJoin() != null && !this.isStatic(stroke.getLineJoin())) {
                props.put(prefix + LINEJOIN, this.evaluate(stroke.getLineJoin(), this.feature, "miter"));
            }
            if (stroke.getOpacity() != null && !this.isStatic(stroke.getOpacity())) {
                props.put(prefix + OPACITY, String.valueOf(this.evaluate(stroke.getOpacity(), this.feature, 1.0)));
            }
            if (stroke.getWidth() != null && !this.isStatic(stroke.getWidth())) {
                props.put(prefix + WIDTH, String.valueOf(this.evaluate(stroke.getWidth(), this.feature, 1.0)));
            }
            if (stroke.getGraphicStroke() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, stroke.getGraphicStroke(), props);
            }
            if (stroke.getGraphicFill() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, stroke.getGraphicFill(), props);
            }
        }

        public void addExternalGraphicProperties(String prefix, ExternalGraphic exGraphic, Map<String, String> props) {
            try {
                Expression ex = ExpressionExtractor.extractCqlExpressions((String)exGraphic.getLocation().toExternalForm());
                if (!this.isStatic(ex)) {
                    props.put(prefix + URL, (String)ex.evaluate((Object)this.feature, String.class));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

