/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.util.TemporalUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class TextFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private WMS wms;

    public TextFeatureInfoOutputFormat(WMS wms) {
        super("text/plain");
        this.wms = wms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        PrintWriter writer = new PrintWriter(osw);
        int featuresPrinted = 0;
        int maxfeatures = request.getFeatureCount();
        try (FeatureIterator reader = null;){
            EList collections = results.getFeature();
            int size = collections.size();
            for (int i = 0; i < size; ++i) {
                FeatureCollection fr = (FeatureCollection)collections.get(i);
                reader = fr.features();
                boolean startFeat = true;
                while (reader.hasNext()) {
                    Feature feature = reader.next();
                    if (startFeat) {
                        writer.println("Results for FeatureType '" + fr.getSchema().getName() + "':");
                        startFeat = false;
                    }
                    if (featuresPrinted < maxfeatures) {
                        writer.println("--------------------------------------------");
                        if (feature instanceof SimpleFeature) {
                            SimpleFeature f = (SimpleFeature)feature;
                            SimpleFeatureType schema = f.getType();
                            List types = schema.getAttributeDescriptors();
                            for (AttributeDescriptor descriptor : types) {
                                Name name = descriptor.getName();
                                Class binding = descriptor.getType().getBinding();
                                if (Geometry.class.isAssignableFrom(binding)) {
                                    Geometry g = (Geometry)f.getAttribute(name);
                                    if (g != null) {
                                        writer.println(name + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                                        continue;
                                    }
                                    writer.println(name + " = null");
                                    continue;
                                }
                                if (Date.class.isAssignableFrom(binding) && TemporalUtils.isDateTimeFormatEnabled()) {
                                    String printValue = TemporalUtils.printDate((Date)((Date)f.getAttribute(name)));
                                    writer.println(name + " = " + printValue);
                                    continue;
                                }
                                writer.println(name + " = " + f.getAttribute(name));
                            }
                        } else {
                            writer.println(feature.toString());
                        }
                    }
                    writer.println("--------------------------------------------");
                    ++featuresPrinted;
                }
            }
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }
}

