/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.geometry.Envelope;

class ListComplexFeatureCollection
extends BaseFeatureCollection {
    private List<? extends Feature> list;
    private ReferencedEnvelope bounds = null;

    public ListComplexFeatureCollection(FeatureType schema, List<? extends Feature> list) {
        super(schema);
        this.list = list;
    }

    public int size() {
        return this.list.size();
    }

    public FeatureIterator features() {
        return new ListComplexFeatureIterator(this.list);
    }

    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.calculateBounds();
        }
        return this.bounds;
    }

    private ReferencedEnvelope calculateBounds() {
        ReferencedEnvelope extent = new ReferencedEnvelope();
        for (Feature feature : this.list) {
            ReferencedEnvelope bbox;
            if (feature == null || (bbox = ReferencedEnvelope.reference((Envelope)feature.getBounds())) == null || bbox.isEmpty() || bbox.isNull()) continue;
            extent.expandToInclude((org.locationtech.jts.geom.Envelope)bbox);
        }
        return new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)extent, this.schema.getCoordinateReferenceSystem());
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private static class ListComplexFeatureIterator
    implements FeatureIterator {
        private Iterator<? extends Feature> iter;

        public ListComplexFeatureIterator(List<? extends Feature> features) {
            this.iter = features.iterator();
        }

        public void close() {
            if (this.iter instanceof FeatureIterator) {
                ((FeatureIterator)this.iter).close();
            }
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Feature next() throws NoSuchElementException {
            return this.iter.next();
        }
    }
}

