/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.template.Template;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.FreeMarkerTemplateManager;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.feature.FeatureCollection;

public class HTMLFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private static final String FORMAT = "text/html";
    private FreeMarkerTemplateManager templateManager;
    private WMS wms;

    public HTMLFeatureInfoOutputFormat(WMS wms, GeoServerResourceLoader resourceLoader) {
        super(FORMAT);
        this.wms = wms;
        this.templateManager = new HTMLTemplateManager(FreeMarkerTemplateManager.OutputFormat.HTML, wms, resourceLoader);
    }

    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        this.templateManager.write(results, request, out);
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }

    public FreeMarkerTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    private final class HTMLTemplateManager
    extends FreeMarkerTemplateManager {
        public HTMLTemplateManager(FreeMarkerTemplateManager.OutputFormat format, WMS wms, GeoServerResourceLoader resourceLoader) {
            super(format, wms, resourceLoader);
        }

        @Override
        protected boolean templatesExist(Template header, Template footer, List<FeatureCollection> collections) throws IOException {
            return true;
        }

        @Override
        protected void handleContent(List<FeatureCollection> collections, OutputStreamWriter osw, GetFeatureInfoRequest request) throws IOException {
            for (int i = 0; i < collections.size(); ++i) {
                FeatureCollection fc = collections.get(i);
                Template content = this.getContentTemplate(fc, this.wms.getCharSet());
                String typeName = request.getQueryLayers().get(i).getName();
                this.processTemplate(typeName, fc, content, osw);
            }
        }

        @Override
        protected String getTemplateFileName(String filename) {
            return filename + ".ftl";
        }
    }
}

