/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.GeoJSONGetFeatureResponse;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.FreeMarkerTemplateManager;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoJSONTemplateManager
extends FreeMarkerTemplateManager {
    public GeoJSONTemplateManager(FreeMarkerTemplateManager.OutputFormat format, WMS wms, GeoServerResourceLoader resourceLoader) {
        super(format, wms, resourceLoader);
    }

    @Override
    protected boolean templatesExist(Template header, Template footer, List<FeatureCollection> collections) throws IOException {
        int collSize = collections.size();
        if (header == null || footer == null) {
            return false;
        }
        for (int i = 0; i < collSize; ++i) {
            FeatureCollection fc = collections.get(i);
            Template content = this.getContentTemplate(fc, this.wms.getCharSet());
            if (content == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handleContent(List<FeatureCollection> collections, OutputStreamWriter osw, GetFeatureInfoRequest request) throws IOException {
        for (int i = 0; i < collections.size(); ++i) {
            FeatureCollection fc = collections.get(i);
            Template content = this.getContentTemplate(fc, this.wms.getCharSet());
            if (i > 0) {
                osw.write(44);
            }
            if (content == null) {
                this.handleJSONWithoutTemplate(fc, osw);
                continue;
            }
            String typeName = request.getQueryLayers().get(i).getName();
            this.processTemplate(typeName, fc, content, osw);
        }
    }

    @Override
    protected String getTemplateFileName(String filename) {
        return filename + "_json.ftl";
    }

    private void handleJSONWithoutTemplate(FeatureCollection collection, OutputStreamWriter osw) throws IOException {
        GeoJSONGetFeatureResponse format = new GeoJSONGetFeatureResponse(this.wms.getGeoServer(), FreeMarkerTemplateManager.OutputFormat.JSON.getFormat());
        boolean isComplex = collection.getSchema() instanceof SimpleFeatureType;
        BufferedWriter outWriter = new BufferedWriter(osw);
        GeoJSONBuilder jsonWriter = new GeoJSONBuilder((Writer)outWriter);
        format.writeFeatures(Arrays.asList(collection), null, isComplex, jsonWriter);
        ((Writer)outWriter).flush();
    }

    public static String geomToGeoJSON(Geometry geometry) {
        GeometryJSON geomJSON = new GeometryJSON();
        return geomJSON.toString(geometry);
    }
}

