/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.json.GeoJSONGetFeatureResponse;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.FreeMarkerTemplateManager;
import org.geoserver.wms.featureinfo.GeoJSONTemplateManager;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;

public class GeoJSONFeatureInfoResponse
extends GetFeatureInfoOutputFormat {
    FreeMarkerTemplateManager templateManager;
    private WMS wms;

    public GeoJSONFeatureInfoResponse(WMS wms, GeoServerResourceLoader resourceLoader, String outputFormat) {
        super(outputFormat);
        this.wms = wms;
        if (outputFormat.equals("application/json")) {
            this.templateManager = new GeoJSONTemplateManager(FreeMarkerTemplateManager.OutputFormat.JSON, wms, resourceLoader);
        }
    }

    public GeoJSONFeatureInfoResponse(WMS wms, String outputFormat) {
        super(outputFormat);
        this.wms = wms;
    }

    @Override
    public void write(FeatureCollectionType features, GetFeatureInfoRequest fInfoReq, OutputStream out) throws IOException {
        boolean usedTemplates = false;
        if (this.templateManager != null) {
            usedTemplates = this.templateManager.write(features, fInfoReq, out);
        }
        if (!usedTemplates) {
            GeoJSONGetFeatureResponse format = new GeoJSONGetFeatureResponse(this.wms.getGeoServer(), this.getContentType());
            format.write((Object)features, out, null);
        }
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }
}

