/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import net.opengis.wfs.FeatureCollectionType;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.DirectTemplateFeatureCollectionFactory;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.template.TemplateUtils;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.EnvironmentVariablesTemplateModel;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.FreemarkerStaticsAccessRule;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class FreeMarkerTemplateManager {
    static final String KEY_STATIC_MEMBER_ACCESS = "org.geoserver.htmlTemplates.staticMemberAccess";
    private static Configuration templateConfig;
    private static DirectTemplateFeatureCollectionFactory tfcFactory;
    private static Logger logger;
    private static FreemarkerStaticsAccessRule staticsAccessRule;
    private GeoServerResourceLoader resourceLoader;
    protected WMS wms;
    private GeoServerTemplateLoader templateLoader;
    private OutputFormat format;

    static void initStaticsAccessRule() {
        String tmpAccessPattern = GeoServerExtensions.getProperty((String)KEY_STATIC_MEMBER_ACCESS);
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern(tmpAccessPattern);
        logger.debug((Object)("Initializing with " + tmpRule));
        for (FreemarkerStaticsAccessRule.RuleItem tmpItem : tmpRule.getAllowedItems()) {
            if (tmpItem.isNumberedAlias()) {
                logger.warn((Object)("Granting access to static members of " + tmpItem.getClassName() + " using the variable name " + tmpItem.getAlias() + " to keep names unique."));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Granting access to static members of " + tmpItem.getClassName() + " using the variable name " + tmpItem.getAlias() + "."));
        }
        staticsAccessRule = tmpRule;
    }

    public FreeMarkerTemplateManager(OutputFormat format, WMS wms, GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.wms = wms;
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        try {
            Template footer;
            Template header;
            EList collections = results.getFeature();
            ResourceInfo ri = null;
            if (collections.size() == 1) {
                ri = this.wms.getResourceInfo(FeatureCollectionDecorator.getName((FeatureCollection)collections.get(0)));
            }
            if (ri != null) {
                header = this.getTemplate(ri, charSet, "header");
                footer = this.getTemplate(ri, charSet, "footer");
            } else {
                header = this.getTemplate(null, charSet, "header");
                footer = this.getTemplate(null, charSet, "footer");
            }
            if (!this.templatesExist(header, footer, (List<FeatureCollection>)collections)) {
                boolean bl = false;
                return bl;
            }
            this.processTemplate("header", null, header, osw);
            this.handleContent((List<FeatureCollection>)collections, osw, request);
            if (footer != null) {
                this.processTemplate("footer", null, footer, osw);
            }
            osw.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            tfcFactory.purge();
        }
    }

    protected void processTemplate(String name, FeatureCollection fc, Template template, OutputStreamWriter osw) throws IOException {
        try {
            template.process((Object)fc, (Writer)osw);
        }
        catch (TemplateException e) {
            String msg = null;
            msg = fc == null ? "Error occured processing " + name + " template." : "Error occurred processing content template " + template.getName() + " for " + name;
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    protected Template getContentTemplate(FeatureCollection fc, Charset charset) throws IOException {
        Template content = null;
        if (fc != null && fc.size() > 0) {
            ResourceInfo ri = this.wms.getResourceInfo(FeatureCollectionDecorator.getName(fc));
            if (!(fc.getSchema() instanceof SimpleFeatureType)) {
                content = this.getTemplate(ri, charset, "complex_content");
            }
            if (content == null) {
                content = this.getTemplate(ri, charset, "content");
            }
        }
        return content;
    }

    private Template getTemplate(ResourceInfo ri, Charset charset, String name) throws IOException {
        String templateName = this.getTemplateFileName(name);
        return this.getTemplate(ri, templateName, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template getTemplate(ResourceInfo ri, String templateFileName, Charset charset) throws IOException {
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            Template t;
            block7: {
                if (this.templateLoader == null) {
                    this.templateLoader = new GeoServerTemplateLoader(this.getClass(), this.resourceLoader);
                }
                this.templateLoader.setResource(ri);
                templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
                t = null;
                try {
                    t = templateConfig.getTemplate(templateFileName);
                }
                catch (FileNotFoundException ex) {
                    if (!this.format.equals((Object)OutputFormat.HTML)) break block7;
                    throw ex;
                }
            }
            if (t != null) {
                t.setEncoding(charset.name());
            }
            return t;
        }
    }

    protected abstract String getTemplateFileName(String var1);

    protected abstract boolean templatesExist(Template var1, Template var2, List<FeatureCollection> var3) throws IOException;

    protected abstract void handleContent(List<FeatureCollection> var1, OutputStreamWriter var2, GetFeatureInfoRequest var3) throws IOException;

    public void setTemplateLoader(GeoServerTemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    static {
        tfcFactory = new DirectTemplateFeatureCollectionFactory();
        logger = Logger.getLogger(FreeMarkerTemplateManager.class);
        FreeMarkerTemplateManager.initStaticsAccessRule();
        templateConfig = TemplateUtils.getSafeConfiguration();
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper((FeatureWrapper.TemplateFeatureCollectionFactory)tfcFactory){

            public TemplateModel wrap(Object object) throws TemplateModelException {
                if (object instanceof FeatureCollection) {
                    SimpleHash map = (SimpleHash)super.wrap(object);
                    map.put("request", (Object)((Request)Dispatcher.REQUEST.get()).getKvp());
                    map.put("environment", (Object)new EnvironmentVariablesTemplateModel());
                    map.put("Math", (Object)this.getStaticModel("java.lang.Math"));
                    map.put("geoJSON", (Object)this.getStaticModel("org.geoserver.wms.featureinfo.GeoJSONTemplateManager"));
                    this.addConfiguredStatics(map);
                    return map;
                }
                return super.wrap(object);
            }

            private void addConfiguredStatics(SimpleHash aMap) throws TemplateModelException {
                if (staticsAccessRule.isUnrestricted()) {
                    aMap.put("statics", (Object)this.getStaticModels());
                } else if (staticsAccessRule.getAllowedItems().isEmpty()) {
                    for (FreemarkerStaticsAccessRule.RuleItem tmpItem : staticsAccessRule.getAllowedItems()) {
                        aMap.put(tmpItem.getAlias(), (Object)tmpItem.getClassName());
                    }
                }
            }

            private TemplateHashModel getStaticModel(String path) throws TemplateModelException {
                return (TemplateHashModel)this.getStaticModels().get(path);
            }
        });
    }

    static enum OutputFormat {
        JSON("application/json"),
        HTML("text/html");

        private String format;

        private OutputFormat(String format) {
            this.format = format;
        }

        String getFormat() {
            return this.format;
        }
    }
}

