/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.template.TemplateUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTemplate {
    static Configuration templateConfig = TemplateUtils.getSafeConfiguration();
    public static String DATE_FORMAT_PATTERN;
    public static String DATETIME_FORMAT_PATTERN;
    public static String TIME_FORMAT_PATTERN;
    Map templateCache = new HashMap();
    CharArrayWriter caw = new CharArrayWriter();

    public void title(SimpleFeature feature, OutputStream output) throws IOException {
        this.title(feature, new OutputStreamWriter(output, Charset.forName("UTF-8")));
    }

    public void link(SimpleFeature feature, OutputStream output) throws IOException {
        this.link(feature, new OutputStreamWriter(output, Charset.forName("UTF-8")));
    }

    public void description(SimpleFeature feature, OutputStream output) throws IOException {
        this.description(feature, new OutputStreamWriter(output, Charset.forName("UTF-8")));
    }

    public void title(SimpleFeature feature, Writer writer) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, "title.ftl", null);
    }

    public void link(SimpleFeature feature, Writer writer) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, "link.ftl", null);
    }

    public void description(SimpleFeature feature, Writer writer) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, "description.ftl", null);
    }

    public String title(SimpleFeature feature) throws IOException {
        this.caw.reset();
        this.title(feature, this.caw);
        return this.caw.toString();
    }

    public String link(SimpleFeature feature) throws IOException {
        this.caw.reset();
        this.link(feature, this.caw);
        return this.caw.toString();
    }

    public String description(SimpleFeature feature) throws IOException {
        this.caw.reset();
        this.description(feature, this.caw);
        return this.caw.toString();
    }

    public void template(SimpleFeature feature, Writer writer, String template, Class lookup) throws IOException {
        this.execute(feature, feature.getFeatureType(), writer, template, lookup);
    }

    public void template(SimpleFeature feature, OutputStream output, String template, Class lookup) throws IOException {
        this.template(feature, new OutputStreamWriter(output), template, lookup);
    }

    public String template(SimpleFeature feature, String template, Class lookup) throws IOException {
        this.caw.reset();
        this.template(feature, this.caw, template, lookup);
        return this.caw.toString();
    }

    private void execute(Object feature, SimpleFeatureType featureType, Writer writer, String template, Class lookup) throws IOException {
        Template t = null;
        t = this.lookupTemplate(featureType, template, lookup);
        try {
            t.process(feature, writer);
        }
        catch (TemplateException e) {
            String msg = "Error occured processing template.";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template lookupTemplate(SimpleFeatureType featureType, String template, Class lookup) throws IOException {
        TemplateKey key = new TemplateKey(featureType, template);
        Template t = (Template)this.templateCache.get(key);
        if (t != null) {
            return t;
        }
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(lookup != null ? lookup : this.getClass(), (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class));
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        templateLoader.setFeatureType(catalog.getFeatureTypeByName(featureType.getName()));
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)templateLoader);
            t = templateConfig.getTemplate(template);
            t.setEncoding("UTF-8");
        }
        this.templateCache.put(key, t);
        return t;
    }

    public boolean isTemplateEmpty(SimpleFeatureType featureType, String template, Class<FeatureTemplate> lookup, String defaultContent) throws IOException {
        Template t = this.lookupTemplate(featureType, template, lookup);
        if (t == null) {
            return true;
        }
        StringWriter sw = new StringWriter();
        t.dump((Writer)sw);
        String templateText = sw.toString();
        return "".equals(templateText) || defaultContent != null && defaultContent.equals(templateText);
    }

    static {
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
        templateConfig.setDateFormat("MM/dd/yyyy");
        templateConfig.setDateTimeFormat("MM/dd/yyyy HH:mm:ss");
        templateConfig.setTimeFormat("HH:mm:ss");
        templateConfig.setLocale(Locale.US);
        templateConfig.setNumberFormat("0.###########");
        DATE_FORMAT_PATTERN = "MM/dd/yy";
        DATETIME_FORMAT_PATTERN = "MM/dd/yy HH:mm:ss";
        TIME_FORMAT_PATTERN = "HH:mm:ss";
    }

    private static class TemplateKey {
        SimpleFeatureType type;
        String template;

        public TemplateKey(SimpleFeatureType type, String template) {
            this.type = type;
            this.template = template;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateKey other = (TemplateKey)obj;
            if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

