/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.util.Collection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class FeatureCollectionDecorator
implements FeatureCollection<FeatureType, Feature> {
    protected FeatureCollection fc;
    protected Name name;

    public static Name getName(FeatureCollection fc) {
        if (fc instanceof FeatureCollectionDecorator) {
            return ((FeatureCollectionDecorator)fc).getName();
        }
        return fc.getSchema().getName();
    }

    public FeatureCollectionDecorator(Name name, FeatureCollection fc) {
        this.name = name;
        this.fc = fc;
    }

    public Name getName() {
        return this.name;
    }

    public FeatureIterator<Feature> features() {
        return this.fc.features();
    }

    public FeatureType getSchema() {
        return this.fc.getSchema();
    }

    public String getID() {
        return this.fc.getID();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.fc.accepts(visitor, progress);
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        return this.fc.subCollection(filter);
    }

    public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
        return this.fc.sort(order);
    }

    public ReferencedEnvelope getBounds() {
        return this.fc.getBounds();
    }

    public boolean contains(Object o) {
        return this.fc.contains(o);
    }

    public boolean containsAll(Collection<?> o) {
        return this.fc.containsAll(o);
    }

    public boolean isEmpty() {
        return this.fc.isEmpty();
    }

    public int size() {
        try (FeatureIterator<Feature> iterator = this.features();){
            int count = 0;
            while (iterator.hasNext()) {
                ++count;
                iterator.next();
            }
            int n = count;
            return n;
        }
    }

    public Object[] toArray() {
        return this.fc.toArray();
    }

    public <O> O[] toArray(O[] a) {
        return this.fc.toArray((Object[])a);
    }
}

