/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geoserver.wms.featureinfo.VectorRenderingLayerIdentifier;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Stroke;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;

public class DynamicBufferEstimator
extends AbstractStyleVisitor {
    static final Logger LOGGER = Logging.getLogger(VectorRenderingLayerIdentifier.class);
    Feature feature;
    double buffer;

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public int getBuffer() {
        return (int)Math.ceil(this.buffer);
    }

    public void visit(Stroke stroke) {
        Double w;
        Expression width = stroke.getWidth();
        if (width != null && (w = (Double)width.evaluate((Object)this.feature, Double.class)) != null && w > this.buffer) {
            this.buffer = w;
        }
    }

    public void visit(Graphic gr) {
        try {
            Expression grSize = gr.getSize();
            if (grSize != null) {
                Double size = (Double)grSize.evaluate((Object)this.feature, Double.class);
                if (size != null) {
                    this.buffer = Math.max(this.buffer, size);
                }
                return;
            }
            for (GraphicalSymbol gs : gr.graphicalSymbols()) {
                if (gs instanceof ExternalGraphic) {
                    ExternalGraphic eg = (ExternalGraphic)gs;
                    Icon icon = null;
                    if (eg.getInlineContent() != null) {
                        icon = eg.getInlineContent();
                    } else {
                        String location = eg.getLocation().toExternalForm();
                        Expression expanded = ExpressionExtractor.extractCqlExpressions((String)location);
                        Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                        while (it.hasNext()) {
                            try {
                                icon = ((ExternalGraphicFactory)it.next()).getIcon(this.feature, expanded, eg.getFormat(), -1);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                            }
                        }
                    }
                    if (icon == null) continue;
                    int size = Math.max(icon.getIconHeight(), icon.getIconWidth());
                    if ((double)size > this.buffer) {
                        this.buffer = size;
                    }
                    return;
                }
                if (!(gs instanceof Mark) || !(16.0 > this.buffer)) continue;
                this.buffer = 16.0;
            }
        }
        catch (ClassCastException e) {
            LOGGER.info("Could not parse graphic size, it's a literal but not a Number...");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error occured during the graphic size estimation, meta buffer estimate cannot be performed", e);
        }
    }
}

