/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.dimension.AbstractDefaultValueSelectionStrategy;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;

public abstract class AbstractFeatureAttributeVisitorSelectionStrategy
extends AbstractDefaultValueSelectionStrategy {
    private static Logger LOGGER = Logging.getLogger(AbstractFeatureAttributeVisitorSelectionStrategy.class);

    protected CalcResult getCalculatedResult(FeatureTypeInfo typeInfo, DimensionInfo dimension, FeatureCalc calculator) {
        CalcResult retval = null;
        try {
            FeatureCollection<?, ?> dimensionCollection = this.getDimensionCollection(typeInfo, dimension);
            if (dimensionCollection == null) {
                throw new ServiceException("No dimension collection given, cannot select default value for dimension based on attribute" + dimension.getAttribute());
            }
            dimensionCollection.accepts((FeatureVisitor)calculator, null);
            retval = calculator.getResult();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        return retval;
    }

    private FeatureCollection<?, ?> getDimensionCollection(FeatureTypeInfo typeInfo, DimensionInfo dimension) throws IOException {
        FeatureSource source = null;
        try {
            source = typeInfo.getFeatureSource(null, GeoTools.getDefaultHints());
        }
        catch (IOException e) {
            throw new ServiceException("Could not get the feauture source to list time info for layer " + typeInfo.prefixedName(), (Throwable)e);
        }
        Query dimQuery = new Query(source.getSchema().getName().getLocalPart());
        dimQuery.setPropertyNames(Arrays.asList(dimension.getAttribute()));
        return source.getFeatures(dimQuery);
    }
}

