/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MetatiledMapDecorationLayout;
import org.geotools.util.logging.Logging;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class MapDecorationLayout {
    private static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    List<Block> blocks = new ArrayList<Block>();

    public static MapDecorationLayout fromFile(Resource f, boolean tiled) throws Exception {
        MapDecorationLayout dl = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        Document confFile = new SAXBuilder().build(f.file());
        return MapDecorationLayout.fromDocument(dl, confFile);
    }

    public static MapDecorationLayout fromString(String definition, boolean tiled) throws Exception {
        MapDecorationLayout dl = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        Document confFile = new SAXBuilder().build((Reader)new StringReader(definition));
        return MapDecorationLayout.fromDocument(dl, confFile);
    }

    private static MapDecorationLayout fromDocument(MapDecorationLayout dl, Document confFile) throws Exception {
        for (Element e : confFile.getRootElement().getChildren("decoration")) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Element option : e.getChildren("option")) {
                String value = option.getAttributeValue("value");
                if (value == null) {
                    value = option.getValue();
                }
                m.put(option.getAttributeValue("name"), value);
            }
            MapDecoration decoration = MapDecorationLayout.getDecoration(e.getAttributeValue("type"));
            if (decoration == null) {
                LOGGER.log(Level.WARNING, "Unknown decoration type: " + e.getAttributeValue("type") + " requested.");
                continue;
            }
            decoration.loadOptions(m);
            Block.Position pos = Block.Position.fromString(e.getAttributeValue("affinity"));
            if (pos == null) {
                LOGGER.log(Level.WARNING, "Unknown affinity: " + e.getAttributeValue("affinity") + " requested.");
                continue;
            }
            Dimension size = null;
            String theSize = e.getAttributeValue("size");
            try {
                if (theSize != null && !theSize.equalsIgnoreCase("auto")) {
                    String[] sizeArr = theSize.split(",");
                    size = new Dimension(Integer.valueOf(sizeArr[0]), Integer.valueOf(sizeArr[1]));
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret size parameter: " + theSize, e);
            }
            Point offset = null;
            String theOffset = e.getAttributeValue("offset");
            try {
                if (theOffset != null) {
                    String[] offsetArr = theOffset.split(",");
                    offset = new Point(Integer.valueOf(offsetArr[0]), Integer.valueOf(offsetArr[1]));
                } else {
                    offset = new Point(0, 0);
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret offset parameter: " + theOffset, e);
                offset = new Point(0, 0);
            }
            dl.addBlock(new Block(decoration, pos, size, offset));
        }
        return dl;
    }

    public void addBlock(Block b) {
        this.blocks.add(b);
    }

    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) {
        for (Block b : this.blocks) {
            try {
                this.resetGraphics(g2d);
                b.paint(g2d, paintArea, mapContent);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "couldn't paint due to: ", e);
            }
        }
    }

    private void resetGraphics(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setColor(Color.WHITE);
        g2d.setBackground(Color.BLACK);
        g2d.setClip(null);
        g2d.setPaint(Color.WHITE);
        g2d.setStroke(new BasicStroke());
    }

    private static MapDecoration getDecoration(String name) {
        Object o = GeoServerExtensions.bean((String)name);
        if (o instanceof MapDecoration) {
            return (MapDecoration)o;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public static Color parseColor(String origInput) {
        if (origInput == null) {
            return null;
        }
        String input = origInput.trim();
        input = input.replaceFirst("\\A#", "");
        switch (input.length()) {
            case 1: 
            case 2: {
                return new Color(Integer.valueOf(input, 16));
            }
            case 3: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                return new Color(r, g, b);
            }
            case 4: {
                int r = Integer.valueOf(input.substring(0, 1), 16);
                int g = Integer.valueOf(input.substring(1, 2), 16);
                int b = Integer.valueOf(input.substring(2, 3), 16);
                int a = Integer.valueOf(input.substring(3, 4), 16);
                return new Color(r, g, b, a);
            }
            case 6: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            case 8: {
                int r = Integer.valueOf(input.substring(0, 2), 16);
                int g = Integer.valueOf(input.substring(2, 4), 16);
                int b = Integer.valueOf(input.substring(4, 6), 16);
                int a = Integer.valueOf(input.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
        }
        throw new RuntimeException("Couldn't decode color value: " + origInput + " (" + input + ")");
    }

    public static class Block {
        final MapDecoration decoration;
        final Position position;
        final Dimension dimension;
        final Point offset;

        public static Rectangle findBounds(Position p, Rectangle container, Dimension dim, Point o) {
            if (p == null || container == null || dim == null || o == null) {
                throw new ServiceException("Bad params for decoration sizing.");
            }
            int x = 0;
            int y = 0;
            int height = dim.height;
            int width = dim.width;
            switch (p) {
                case UC: 
                case UR: 
                case UL: {
                    y = (int)(container.getMinY() + (double)o.y);
                    break;
                }
                case CL: 
                case CC: 
                case CR: {
                    y = (int)(container.getMinY() + container.getMaxY() - (double)dim.height) / 2;
                    break;
                }
                case LL: 
                case LC: 
                case LR: {
                    y = (int)(container.getMaxY() - (double)o.y - (double)dim.height);
                }
            }
            switch (p) {
                case UL: 
                case CL: 
                case LL: {
                    x = (int)(container.getMinX() + (double)o.x);
                    break;
                }
                case UC: 
                case CC: 
                case LC: {
                    x = (int)(container.getMinX() + container.getMaxX() - dim.getWidth()) / 2;
                    break;
                }
                case UR: 
                case CR: 
                case LR: {
                    x = (int)(container.getMaxX() - (double)o.x - (double)dim.width);
                }
            }
            if (dim.width + 2 * o.x > container.width) {
                x = (int)container.getMinX() + o.x;
                width = container.width - 2 * o.x;
            }
            if (dim.height + 2 * o.y > container.height) {
                y = (int)container.getMinY() + o.y;
                height = container.height - 2 * o.y;
            }
            return new Rectangle(x, y, width, height);
        }

        public Block(MapDecoration d, Position p, Dimension dim, Point o) {
            this.decoration = d;
            this.position = p;
            this.dimension = dim;
            this.offset = o;
        }

        public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) throws Exception {
            return this.dimension != null ? this.dimension : this.decoration.findOptimalSize(g2d, mapContent);
        }

        public void paint(Graphics2D g2d, Rectangle rect, WMSMapContent mapContent) throws Exception {
            Dimension desiredSize = this.findOptimalSize(g2d, mapContent);
            Rectangle box = Block.findBounds(this.position, rect, desiredSize, this.offset);
            Shape oldClip = g2d.getClip();
            g2d.setClip(box);
            this.decoration.paint(g2d, box, mapContent);
            g2d.setClip(oldClip);
        }

        public static enum Position {
            UL("top,left"),
            UC("top,center"),
            UR("top,right"),
            CL("center,left"),
            CC("center,center"),
            CR("center,right"),
            LL("bottom,left"),
            LC("bottom,center"),
            LR("bottom,right");

            private final String name;

            private Position(String name) {
                this.name = name;
            }

            public static Position fromString(String str) {
                for (Position p : Position.values()) {
                    if (!p.name.equalsIgnoreCase(str)) continue;
                    return p;
                }
                return null;
            }
        }
    }
}

