/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class CapabilitiesTransformerProjectionHandler
extends ProjectionHandler {
    public CapabilitiesTransformerProjectionHandler(ProjectionHandler handler) throws FactoryException {
        super(handler.getSourceCRS(), (Envelope)handler.getValidAreaBounds(), handler.getRenderingEnvelope());
    }

    protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        return super.transformEnvelope(envelope, targetCRS);
    }

    public static CapabilitiesTransformerProjectionHandler create(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs) throws MismatchedDimensionException, FactoryException {
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope(targetCrs), (CoordinateReferenceSystem)sourceCrs, (boolean)false);
        if (handler != null) {
            return new CapabilitiesTransformerProjectionHandler(handler);
        }
        return null;
    }
}

