/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.filters.GeoServerFilter;
import org.geotools.util.logging.Logging;

public class AnimatorFilter
implements GeoServerFilter {
    private static final Logger LOGGER = Logging.getLogger(AnimatorFilter.class);
    private static final String ENDPOINT = "animate";
    private static final String REQUEST = "Request";
    private static final String GETMAP = "GetMap";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest requestHTTP;
        if (request instanceof HttpServletRequest && this.requestNeedsWrapper(requestHTTP = (HttpServletRequest)request)) {
            LOGGER.log(Level.FINER, "Modified request to {0}, removed \"Request\" KVP argument (GEOS-6006)", requestHTTP.getRequestURI());
            request = new RequestWrapper(requestHTTP);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean requestNeedsWrapper(HttpServletRequest request) {
        if (request.getRequestURI().endsWith(ENDPOINT)) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!REQUEST.equalsIgnoreCase(name) || !GETMAP.equalsIgnoreCase(request.getParameter(name))) continue;
                return true;
            }
        }
        return false;
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private RequestWrapper(HttpServletRequest wrapped) {
            super(wrapped);
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }

        public Map<String, String[]> getParameterMap() {
            Map original = super.getParameterMap();
            HashMap<String, String[]> filtered = new HashMap<String, String[]>();
            for (Map.Entry entry : original.entrySet()) {
                String key = (String)entry.getKey();
                if (AnimatorFilter.REQUEST.equalsIgnoreCase(key)) continue;
                filtered.put(key, (String[])entry.getValue());
            }
            return filtered;
        }

        public String[] getParameterValues(String name) {
            if (AnimatorFilter.REQUEST.equalsIgnoreCase(name)) {
                return null;
            }
            return super.getParameterValues(name);
        }

        public String getParameter(String name) {
            if (AnimatorFilter.REQUEST.equalsIgnoreCase(name)) {
                return null;
            }
            return super.getParameter(name);
        }
    }
}

