/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Request;
import org.geoserver.ows.WorkspaceQualifyingCallback;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WebMapService;

public class WMSWorkspaceQualifier
extends WorkspaceQualifyingCallback {
    public WMSWorkspaceQualifier(Catalog catalog) {
        super(catalog);
    }

    protected void qualifyRequest(WorkspaceInfo ws, PublishedInfo l, Service service, Request request) {
        if (WebMapService.class.isInstance(service.getService()) && request.getRawKvp() != null) {
            String style;
            String styles;
            String layer;
            String layers = (String)request.getRawKvp().get("LAYERS");
            if (layers != null) {
                request.getRawKvp().put("LAYERS", this.qualifyLayerNamesKVP(layers, ws));
            }
            if ((layers = (String)request.getRawKvp().get("QUERY_LAYERS")) != null) {
                request.getRawKvp().put("QUERY_LAYERS", this.qualifyLayerNamesKVP(layers, ws));
            }
            if ((layer = (String)request.getRawKvp().get("LAYER")) != null) {
                request.getRawKvp().put("LAYER", this.qualifyName(layer, ws));
            }
            if ((styles = (String)request.getRawKvp().get("STYLES")) != null && !styles.trim().isEmpty()) {
                request.getRawKvp().put("STYLES", this.qualifyStyleNamesKVP(styles, ws));
            }
            if ((style = (String)request.getRawKvp().get("STYLE")) != null && !style.trim().isEmpty()) {
                request.getRawKvp().put("STYLE", this.qualifyStyleName(style, ws));
            }
        }
    }

    protected void qualifyRequest(WorkspaceInfo ws, PublishedInfo l, Operation operation, Request request) {
        GetCapabilitiesRequest gc = (GetCapabilitiesRequest)this.parameter(operation, GetCapabilitiesRequest.class);
        if (gc != null) {
            gc.setNamespace(ws.getName());
            return;
        }
    }

    String qualifyLayerNamesKVP(String layers, WorkspaceInfo ws) {
        List list = KvpUtils.readFlat((String)layers);
        this.qualifyLayerNames(list, ws);
        return this.toCommaSeparatedList(list);
    }

    protected void qualifyLayerNames(List<String> names, WorkspaceInfo ws) {
        for (int i = 0; i < names.size(); ++i) {
            String baseName = names.get(i);
            String qualified = this.qualifyName(baseName, ws);
            if (this.catalog.getLayerByName(qualified) != null || this.catalog.getLayerGroupByName(baseName) == null) {
                names.set(i, qualified);
                continue;
            }
            if (this.catalog.getLayerGroupByName(qualified) == null) continue;
            names.set(i, qualified);
        }
    }

    String qualifyStyleNamesKVP(String styles, WorkspaceInfo ws) {
        List list = KvpUtils.readFlat((String)styles);
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            name = this.qualifyStyleName(name, ws);
            list.set(i, name);
        }
        return this.toCommaSeparatedList(list);
    }

    private String qualifyStyleName(String name, WorkspaceInfo ws) {
        String qualified = this.qualifyName(name, ws);
        if (this.catalog.getStyleByName(qualified) != null) {
            return qualified;
        }
        return name;
    }

    private String toCommaSeparatedList(List<String> list) {
        return String.join((CharSequence)",", list);
    }
}

