/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSRequest;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.locationtech.jts.geom.Envelope;
import org.springframework.util.StringUtils;
import org.vfny.geoserver.util.Requests;

public class WMSRequests {
    public static String getTiledGetMapUrl(GeoServer geoserver, GetMapRequest req, Layer layer, int layerIndex, Envelope bbox, String[] kvp) {
        LinkedHashMap<String, String> params = WMSRequests.getGetMapParams(req, layer.getTitle(), layerIndex, layer.getStyle().getName(), bbox, kvp);
        String baseUrl = WMSRequests.getTileCacheBaseUrl(req, geoserver);
        if (baseUrl == null) {
            return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
        return ResponseUtils.buildURL((String)baseUrl, (String)"", params, (URLMangler.URLType)URLMangler.URLType.EXTERNAL);
    }

    private static String getTileCacheBaseUrl(GetMapRequest req, GeoServer geoServer) {
        String tileCacheBaseUrl = (String)((Object)geoServer.getGlobal().getMetadata().get((Object)"tileCache"));
        if (tileCacheBaseUrl != null) {
            try {
                new URL(tileCacheBaseUrl);
                return tileCacheBaseUrl;
            }
            catch (MalformedURLException e1) {
                try {
                    String baseUrl = req.getBaseUrl();
                    URL base = new URL(baseUrl);
                    baseUrl = base.getProtocol() + ":" + base.getPort() + "//" + base.getHost();
                    String url = Requests.appendContextPath((String)baseUrl, (String)tileCacheBaseUrl);
                    new URL(url);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getGetMapUrl(GetMapRequest req, Layer layer, int layerIndex, Envelope bbox, String[] kvp) {
        String layerName = layer != null ? layer.getTitle() : null;
        String style = layer != null ? layer.getStyle().getName() : null;
        LinkedHashMap<String, String> params = WMSRequests.getGetMapParams(req, layerName, layerIndex, style, bbox, kvp);
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static String getGetMapUrl(GetMapRequest req, String layer, int layerIndex, String style, Envelope bbox, String[] kvp) {
        LinkedHashMap<String, String> params = WMSRequests.getGetMapParams(req, layer, layerIndex, style, bbox, kvp);
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static String getGetLegendGraphicUrl(WMSRequest req, Layer[] layers, String[] kvp) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", "wms");
        params.put("request", "GetLegendGraphic");
        params.put("version", "1.1.1");
        params.put("format", "image/png");
        params.put("layer", WMSRequests.getLayerTitles(layers));
        params.put("style", WMSRequests.getLayerStyles(layers));
        params.put("height", "20");
        params.put("width", "20");
        for (int i = 0; kvp != null && i < kvp.length; i += 2) {
            params.put(kvp[i], kvp[i + 1]);
        }
        return ResponseUtils.buildURL((String)req.getBaseUrl(), (String)"wms", params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private static String getLayerTitles(Layer[] layers) {
        StringBuilder sb = new StringBuilder();
        for (Layer layer : layers) {
            if (layer != null && layer.getTitle() != null) {
                sb.append(layer.getTitle());
            }
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String getLayerStyles(Layer[] layers) {
        StringBuilder sb = new StringBuilder();
        for (Layer layer : layers) {
            sb.append(layer.getStyle().getName()).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    static LinkedHashMap<String, String> getGetMapParams(GetMapRequest req, String layer, int layerIndex, String style, Envelope bbox, String[] kvp) {
        String palette;
        String tilesOrigin;
        String propertyName;
        int i;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("service", "wms");
        params.put("request", "GetMap");
        params.put("version", "1.1.1");
        params.put("format", req.getFormat());
        StringBuffer layers = new StringBuffer();
        StringBuffer styles = new StringBuffer();
        boolean useLayerIndex = true;
        int count = 0;
        for (i = 0; i < req.getLayers().size(); ++i) {
            if (layer == null || !layer.equals(req.getLayers().get(i).getName())) continue;
            ++count;
        }
        if (count == 1) {
            useLayerIndex = false;
        }
        if (layer != null) {
            layers.append(layer);
            if (style != null) {
                styles.append(style);
            } else if (useLayerIndex) {
                styles.append(req.getLayers().get(layerIndex).getDefaultStyle().getName());
            } else {
                for (i = 0; i < req.getLayers().size(); ++i) {
                    if (!layer.equals(req.getLayers().get(i).getName())) continue;
                    styles.append(req.getLayers().get(i).getDefaultStyle().getName());
                }
            }
        } else {
            for (i = 0; i < req.getLayers().size(); ++i) {
                MapLayerInfo mapLayer = req.getLayers().get(i);
                Style s = req.getStyles().get(0);
                layers.append(mapLayer.getName()).append(",");
                styles.append(s.getName()).append(",");
            }
            layers.setLength(layers.length() - 1);
            styles.setLength(styles.length() - 1);
        }
        params.put("layers", layers.toString());
        params.put("styles", styles.toString());
        Map<String, String> kvpMap = req.getRawKvp();
        if (layer != null) {
            List sortBy;
            List interpolations;
            List filters;
            int index;
            if (useLayerIndex) {
                index = layerIndex;
            } else {
                for (index = 0; index < req.getLayers().size() && !req.getLayers().get(index).getName().equals(layer); ++index) {
                }
            }
            index = WMSRequests.getRawLayerIndex(req, index);
            if (req.getRawKvp().get("filter") != null) {
                filters = KvpUtils.readFlat((String)req.getRawKvp().get("filter"), (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
                params.put("filter", (String)filters.get(index));
            } else if (req.getRawKvp().get("cql_filter") != null) {
                filters = KvpUtils.readFlat((String)req.getRawKvp().get("cql_filter"), (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
                params.put("cql_filter", (String)filters.get(index));
            } else if (req.getRawKvp().get("featureid") != null) {
                params.put("featureid", req.getRawKvp().get("featureid"));
            }
            if (!StringUtils.isEmpty((Object)kvpMap.get("interpolations")) && !((String)(interpolations = KvpUtils.readFlat((String)kvpMap.get("interpolations"))).get(index)).isEmpty()) {
                params.put("interpolations", (String)interpolations.get(index));
            }
            if (!StringUtils.isEmpty((Object)kvpMap.get("sortby")) && !((String)(sortBy = KvpUtils.readFlat((String)kvpMap.get("sortby"), (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER)).get(index)).isEmpty()) {
                params.put("sortby", (String)sortBy.get(index));
            }
        } else {
            if (req.getRawKvp().get("filter") != null) {
                params.put("filter", req.getRawKvp().get("filter"));
            } else if (req.getRawKvp().get("cql_filter") != null) {
                params.put("cql_filter", req.getRawKvp().get("cql_filter"));
            } else if (req.getRawKvp().get("featureid") != null) {
                params.put("featureid", req.getRawKvp().get("featureid"));
            }
            if (!StringUtils.isEmpty((Object)kvpMap.get("interpolations"))) {
                params.put("interpolations", kvpMap.get("interpolations"));
            }
            if (!StringUtils.isEmpty((Object)kvpMap.get("sortby"))) {
                params.put("sortby", kvpMap.get("sortby"));
            }
        }
        if (kvpMap.get("time") != null) {
            params.put("time", kvpMap.get("time"));
        }
        if (kvpMap.get("elevation") != null) {
            params.put("elevation", kvpMap.get("elevation"));
        }
        kvpMap.entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase().startsWith("dim_")).forEach(e -> params.put(((String)e.getKey()).toLowerCase(), (String)e.getValue()));
        params.put("height", String.valueOf(req.getHeight()));
        params.put("width", String.valueOf(req.getWidth()));
        params.put("transparent", "" + req.isTransparent());
        if (bbox == null) {
            bbox = req.getBbox();
        }
        if (bbox != null) {
            params.put("bbox", WMSRequests.encode(bbox));
        }
        params.put("srs", req.getSRS());
        if (req.getFormatOptions() != null && !req.getFormatOptions().isEmpty()) {
            params.put("format_options", WMSRequests.encodeFormatOptions(req.getFormatOptions()));
        }
        if (req.getViewParams() != null && !req.getViewParams().isEmpty()) {
            params.put("viewParams", WMSRequests.encodeFormatOptions(req.getViewParams()));
        }
        if ((propertyName = kvpMap.get("propertyName")) != null && !propertyName.isEmpty()) {
            params.put("propertyName", propertyName);
        }
        if (!StringUtils.isEmpty((Object)kvpMap.get("bgcolor"))) {
            params.put("bgcolor", kvpMap.get("bgcolor"));
        }
        if (!req.getExceptions().equals("SE_XML")) {
            params.put("exceptions", req.getExceptions());
        }
        if (req.getMaxFeatures() != null) {
            params.put("maxfeatures", req.getMaxFeatures().toString());
        }
        if (req.getRemoteOwsType() != null) {
            params.put("remote_ows_type", req.getRemoteOwsType());
        }
        if (req.getRemoteOwsURL() != null) {
            String url = ResponseUtils.urlDecode((String)req.getRemoteOwsURL().toString());
            params.put("remote_ows_url", url);
        }
        if (req.getScaleMethod() != null) {
            params.put("scalemethod", req.getScaleMethod().toString());
        }
        if (req.getStartIndex() != null) {
            params.put("startindex", req.getStartIndex().toString());
        }
        if (!req.getStyleFormat().equals("sld")) {
            params.put("style_format", req.getStyleFormat());
        }
        if (req.getStyleVersion() != null) {
            params.put("style_version", req.getStyleVersion());
        }
        if (Boolean.TRUE.equals(req.getValidateSchema())) {
            params.put("validateschema", "true");
        }
        if (req.getSld() != null) {
            params.put("sld", ResponseUtils.urlDecode((String)req.getSld().toString()));
        }
        if (req.getSldBody() != null) {
            params.put("sld_body", req.getSldBody());
        }
        if (req.getEnv() != null && !req.getEnv().isEmpty()) {
            params.put("env", WMSRequests.encodeFormatOptions(req.getEnv()));
        }
        if ((tilesOrigin = kvpMap.get("tilesorigin")) != null && !tilesOrigin.isEmpty()) {
            params.put("tilesorigin", tilesOrigin);
        }
        if (req.isTiled()) {
            params.put("tiled", req.isTiled() ? "true" : "false");
        }
        if ((palette = kvpMap.get("palette")) != null && !palette.isEmpty()) {
            params.put("palette", palette);
        }
        if (req.getBuffer() > 0) {
            params.put("buffer", Integer.toString(req.getBuffer()));
        }
        if (Double.compare(req.getAngle(), 0.0) != 0) {
            params.put("angle", Double.toString(req.getAngle()));
        }
        for (int i2 = 0; kvp != null && i2 < kvp.length; i2 += 2) {
            params.put(kvp[i2], kvp[i2 + 1]);
        }
        return params;
    }

    private static int getRawLayerIndex(GetMapRequest req, int layerIndex) {
        List names = KvpUtils.readFlat((String)req.getRawKvp().get("layers"));
        if (names.size() == 1) {
            return 0;
        }
        if (names.size() == req.getLayers().size()) {
            return layerIndex;
        }
        List<?> layers = new LayerParser(WMS.get()).parseLayers(names, req.getRemoteOwsURL(), req.getRemoteOwsType());
        int numLayers = 0;
        for (int index = 0; index < layers.size(); ++index) {
            numLayers = layers.get(index) instanceof LayerGroupInfo ? (numLayers += ((LayerGroupInfo)layers.get(index)).layers().size()) : ++numLayers;
            if (numLayers <= layerIndex) continue;
            return index;
        }
        throw new IllegalArgumentException("Unable to determine raw index for " + layerIndex + " in " + names);
    }

    public static void mergeEntry(Map<String, String> kvp, Map<String, Object> formatOptions, String key) throws Exception {
        Object foValue;
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        String service = KvpUtils.getSingleValue(kvp, (String)"service");
        String version = KvpUtils.getSingleValue(kvp, (String)"version");
        String request = KvpUtils.getSingleValue(kvp, (String)"request");
        KvpUtils.purgeParsers((List)parsers, (String)service, (String)version, (String)request);
        String val = null;
        val = kvp.get(key);
        if (val != null && (foValue = formatOptions.get(key)) == null) {
            Object parsed = KvpUtils.parseKey((String)key, (String)val, (String)service, (String)request, (String)version, (List)parsers);
            if (parsed != null) {
                formatOptions.put(key, parsed);
            } else {
                formatOptions.put(key, val);
            }
        }
    }

    public static void encodeFormatOptions(Map formatOptions, StringBuffer sb) {
        if (formatOptions == null || formatOptions.isEmpty()) {
            return;
        }
        for (Map.Entry entry : formatOptions.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append(":");
            if (val instanceof Collection) {
                Iterator i = ((Collection)val).iterator();
                while (i.hasNext()) {
                    sb.append(i.next()).append(",");
                }
                sb.setLength(sb.length() - 1);
            } else if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(val, i);
                    if (o == null) continue;
                    sb.append(o).append(",");
                }
                sb.setLength(sb.length() - 1);
            } else {
                sb.append(val.toString());
            }
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
    }

    public static String encodeFormatOptions(Map formatOptions) {
        StringBuffer sb = new StringBuffer();
        WMSRequests.encodeFormatOptions(formatOptions, sb);
        return sb.toString();
    }

    public static String encodeFormatOptions(List<Map<String, String>> formatOptions) {
        if (formatOptions == null || formatOptions.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map<String, String> map : formatOptions) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            WMSRequests.encodeFormatOptions(map, sb);
        }
        sb.setLength(sb.length());
        return sb.toString();
    }

    static String encode(Envelope box) {
        return new StringBuffer().append(box.getMinX()).append(",").append(box.getMinY()).append(",").append(box.getMaxX()).append(",").append(box.getMaxY()).toString();
    }

    private static class LayerParser
    extends GetMapKvpRequestReader {
        public LayerParser(WMS wms) {
            super(wms);
        }

        @Override
        protected List<?> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) {
            try {
                return super.parseLayers(requestedLayerNames, remoteOwsUrl, remoteOwsType);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing layers list", e);
            }
        }
    }
}

