/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.media.jai.Interpolation;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.ScaleComputationMethod;
import org.geoserver.wms.WMSRequest;
import org.geotools.styling.Style;
import org.geotools.util.Version;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GetMapRequest
extends WMSRequest
implements Cloneable {
    static final Color DEFAULT_BG = Color.white;
    public static final String SE_XML = "SE_XML";
    private MandatoryParameters mandatoryParams = new MandatoryParameters();
    private OptionalParameters optionalParams = new OptionalParameters();
    private Map<String, Object> formatOptions = new CaseInsensitiveMap(new HashMap());
    private Map env = new HashMap();
    private List<Map<String, String>> viewParams = null;
    private Map<String, String> httpRequestHeaders;

    public GetMapRequest() {
        super("GetMap");
    }

    public Envelope getBbox() {
        return this.mandatoryParams.bbox;
    }

    public Color getBgColor() {
        return this.optionalParams.bgColor;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.optionalParams.crs;
    }

    public String getSRS() {
        return this.optionalParams.srs;
    }

    public String getExceptions() {
        return this.optionalParams.exceptions;
    }

    public String getFormat() {
        return this.mandatoryParams.format;
    }

    public Map getFormatOptions() {
        return this.formatOptions == null ? Collections.EMPTY_MAP : this.formatOptions;
    }

    public Map getEnv() {
        return this.env;
    }

    public List<Map<String, String>> getViewParams() {
        return this.viewParams;
    }

    public int getHeight() {
        return this.mandatoryParams.height;
    }

    public List<MapLayerInfo> getLayers() {
        List<MapLayerInfo> layers = this.mandatoryParams.layers;
        return layers;
    }

    public List<Style> getStyles() {
        return this.mandatoryParams.styles;
    }

    public List<Interpolation> getInterpolations() {
        return this.optionalParams.interpolationMethods;
    }

    public URL getSld() {
        return this.getStyleUrl();
    }

    public URL getStyleUrl() {
        return this.optionalParams.styleUrl;
    }

    public String getSldBody() {
        return this.getStyleBody();
    }

    public String getStyleBody() {
        return this.optionalParams.styleBody;
    }

    public String getSldVersion() {
        return this.getStyleVersion();
    }

    public String getStyleVersion() {
        return this.optionalParams.styleVersion;
    }

    public Version styleVersion() {
        return this.getStyleVersion() != null ? new Version(this.getStyleVersion()) : null;
    }

    public String getStyleFormat() {
        return this.optionalParams.styleFormat;
    }

    public Boolean getValidateSchema() {
        return this.optionalParams.validateSLD;
    }

    public List getFilter() {
        return this.optionalParams.filters;
    }

    public List getCQLFilter() {
        return this.optionalParams.cqlFilters;
    }

    public List getFeatureId() {
        return this.optionalParams.featureIds;
    }

    public boolean isTransparent() {
        return this.optionalParams.transparent;
    }

    public boolean isTiled() {
        return this.optionalParams.tiled;
    }

    public Point2D getTilesOrigin() {
        return this.optionalParams.tilesOrigin;
    }

    public int getBuffer() {
        return this.optionalParams.buffer;
    }

    public IndexColorModel getPalette() {
        return this.optionalParams.icm;
    }

    public int getWidth() {
        return this.mandatoryParams.width;
    }

    public List<Object> getTime() {
        return this.optionalParams.time;
    }

    public List<Object> getElevation() {
        return this.optionalParams.elevation;
    }

    public String getFeatureVersion() {
        return this.optionalParams.featureVersion;
    }

    public String getRemoteOwsType() {
        return this.optionalParams.remoteOwsType;
    }

    public URL getRemoteOwsURL() {
        return this.optionalParams.remoteOwsURL;
    }

    public void setBbox(Envelope bbox) {
        this.mandatoryParams.bbox = bbox;
    }

    public void setBgColor(Color bgColor) {
        this.optionalParams.bgColor = bgColor;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.optionalParams.crs = crs;
    }

    public void setSRS(String srs) {
        this.optionalParams.srs = srs;
    }

    public void setExceptions(String exceptions) {
        this.optionalParams.exceptions = exceptions;
    }

    public void setFormat(String format) {
        this.mandatoryParams.format = format;
    }

    public void setFormatOptions(Map formatOptions) {
        this.formatOptions = formatOptions;
    }

    public void setEnv(Map enviroment) {
        this.env = enviroment;
    }

    public void setViewParams(List<Map<String, String>> viewParams) {
        this.viewParams = viewParams;
    }

    public void setHeight(int height) {
        this.mandatoryParams.height = height;
    }

    public void setHeight(Integer height) {
        this.mandatoryParams.height = height;
    }

    public void setLayers(List<MapLayerInfo> layers) {
        this.mandatoryParams.layers = layers == null ? Collections.EMPTY_LIST : layers;
    }

    public void setStyles(List<Style> styles) {
        this.mandatoryParams.styles = styles == null ? Collections.EMPTY_LIST : new ArrayList<Style>(styles);
    }

    public void setInterpolations(List<Interpolation> interpolations) {
        this.optionalParams.interpolationMethods = interpolations == null ? Collections.EMPTY_LIST : interpolations;
    }

    public void setSld(URL sld) {
        this.setStyleUrl(sld);
    }

    public void setStyleUrl(URL styleUrl) {
        this.optionalParams.styleUrl = styleUrl;
    }

    public void setSldBody(String sldBody) {
        this.setStyleBody(sldBody);
    }

    public void setStyleBody(String styleBody) {
        this.optionalParams.styleBody = styleBody;
    }

    public void setSldVersion(String sldVersion) {
        this.setStyleVersion(sldVersion);
    }

    public void setStyleVersion(String styleVersion) {
        this.optionalParams.styleVersion = styleVersion;
    }

    public void setStyleFormat(String styleFormat) {
        this.optionalParams.styleFormat = styleFormat;
    }

    public void setValidateSchema(Boolean validateSLD) {
        this.optionalParams.validateSLD = validateSLD;
    }

    public void setFilter(List filters) {
        this.optionalParams.filters = filters;
    }

    public void setCQLFilter(List cqlFilters) {
        this.optionalParams.cqlFilters = cqlFilters;
    }

    public void setFeatureId(List featureIds) {
        this.optionalParams.featureIds = featureIds;
    }

    public void setTransparent(boolean transparent) {
        this.optionalParams.transparent = transparent;
    }

    public void setTransparent(Boolean transparent) {
        this.optionalParams.transparent = transparent != null ? transparent : false;
    }

    public void setBuffer(int buffer) {
        this.optionalParams.buffer = buffer;
    }

    public void setPalette(IndexColorModel icm) {
        this.optionalParams.icm = icm;
    }

    public void setBuffer(Integer buffer) {
        this.optionalParams.buffer = buffer != null ? buffer : 0;
    }

    public void setTiled(boolean tiled) {
        this.optionalParams.tiled = tiled;
    }

    public void setTiled(Boolean tiled) {
        this.optionalParams.tiled = tiled != null ? tiled : false;
    }

    public void setTilesOrigin(Point2D origin) {
        this.optionalParams.tilesOrigin = origin;
    }

    public void setWidth(int width) {
        this.mandatoryParams.width = width;
    }

    public void setWidth(Integer width) {
        this.mandatoryParams.width = width;
    }

    public void setTime(List<Object> time) {
        this.optionalParams.time = new ArrayList<Object>(time);
    }

    public void setElevation(double elevation) {
        this.optionalParams.elevation = new ArrayList<Object>();
        this.optionalParams.elevation.add(elevation);
    }

    public void setElevation(List<Object> elevation) {
        this.optionalParams.elevation = new ArrayList<Object>(elevation);
    }

    public void setFeatureVersion(String featureVersion) {
        this.optionalParams.featureVersion = featureVersion;
    }

    public void setRemoteOwsType(String remoteOwsType) {
        this.optionalParams.remoteOwsType = remoteOwsType;
    }

    public void setRemoteOwsURL(URL remoteOwsURL) {
        this.optionalParams.remoteOwsURL = remoteOwsURL;
    }

    public void setMaxFeatures(Integer maxFeatures) {
        this.optionalParams.maxFeatures = maxFeatures;
    }

    public Integer getMaxFeatures() {
        return this.optionalParams.maxFeatures;
    }

    public void setStartIndex(Integer startIndex) {
        this.optionalParams.startIndex = startIndex;
    }

    public Integer getStartIndex() {
        return this.optionalParams.startIndex;
    }

    public double getAngle() {
        return this.optionalParams.angle;
    }

    public void setAngle(double rotation) {
        this.optionalParams.angle = rotation;
    }

    public List<List<SortBy>> getSortBy() {
        return this.optionalParams.sortBy;
    }

    public List<SortBy[]> getSortByArrays() {
        if (this.optionalParams.sortBy == null) {
            return null;
        }
        return this.optionalParams.sortBy.stream().map(l -> l.toArray(new SortBy[l.size()])).collect(Collectors.toList());
    }

    public void setSortBy(List<List<SortBy>> sortBy) {
        this.optionalParams.sortBy = sortBy;
    }

    public ScaleComputationMethod getScaleMethod() {
        return this.optionalParams.scaleMethod;
    }

    public void setScaleMethod(ScaleComputationMethod scaleMethod) {
        this.optionalParams.scaleMethod = scaleMethod;
    }

    public Geometry getClip() {
        return this.optionalParams.clip;
    }

    public void setClip(Geometry clip) {
        this.optionalParams.clip = clip;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nGetMap Request");
        returnString.append("\n version: " + this.version);
        returnString.append("\n output format: " + this.mandatoryParams.format);
        returnString.append("\n width height: " + this.mandatoryParams.width + "," + this.mandatoryParams.height);
        returnString.append("\n bbox: " + this.mandatoryParams.bbox);
        returnString.append("\n layers: ");
        Iterator<MapLayerInfo> i = this.mandatoryParams.layers.iterator();
        while (i.hasNext()) {
            returnString.append(i.next().getName());
            if (!i.hasNext()) continue;
            returnString.append(",");
        }
        returnString.append("\n styles: ");
        Iterator<Style> it = this.mandatoryParams.styles.iterator();
        while (it.hasNext()) {
            Style s = it.next();
            returnString.append(s.getName());
            if (!it.hasNext()) continue;
            returnString.append(",");
        }
        return returnString.toString();
    }

    public String getHttpRequestHeader(String headerName) {
        return this.httpRequestHeaders == null ? null : this.httpRequestHeaders.get(headerName);
    }

    public void putHttpRequestHeader(String headerName, String value) {
        if (this.httpRequestHeaders == null) {
            this.httpRequestHeaders = new CaseInsensitiveMap(new HashMap());
        }
        this.httpRequestHeaders.put(headerName, value);
    }

    public Object clone() {
        try {
            GetMapRequest copy = (GetMapRequest)super.clone();
            copy.mandatoryParams = (MandatoryParameters)this.mandatoryParams.clone();
            copy.optionalParams = (OptionalParameters)this.optionalParams.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected, could not clone GetMapRequest", e);
        }
    }

    public List<String> getCustomDimension(String dimensionName) {
        if (this.getRawKvp() != null) {
            String key = "DIM_" + dimensionName;
            String value = this.getRawKvp().get(key);
            if (value != null) {
                ArrayList<String> values = new ArrayList<String>(1);
                if (value.indexOf(",") > 0) {
                    String[] elements = value.split("\\s*,\\s*");
                    values.addAll(Arrays.asList(elements));
                } else {
                    values.add(value);
                }
                return values;
            }
        }
        return null;
    }

    private class OptionalParameters
    implements Cloneable {
        Boolean animatedGIFLoopContinuosly;
        Integer animatedGIFDelay;
        Color bgColor = DEFAULT_BG;
        CoordinateReferenceSystem crs;
        String srs;
        List filters;
        List cqlFilters;
        List featureIds;
        List<List<SortBy>> sortBy;
        String exceptions = "SE_XML";
        boolean transparent = false;
        boolean tiled;
        public Point2D tilesOrigin;
        int buffer;
        IndexColorModel icm;
        List<Object> time = Collections.emptyList();
        List<Object> elevation = Collections.emptyList();
        URL styleUrl;
        String styleBody;
        String styleVersion;
        String styleFormat = "sld";
        Boolean validateSLD = Boolean.FALSE;
        String featureVersion;
        String remoteOwsType;
        URL remoteOwsURL;
        Integer maxFeatures;
        Integer startIndex;
        double angle;
        ScaleComputationMethod scaleMethod;
        List<Interpolation> interpolationMethods = Collections.EMPTY_LIST;
        Geometry clip;

        private OptionalParameters() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class MandatoryParameters
    implements Cloneable {
        List<MapLayerInfo> layers = Collections.emptyList();
        List<Style> styles = Collections.emptyList();
        Envelope bbox;
        int width;
        int height;
        String format;

        private MandatoryParameters() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

