/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GetMapDefaults {
    private static final Logger LOGGER = Logging.getLogger(GetMapDefaults.class);
    private int maxSide = DefaultWebMapService.MAX_SIDE;
    private int maxOpenLayersWidth = DefaultWebMapService.MAX_OL_WIDTH;
    private int minOpenlayersWidth = DefaultWebMapService.MIN_OL_WIDTH;
    private int minOpenLayersHeight = DefaultWebMapService.MIN_OL_HEIGHT;
    private int maxOpenLayersHeight = DefaultWebMapService.MAX_OL_HEIGHT;

    public GetMapRequest autoSetMissingProperties(GetMapRequest getMap) {
        if (getMap.getFormat() == null) {
            getMap.setFormat(DefaultWebMapService.FORMAT);
        }
        if (getMap.getStyles() == null || getMap.getStyles().isEmpty()) {
            if (getMap.getLayers() != null && getMap.getLayers().size() > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(getMap.getLayers().size());
                for (int i = 0; i < getMap.getLayers().size(); ++i) {
                    styles.add(getMap.getLayers().get(i).getDefaultStyle());
                }
                getMap.setStyles(styles);
            } else {
                getMap.setStyles(DefaultWebMapService.STYLES);
            }
        }
        this.autoSetBoundsAndSize(getMap);
        return getMap;
    }

    public void autoSetBoundsAndSize(GetMapRequest getMap) {
        CoordinateReferenceSystem reqCRS;
        List<MapLayerInfo> layers = getMap.getLayers();
        String reqSRS = getMap.getSRS();
        boolean useNativeBounds = true;
        if (reqSRS == null) {
            reqSRS = GetMapDefaults.guessCommonSRS(layers);
            GetMapDefaults.forceSRS(getMap, reqSRS);
        }
        for (int i = 0; useNativeBounds && i < layers.size(); ++i) {
            String layerSRS;
            useNativeBounds = layers.get(i) != null ? reqSRS.equalsIgnoreCase(layerSRS = layers.get(i).getSRS()) && layers.get(i).getResource().getNativeBoundingBox() != null : false;
        }
        try {
            reqCRS = CRS.decode((String)reqSRS);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        Envelope aggregateBbox = getMap.getBbox();
        boolean specifiedBbox = true;
        if (aggregateBbox == null) {
            specifiedBbox = false;
            for (int i = 0; i < layers.size(); ++i) {
                ReferencedEnvelope curbbox;
                block37: {
                    MapLayerInfo layerInfo = layers.get(i);
                    try {
                        curbbox = layerInfo.getLatLongBoundingBox();
                        if (!useNativeBounds) break block37;
                        ReferencedEnvelope nativeBbox = layerInfo.getBoundingBox();
                        if (nativeBbox == null) {
                            try {
                                CoordinateReferenceSystem nativeCrs = layerInfo.getCoordinateReferenceSystem();
                                nativeBbox = curbbox.transform(nativeCrs, true);
                            }
                            catch (Exception e) {
                                throw new ServiceException("Best effort native bbox computation failed", (Throwable)e);
                            }
                        }
                        curbbox = nativeBbox;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (aggregateBbox != null) {
                    aggregateBbox.expandToInclude((Envelope)curbbox);
                    continue;
                }
                aggregateBbox = new ReferencedEnvelope(curbbox);
            }
            ReferencedEnvelope ref = null;
            if (!useNativeBounds && !reqSRS.equalsIgnoreCase(DefaultWebMapService.SRS)) {
                try {
                    ref = new ReferencedEnvelope(aggregateBbox, CRS.decode((String)"EPSG:4326"));
                    aggregateBbox = ref.transform(reqCRS, true);
                }
                catch (ProjectionException pe) {
                    ref.expandBy(-1.0 * ref.getWidth() / 50.0, -1.0 * ref.getHeight() / 50.0);
                    try {
                        aggregateBbox = ref.transform(reqCRS, true);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failed to aggregate box", e);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to aggregate box", e);
                }
            }
        }
        if (aggregateBbox == null) {
            GetMapDefaults.forceSRS(getMap, DefaultWebMapService.SRS);
            aggregateBbox = DefaultWebMapService.BBOX;
        }
        double bbheight = aggregateBbox.getHeight();
        double bbwidth = aggregateBbox.getWidth();
        double bbratio = bbwidth / bbheight;
        double mheight = getMap.getHeight();
        double mwidth = getMap.getWidth();
        if (mheight <= 0.5 || mwidth <= 0.5 || !specifiedBbox) {
            if (mheight > 0.5 && mwidth > 0.5) {
                double mratio = mwidth / mheight;
                if (bbratio > mratio) {
                    double diff = (bbwidth / mratio - bbheight) / 2.0;
                    aggregateBbox.expandBy(0.0, diff);
                } else {
                    double diff = (bbheight * mratio - bbwidth) / 2.0;
                    aggregateBbox.expandBy(diff, 0.0);
                }
                this.adjustBounds(reqSRS, aggregateBbox);
            } else if (mheight > 0.5) {
                mwidth = bbratio * mheight;
            } else if (mwidth > 0.5) {
                mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
            } else {
                if (bbratio > 1.0) {
                    mwidth = this.maxSide;
                    mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
                } else {
                    mheight = this.maxSide;
                    double d = mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
                if ("application/openlayers".equalsIgnoreCase(getMap.getFormat()) || "openlayers".equalsIgnoreCase(getMap.getFormat())) {
                    if (mheight < (double)this.minOpenLayersHeight) {
                        mheight = this.minOpenLayersHeight;
                    } else if (mheight > (double)this.maxOpenLayersHeight) {
                        mheight = this.maxOpenLayersHeight;
                    }
                    if (mwidth < (double)this.minOpenlayersWidth) {
                        mwidth = this.minOpenlayersWidth;
                    } else if (mwidth > (double)this.maxOpenLayersWidth) {
                        mwidth = this.maxOpenLayersWidth;
                    }
                }
            }
            getMap.setBbox(aggregateBbox);
            getMap.setWidth((int)mwidth);
            getMap.setHeight((int)mheight);
        }
    }

    private static String guessCommonSRS(List<MapLayerInfo> layers) {
        String SRS = null;
        for (MapLayerInfo layer : layers) {
            String layerSRS = layer.getSRS();
            if (SRS == null) {
                SRS = layerSRS.toUpperCase();
                continue;
            }
            if (SRS.equals(layerSRS)) continue;
            return DefaultWebMapService.SRS;
        }
        if (SRS == null) {
            return DefaultWebMapService.SRS;
        }
        return SRS;
    }

    private static void forceSRS(GetMapRequest getMap, String srs) {
        getMap.setSRS(srs);
        try {
            getMap.setCrs(CRS.decode((String)srs));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    private Envelope adjustBounds(String reqSRS, Envelope bbox) {
        bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
        if (reqSRS.equalsIgnoreCase("EPSG:4326")) {
            Envelope maxEnv = new Envelope(-180.0, -90.0, 180.0, 90.0);
            return bbox.intersection(maxEnv);
        }
        if (reqSRS.equalsIgnoreCase("EPSG:900913")) {
            Envelope maxEnv = new Envelope(-2.003750833E7, -2.003750833E7, 2.003750833E7, 2.003750833E7);
            return bbox.intersection(maxEnv);
        }
        return bbox;
    }

    public int getMaxOpenLayersWidth() {
        return this.maxOpenLayersWidth;
    }

    public void setMaxOpenLayersWidth(int maxOpenLayersWidth) {
        this.maxOpenLayersWidth = maxOpenLayersWidth;
    }

    public int getMinOpenlayersWidth() {
        return this.minOpenlayersWidth;
    }

    public void setMinOpenlayersWidth(int minOpenlayersWidth) {
        this.minOpenlayersWidth = minOpenlayersWidth;
    }

    public int getMaxSide() {
        return this.maxSide;
    }

    public void setMaxSide(int maxSide) {
        this.maxSide = maxSide;
    }

    public int getMaxOpenLayersHeight() {
        return this.maxOpenLayersHeight;
    }

    public void setMaxOpenLayersHeight(int maxOpenLayersHeight) {
        this.maxOpenLayersHeight = maxOpenLayersHeight;
    }
}

