/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.GetFeatureInfoKvpReader;
import org.geoserver.wms.featureinfo.TextFeatureInfoOutputFormat;
import org.geoserver.wms.wms_1_1_1.CapabilitiesTest;
import org.geotools.filter.v1_1.OGC;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;

public class GetFeatureInfoIntegrationTest
extends WMSTestSupport {
    public static String WCS_PREFIX = "wcs";
    public static String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    public static QName TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
    public static QName SQUARES = new QName(MockData.CITE_URI, "squares", MockData.CITE_PREFIX);
    public static QName CUSTOM = new QName(MockData.CITE_URI, "custom", MockData.CITE_PREFIX);
    public static QName SAMPLEGRIB = new QName(WCS_URI, "sampleGrib", WCS_PREFIX);
    public static QName GENERIC_LINES = new QName(MockData.DEFAULT_URI, "genericLines", MockData.DEFAULT_PREFIX);
    public static QName STATES = new QName(MockData.SF_URI, "states", MockData.SF_PREFIX);

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs10RasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put(WCS_PREFIX, WCS_URI);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wmsInfo.setMaxBuffer(50);
        this.getGeoServer().save((ServiceInfo)wmsInfo);
        Catalog catalog = this.getCatalog();
        testData.addStyle("thickStroke", "thickStroke.sld", CapabilitiesTest.class, catalog);
        testData.addStyle("raster", "raster.sld", CapabilitiesTest.class, catalog);
        testData.addStyle("rasterScales", "rasterScales.sld", CapabilitiesTest.class, catalog);
        testData.addStyle("squares", "squares.sld", CapabilitiesTest.class, catalog);
        testData.addStyle("forestsManyRules", "ForestsManyRules.sld", CapabilitiesTest.class, catalog);
        testData.addVectorLayer(SQUARES, Collections.EMPTY_MAP, "squares.properties", CapabilitiesTest.class, catalog);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(TASMANIA_BM, "tazbm.tiff", "tiff", propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(SAMPLEGRIB, "sampleGrib.tif", null, propertyMap, GetFeatureInfoIntegrationTest.class, catalog);
        testData.addRasterLayer(CUSTOM, "custom.zip", null, propertyMap, CapabilitiesTest.class, catalog);
        testData.addVectorLayer(GENERIC_LINES, Collections.emptyMap(), "genericLines.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("genericLinesStyle", "genericLines.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle("Population", "Population.sld", CapabilitiesTest.class, catalog);
        testData.addVectorLayer(STATES, Collections.emptyMap(), "states.properties", CapabilitiesTest.class, catalog);
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(STATES));
        layer.setQueryable(false);
        catalog.save(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryNonQueryableLayer() throws Exception {
        WMS wms = (WMS)applicationContext.getBean("wms");
        GetFeatureInfoKvpReader reader = (GetFeatureInfoKvpReader)applicationContext.getBean("getFeatureInfoKvpReader");
        try {
            WMS fakeWMS = new WMS(wms.getGeoServer()){

                public boolean isQueryable(LayerInfo layer) {
                    if ("Forests".equals(layer.getName())) {
                        return false;
                    }
                    return super.isQueryable(layer);
                }
            };
            reader.setWMS(fakeWMS);
            String layer = this.getLayerId(MockData.FORESTS);
            String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
            Document doc = this.dom(this.get(request), true);
            XMLAssert.assertXpathEvaluatesTo((String)"LayerNotQueryable", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        }
        finally {
            reader.setWMS(wms);
        }
    }

    @Test
    public void testInvalidPoint() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidPoint", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=A&j=";
        doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidPoint", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
    }

    @Test
    public void testSimple() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllowedMimeTypes() throws Exception {
        WMSInfo wms = this.getWMS().getServiceInfo();
        TextFeatureInfoOutputFormat format = new TextFeatureInfoOutputFormat(this.getWMS());
        wms.getGetFeatureInfoMimeTypes().add(format.getContentType());
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/vnd.ogc.gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("ForbiddenFormat") > 0 ? 1 : 0) != 0);
        wms.getGetFeatureInfoMimeTypes().clear();
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/vnd.ogc.gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/xml; subtype=gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomTemplateManyRules() throws Exception {
        File root = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        File target = new File(root, "workspaces/" + MockData.FORESTS.getPrefix() + "/content.ftl");
        File source = new File("./src/test/resources/org/geoserver/wms/content.ftl");
        try {
            Assert.assertTrue((boolean)source.exists());
            FileUtils.copyFile((File)source, (File)target);
            String layer = this.getLayerId(MockData.FORESTS);
            String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
            Document dom = this.getAsDOM(request);
            XMLAssert.assertXpathExists((String)"/html/body/ul/li/b[text() = 'Type: Forests']", (Document)dom);
            request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=forestsManyRules&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
            dom = this.getAsDOM(request);
            XMLAssert.assertXpathExists((String)"/html/body/ul/li/b[text() = 'Type: Forests']", (Document)dom);
        }
        finally {
            FileUtils.deleteQuietly((File)target);
        }
    }

    @Test
    public void testSimpleHtml() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'Forests.')])", (Document)dom);
    }

    @Test
    public void testBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.3.0&bbox=-4.5,-2.,4.5,7&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300";
        Document dom = this.getAsDOM(base + "&i=85&j=230");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(base + "&i=85&j=230&buffer=40");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
        dom = this.getAsDOM(base + "&i=85&j=230&buffer=300");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    @Test
    public void testAutoBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.3.0&bbox=-4.5,-2.,4.5,7&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300&i=111&j=229";
        Document dom = this.getAsDOM(base + "&styles=");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(base + "&styles=thickStroke");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    @Test
    public void testBufferScales() throws Exception {
        String layer = this.getLayerId(SQUARES);
        String base = "wms?version=1.3.0&&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=squares&bbox=0,0,10000,10000&feature_count=10&srs=EPSG:32632";
        int w = 357142;
        Document dom = this.getAsDOM(this.featureInfoRequest(base, w));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        w = 714285;
        dom = this.getAsDOM(this.featureInfoRequest(base, w));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        w = 3571428;
        dom = this.getAsDOM(this.featureInfoRequest(base, w));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.2'])", (Document)dom);
    }

    private String featureInfoRequest(String base, int w) {
        String request = base + "&width=" + w + "&height=" + w + "&i=20&j=" + (w - 20);
        return request;
    }

    @Test
    public void testTwoLayers() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10&info";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("<style type=\"text/css\">") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUknownFormat() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=unknown/format&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceExceptionReport/ogc:ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidFormat", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"info_format", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@locator", (Document)doc);
    }

    @Test
    public void testCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=text/html&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    @Test
    public void testCoverageGML() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=application/vnd.ogc.gml&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    @Test
    public void testCoverageGML31() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    @Test
    public void testCoverageGML31Plus360() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,506.5,-43,508&width=600&height=600&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    @Test
    public void testCoverageGML31Minus360() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,-213.5,-43,-212&width=600&height=600&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMembers/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    @Test
    public void testCoverageScales() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=rasterScales&bbox=-44.5,146.5,-43,148&info_format=text/html&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request + "&width=300&height=300");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
        dom = this.getAsDOM(request + "&width=600&height=600");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    @Test
    public void testOutsideCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=raster&bbox=0,-90,148,-43&info_format=text/html&query_layers=" + layer + "&width=300&height=300&i=10&j=150&srs=EPSG:4326";
        Document dom = this.getAsDOM(request + "");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
    }

    @Test
    public void testUnknownQueryLayer() throws Exception {
        String layers1 = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String layers2 = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.BRIDGES);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers1 + "&query_layers=" + layers2 + "&width=20&height=20&i=10&j=10&info";
        Document dom = this.getAsDOM(request + "");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ogc:ServiceExceptionReport)", (Document)dom);
    }

    @Test
    public void testDeriveLayersFromSLD() throws Exception {
        String layers = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String sld = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"        xmlns:se=\"http://www.opengis.net/se\" version=\"1.1.0\">  <NamedLayer>   <se:Name>" + this.getLayerId(MockData.FORESTS) + "</se:Name>  </NamedLayer>  <NamedLayer>   <se:Name>" + this.getLayerId(MockData.LAKES) + "</se:Name>  </NamedLayer> </StyledLayerDescriptor>";
        String request1 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&width=20&height=20&x=10&y=10&info";
        String request2 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&query_layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String request3 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers + "&query_layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String invalidRequest1 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String invalidRequest2 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&query_layers=" + this.getLayerId(MockData.TASMANIA_BM) + "&width=20&height=20&x=10&y=10&info";
        String result1 = this.getAsString(request1);
        String result2 = this.getAsString(request2);
        String result3 = this.getAsString(request3);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertEquals((Object)result1, (Object)result3);
        Document invalidResult1 = this.getAsDOM(invalidRequest1);
        Document invalidResult2 = this.getAsDOM(invalidRequest2);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceExceptionReport/ogc:ServiceException)", (Document)invalidResult1);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceExceptionReport/ogc:ServiceException)", (Document)invalidResult2);
    }

    @Test
    public void testLayerQualified() throws Exception {
        String layer = "Forests";
        String q = "?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        String request = "cite/Ponds/wms" + q;
        Document dom = this.getAsDOM(request);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        request = "cite/Forests/wms" + q;
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testXY() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testXYGeo() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=292&height=512&x=147&y=360&srs=epsg:4326";
        String request = url + "&VERSION=1.1.1&BBOX=-3.992187,-4.5,3.992188,9.5";
        String result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("the_geom =") > 0 ? 1 : 0) != 0);
        request = url + "&VERSION=1.3.0&BBOX=-4.5,-3.992187,9.5,3.992188";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("the_geom =") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testXYProj() throws Exception {
        String layer = this.getLayerId(MockData.POLYGONS);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&WIDTH=512&HEIGHT=511&X=136&Y=380&srs=epsg:32615";
        String request = url + "&VERSION=1.1.1&BBOX=499699.999705,499502.050472,501800.000326,501597.949528";
        String result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("polygonProperty =") > 0 ? 1 : 0) != 0);
        request = url + "&VERSION=1.3.0&BBOX=499699.999705,499502.050472,501800.000326,501597.949528";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("polygonProperty =") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testXYCoverage() throws Exception {
        String layer = this.getLayerId(MockData.USA_WORLDIMG);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&WIDTH=512&HEIGHT=408&X=75&Y=132&srs=epsg:4326";
        String request = url + "&VERSION=1.1.1&BBOX=-180,-143.4375,180,143.4375";
        String result = this.getAsString(request);
        Matcher m = Pattern.compile(".*RED_BAND = (\\d+\\.\\d+).*GREEN_BAND = (\\d+\\.\\d+).*BLUE_BAND = (\\d+\\.\\d+).*", 32).matcher(result);
        Assert.assertTrue((boolean)m.matches());
        double red = Double.parseDouble(m.group(1));
        double green = Double.parseDouble(m.group(2));
        double blue = Double.parseDouble(m.group(3));
        request = url + "&VERSION=1.3.0&BBOX=-143.4375,-180,143.4375,180";
        result = this.getAsString(request);
        m = Pattern.compile(".*RED_BAND = (\\d+\\.\\d+).*GREEN_BAND = (\\d+\\.\\d+).*BLUE_BAND = (\\d+\\.\\d+).*", 32).matcher(result);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((double)red, (double)Double.parseDouble(m.group(1)), (double)1.0E-7);
        Assert.assertEquals((double)green, (double)Double.parseDouble(m.group(2)), (double)1.0E-7);
        Assert.assertEquals((double)blue, (double)Double.parseDouble(m.group(3)), (double)1.0E-7);
    }

    @Test
    public void testSampleGrib() throws Exception {
        String layer = this.getLayerId(SAMPLEGRIB);
        String request = "wms?service=WMS&version=1.3.0&request=GetFeatureInfo&styles=&layers=" + layer + "&query_layers=" + layer + "&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&width=300&height=400&i=150&j=100&crs=EPSG:4326&bbox=2,302,10,308";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.095", (String)"substring(//wfs:FeatureCollection/gml:featureMembers/wcs:sampleGrib/wcs:GRAY_INDEX,1,6)", (Document)dom);
    }

    @Test
    public void testSampleGribWest() throws Exception {
        String layer = this.getLayerId(SAMPLEGRIB);
        String request = "wms?service=WMS&version=1.3.0&request=GetFeatureInfo&styles=&layers=" + layer + "&query_layers=" + layer + "&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&width=300&height=400&i=150&j=100&crs=EPSG:4326&bbox=2,-58,10,-52";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.095", (String)"substring(//wfs:FeatureCollection/gml:featureMembers/wcs:sampleGrib/wcs:GRAY_INDEX,1,6)", (Document)dom);
    }

    @Test
    public void testSampleGribWebMercator() throws Exception {
        String layer = this.getLayerId(SAMPLEGRIB);
        String request = "wms?service=WMS&version=1.3.0&request=GetFeatureInfo&styles=&layers=" + layer + "&query_layers=" + layer + "&info_format=" + "application/vnd.ogc.gml/3.1.1" + "&width=300&height=400&i=150&j=100&crs=EPSG:3857&bbox=-6456530.466009867,222684.20850554455,-5788613.521250226,1118889.9748579597";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"-0.095", (String)"substring(//wfs:FeatureCollection/gml:featureMembers/wcs:sampleGrib/wcs:GRAY_INDEX,1,6)", (Document)dom);
    }

    @Test
    public void testGetFeatureInfoOnLineStringsWithGenericGeometry() throws Exception {
        String layer = this.getLayerId(GENERIC_LINES);
        String request = "wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&STYLES=genericLinesStyle&WIDTH=101&HEIGHT=101&BBOX=0.72235107421875,-1.26617431640625,1.27716064453125,-0.71136474609375&SRS=EPSG:4326&FEATURE_COUNT=50&X=50&Y=50&QUERY_LAYERS=" + layer + "&LAYERS=" + layer + "&INFO_FORMAT=text/xml&PROPERTYNAME=name";
        Document result = this.getAsDOM(request, true);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("gs", "http://geoserver.org");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        Assert.assertThat((Object)xpath.evaluate("boolean(//wfs:FeatureCollection/gml:featureMember/gs:genericLines[@fid='line.2'][gs:name='line2'])", result), (org.hamcrest.Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat((Object)xpath.evaluate("boolean(//wfs:FeatureCollection/gml:featureMember/gs:genericLines[@fid='line.3'][gs:name='line3'])", result), (org.hamcrest.Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void testSchemaLeak() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/vnd.ogc.gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        this.getAsDOM(request);
        XSDSchema schema = OGC.getInstance().getSchema();
        int expectedImportCounts = schema.getReferencingDirectives().size();
        this.getAsDOM(request);
        int actualImportCounts = schema.getReferencingDirectives().size();
        Assert.assertEquals((long)expectedImportCounts, (long)actualImportCounts);
    }

    @Test
    public void testRasterKeepNative() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(CUSTOM));
        ci.setProjectionPolicy(ProjectionPolicy.NONE);
        this.getCatalog().save((ResourceInfo)ci);
        String result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.3.0&i=177&j=225");
        Assert.assertTrue((boolean)result.contains("0.0"));
        result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.3.0&i=135&j=223");
        Assert.assertTrue((boolean)result.contains("2.0"));
    }

    @Test
    public void testRasterReprojectToDeclared() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(CUSTOM));
        ci.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        ci.setSRS("EPSG:900913");
        this.getCatalog().save((ResourceInfo)ci);
        String result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.3.0&i=177&j=225");
        Assert.assertTrue((boolean)result.contains("0.0"));
        result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.3.0&i=135&j=223");
        Assert.assertTrue((boolean)result.contains("2.0"));
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithStyles() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&i=10&j=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=Population,Forests";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithCqlFilter() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&i=10&j=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=&cql_filter=PERSONS>25000000;NAME='Green Forest'";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithFilter() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&i=10&j=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=&filter=(%3CFilter%3E%3CPropertyIsGreaterThan%3E%3CPropertyName%3EPERSONS%3C/PropertyName%3E%3CLiteral%3E25000000%3C/Literal%3E%3C/PropertyIsGreaterThan%3E%3C/Filter%3E)(%3CFilter%3E%3CPropertyIsEqualTo%3E%3CPropertyName%3ENAME%3C/PropertyName%3E%3CLiteral%3EGreen%20Forest%3C/Literal%3E%3C/PropertyIsEqualTo%3E%3C/Filter%3E)";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClipParam() throws Exception {
        Polygon geom = JTS.toGeometry((Envelope)new Envelope(0.0, 0.002, 0.0, -0.002));
        String wkt = geom.toText();
        String layer = this.getLayerId(MockData.FORESTS);
        String insideXY = "&x=18&y=18";
        String outsideXY = "&x=5&y=20";
        String clipBorderXY = "&x=10&y=10";
        CoordinateReferenceSystem crs = this.getCatalog().getLayerByName(MockData.FORESTS.getLocalPart()).getResource().getCRS();
        int srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + insideXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        JSONObject responseJson = JSONObject.fromObject((Object)result);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + outsideXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        responseJson = JSONObject.fromObject((Object)result);
        Assert.assertTrue((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + clipBorderXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        responseJson = JSONObject.fromObject((Object)result);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        JSONObject geoJson = responseJson.getJSONArray("features").getJSONObject(0);
        JSONArray coordsArray = geoJson.getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0).getJSONArray(0);
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coordinates = (Coordinate[])Arrays.stream(coordsArray.toArray()).map(new Function<Object, Coordinate>(){

            @Override
            public Coordinate apply(Object t) {
                JSONArray cArray = (JSONArray)t;
                return new Coordinate(cArray.getDouble(0), cArray.getDouble(1));
            }
        }).toArray(Coordinate[]::new);
        Polygon clippedPolygon = gf.createPolygon(coordinates);
        Assert.assertTrue((boolean)clippedPolygon.difference((Geometry)geom).isEmpty());
    }

    @Test
    public void testCoverageClipParam() throws Exception {
        Polygon geom = JTS.toGeometry((Envelope)new Envelope(147.25, 148.0, -43.75, -44.5));
        String wkt = geom.toText();
        String layer = this.getLayerId(TASMANIA_BM);
        String insideXY = "&i=400&j=400";
        String outsideXY = "&i=5&j=5";
        String clipBorderXY = "&i=300&j=300";
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=application/json&query_layers=" + layer + insideXY + "&srs=EPSG:4326&clip=" + wkt;
        String json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        JSONObject responseJson = JSONObject.fromObject((Object)json);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=application/json&query_layers=" + layer + outsideXY + "&srs=EPSG:4326&clip=" + wkt;
        json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        responseJson = JSONObject.fromObject((Object)json);
        Assert.assertTrue((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600&info_format=application/json&query_layers=" + layer + clipBorderXY + "&srs=EPSG:4326&clip=" + wkt;
        json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        responseJson = JSONObject.fromObject((Object)json);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
    }
}

