/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerWorkspaceTest
extends WMSTestSupport {
    private Catalog catalog;

    @Before
    public void setCatalog() throws Exception {
        this.catalog = this.getCatalog();
    }

    LayerInfo layer(Catalog cat, QName name) {
        return cat.getLayerByName(this.getLayerId(name));
    }

    @Test
    public void testLayerOrderGetCapabilities() throws Exception {
        Document doc = this.getAsDOM("/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        List<String> originalList = this.layerNameList(doc);
        Assert.assertFalse((boolean)originalList.isEmpty());
        List names = originalList.stream().map(x -> this.removeLayerPrefix((String)x)).collect(Collectors.toList());
        List orderedNames = names.stream().sorted().collect(Collectors.toList());
        Assert.assertTrue((boolean)orderedNames.equals(names));
    }

    @Test
    public void testWorkspaceLayerOrderGetCapabilities() throws Exception {
        Document doc = this.getAsDOM("/cite/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        List<String> originalList = this.layerNameList(doc);
        Assert.assertFalse((boolean)originalList.isEmpty());
        Assert.assertTrue((boolean)originalList.stream().noneMatch(x -> x.indexOf(":") > -1));
        List orderedNames = originalList.stream().sorted().collect(Collectors.toList());
        Assert.assertTrue((boolean)orderedNames.equals(originalList));
    }

    private String removeLayerPrefix(String prefixedName) {
        if (prefixedName.indexOf(":") > -1) {
            return prefixedName.split(":")[1];
        }
        return prefixedName;
    }

    private List<String> layerNameList(Document doc) throws Exception {
        List<Node> nlist = this.xpathList("//WMT_MS_Capabilities/Capability/Layer/Layer/Name", doc);
        ArrayList<String> result = new ArrayList<String>();
        nlist.forEach(x -> result.add(x.getTextContent().trim()));
        return result;
    }

    private List<Node> xpathList(String xpathString, Document doc) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathString);
        NodeList nlist = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < nlist.getLength(); ++i) {
            nodeList.add(nlist.item(i));
        }
        return nodeList;
    }

    @Test
    public void testGlobalCapabilities() throws Exception {
        LayerInfo layer = this.layer(this.catalog, MockData.PRIMITIVEGEOFEATURE);
        Document doc = this.getAsDOM("/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer.prefixedName() + "']"), (Document)doc);
    }

    @Test
    public void testGlobalDescribeLayer() throws Exception {
        LayerInfo layer = this.layer(this.catalog, MockData.PRIMITIVEGEOFEATURE);
        Document doc = this.getAsDOM("/wms?service=WMS&request=describeLayer&version=1.1.1&LAYERS=" + layer.getName(), true);
        XMLAssert.assertXpathExists((String)("//LayerDescription[@name='" + layer.prefixedName() + "']"), (Document)doc);
    }

    @Test
    public void testWorkspaceCapabilities() throws Exception {
        Document doc = this.getAsDOM("/sf/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "']"), (Document)doc);
    }

    @Test
    public void testWorkspaceDescribeLayer() throws Exception {
        Document doc = this.getAsDOM("/sf/wms?service=WMS&request=describeLayer&version=1.1.1&LAYERS=" + MockData.PRIMITIVEGEOFEATURE.getLocalPart(), true);
        XMLAssert.assertXpathExists((String)("//LayerDescription[@name='" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "']"), (Document)doc);
    }
}

