/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.InputStream;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;

public class GetStylesIntegrationTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        String forests = MockData.FORESTS.getLocalPart();
        String bridges = MockData.BRIDGES.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("lakesGroup");
        lg.getLayers().add(catalog.getLayerByName(lakes));
        lg.getStyles().add(catalog.getStyleByName(lakes));
        lg.getLayers().add(catalog.getLayerByName(forests));
        lg.getStyles().add(catalog.getStyleByName(forests));
        lg.getLayers().add(catalog.getLayerByName(bridges));
        lg.getStyles().add(catalog.getStyleByName(bridges));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
        LayerInfo lakesLayer = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        lakesLayer.getStyles().add(catalog.getStyleByName(MockData.FORESTS.getLocalPart()));
        catalog.save(lakesLayer);
    }

    @Test
    public void testSimple() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&&request=GetStyles&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        Assert.assertEquals((long)1L, (long)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        Assert.assertEquals((Object)this.getLayerId(MockData.BASIC_POLYGONS), (Object)layer.getName());
        Assert.assertEquals((long)1L, (long)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        Assert.assertTrue((boolean)style.isDefault());
        Assert.assertEquals((Object)"BasicPolygons", (Object)style.getName());
    }

    @Test
    public void testGroup() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&request=GetStyles&layers=lakesGroup&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        Assert.assertEquals((long)1L, (long)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        Assert.assertEquals((Object)"lakesGroup", (Object)layer.getName());
        Assert.assertEquals((long)0L, (long)layer.styles().size());
    }

    @Test
    public void testMultiStyle() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&request=GetStyles&layers=" + this.getLayerId(MockData.LAKES) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        Assert.assertEquals((long)1L, (long)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        Assert.assertEquals((Object)this.getLayerId(MockData.LAKES), (Object)layer.getName());
        Assert.assertEquals((long)2L, (long)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        Assert.assertTrue((boolean)style.isDefault());
        Assert.assertEquals((Object)"Lakes", (Object)style.getName());
        style = (Style)layer.styles().get(1);
        Assert.assertFalse((boolean)style.isDefault());
        Assert.assertEquals((Object)"Forests", (Object)style.getName());
    }
}

