/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.Converters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetLegendGraphicTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("paramFill", "paramFill.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("paramStroke", "paramStroke.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("raster", "raster.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("rasterScales", "rasterScales.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("Population", "Population.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("uom", "uomStroke.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("scaleDependent", "scaleDependent.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addVectorLayer(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), Collections.EMPTY_MAP, "states.properties", ((Object)((Object)this)).getClass(), catalog);
        LegendInfoImpl legend = new LegendInfoImpl();
        legend.setWidth(22);
        legend.setHeight(22);
        legend.setFormat("image/png");
        legend.setOnlineResource("legend.png");
        File file = this.getResourceLoader().createFile(new String[]{"styles", "legend.png"});
        this.getResourceLoader().copyFromClassPath("../legend.png", file, ((Object)((Object)this)).getClass());
        testData.addStyle(null, "custom", "point_test.sld", ((Object)((Object)this)).getClass(), catalog, (LegendInfo)legend);
        testData.addStyle(null, "raster_legend", "raster.sld", ((Object)((Object)this)).getClass(), catalog, (LegendInfo)legend);
        WorkspaceInfo defaultWorkspace = catalog.getDefaultWorkspace();
        File wsFile = this.getResourceLoader().createFile(new String[]{"workspaces", defaultWorkspace.getName(), "styles", "legend.png"});
        this.getResourceLoader().copyFromClassPath("../legend.png", wsFile, ((Object)((Object)this)).getClass());
        testData.addStyle(defaultWorkspace, "wsCustom", "point_test.sld", ((Object)((Object)this)).getClass(), catalog, (LegendInfo)legend);
    }

    @Test
    public void testPlain() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=Lakes&format=image/png&width=20&height=20", "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#4040C0", Color.class));
    }

    @Test
    public void testEnv() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=paramFill&format=image/png&width=20&height=20";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#FFFFFF", Color.class));
        image = this.getAsImage(base + "&env=color:#FF0000", "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#FF0000", Color.class));
    }

    @Test
    public void testCustomLegend() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=custom&format=image/png&width=22&height=22";
        BufferedImage image = this.getAsImage(base, "image/png");
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        BufferedImage expected = ImageIO.read(resource.file());
        Assert.assertEquals((long)this.getPixelColor(expected, 10, 2).getRGB(), (long)this.getPixelColor(image, 10, 2).getRGB());
        base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=custom&format=image/png";
        image = this.getAsImage(base, "image/png");
        Assert.assertEquals((String)"width", (long)image.getWidth(), (long)expected.getWidth());
        Assert.assertEquals((String)"height", (long)image.getHeight(), (long)expected.getHeight());
        Color expectedColor = this.getPixelColor(expected, 11, 11);
        Color actualColor = this.getPixelColor(image, 11, 11);
        Assert.assertEquals((String)"red", (long)expectedColor.getRed(), (long)actualColor.getRed());
        Assert.assertEquals((String)"green", (long)expectedColor.getGreen(), (long)actualColor.getGreen());
        Assert.assertEquals((String)"blue", (long)expectedColor.getBlue(), (long)actualColor.getBlue());
        Assert.assertEquals((String)"alpha", (long)expectedColor.getAlpha(), (long)actualColor.getAlpha());
        base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=custom&format=image/png&width=16&height=16";
        image = this.getAsImage(base, "image/png");
        expectedColor = this.getPixelColor(expected, 11, 11);
        actualColor = this.getPixelColor(image, 8, 8);
        Assert.assertEquals((String)"red", (long)expectedColor.getRed(), (long)actualColor.getRed());
        Assert.assertEquals((String)"green", (long)expectedColor.getGreen(), (long)actualColor.getGreen());
        Assert.assertEquals((String)"blue", (long)expectedColor.getBlue(), (long)actualColor.getBlue());
        Assert.assertEquals((String)"alpha", (long)expectedColor.getAlpha(), (long)actualColor.getAlpha());
    }

    @Test
    public void testCustomLegendWsSpecific() throws Exception {
        String wsName = this.getCatalog().getDefaultWorkspace().getName();
        String styleName = wsName + ":wsCustom";
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&format=image/png&width=22&height=22&style=" + styleName;
        BufferedImage image = this.getAsImage(base, "image/png");
        Resource resource = this.getResourceLoader().get("/workspaces/" + wsName + "/styles/legend.png");
        BufferedImage expected = ImageIO.read(resource.file());
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)image, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomLegendOnDefaultStyle() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo statesLayer = catalog.getLayerByName("states");
        StyleInfo statesDefaultStyle = statesLayer.getDefaultStyle();
        StyleInfo customStyle = catalog.getStyleByName("custom");
        StyleInfo wsCustomStyle = catalog.getStyleByName("wsCustom");
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        BufferedImage expected = ImageIO.read(resource.file());
        try {
            statesLayer.setDefaultStyle(customStyle);
            catalog.save(statesLayer);
            BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&format=image/png&width=22&height=22", "image/png");
            ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)image, (int)0);
            statesLayer.setDefaultStyle(wsCustomStyle);
            catalog.save(statesLayer);
            image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&format=image/png&width=22&height=22", "image/png");
            ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)image, (int)0);
        }
        finally {
            statesLayer.setDefaultStyle(statesDefaultStyle);
            catalog.save(statesLayer);
        }
    }

    @Test
    public void testStatesLegend() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.RED);
        this.assertPixel(image, 10, 30, Color.GREEN);
        this.assertPixel(image, 10, 50, Color.BLUE);
    }

    @Test
    public void testStatesLegendDpiRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20&legend_options=dpi:180";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 20, 20, Color.RED);
        this.assertPixel(image, 20, 60, Color.GREEN);
        this.assertPixel(image, 20, 100, Color.BLUE);
        Color linePixel = this.getPixelColor(image, 20, 140);
        Assert.assertTrue((linePixel.getRed() < 10 ? 1 : 0) != 0);
        Assert.assertTrue((linePixel.getGreen() < 10 ? 1 : 0) != 0);
        Assert.assertTrue((linePixel.getBlue() < 10 ? 1 : 0) != 0);
    }

    @Test
    public void testStatesLegendDpiRescaledSingleRule() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20&legend_options=dpi:180&rule=2-4M";
        BufferedImage image = this.getAsImage(base, "image/png");
        Assert.assertEquals((long)40L, (long)image.getWidth());
        Assert.assertEquals((long)40L, (long)image.getHeight());
        this.assertPixel(image, 20, 20, Color.RED);
    }

    @Test
    public void testStatesLegendUomRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=1000000";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.BLUE);
        this.assertPixel(image, 5, 10, Color.WHITE);
        this.assertPixel(image, 1, 10, Color.WHITE);
        base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=500000";
        image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.BLUE);
        this.assertPixel(image, 5, 10, Color.BLUE);
        this.assertPixel(image, 1, 10, Color.WHITE);
    }

    @Test
    public void testStatesLegendDpiUomRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=1000000&&legend_options=dpi:180";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 30, 10, Color.BLUE);
        this.assertPixel(image, 20, 20, Color.BLUE);
        this.assertPixel(image, 10, 30, Color.BLUE);
        this.assertPixel(image, 24, 6, Color.WHITE);
        this.assertPixel(image, 1, 20, Color.WHITE);
    }

    @Test
    public void testEntityExpansionSldBody() throws Exception {
        String base = "wms?LEGEND_OPTIONS=forceLabels:on&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=200&HEIGHT=20&LAYER=" + this.getLayerId(MockData.POLYGONS) + "&SLD_BODY=";
        String sld = IOUtils.toString((URL)TestData.class.getResource("externalEntities.sld"), (String)"UTF-8");
        MockHttpServletResponse response = this.getAsServletResponse(base + URLEncoder.encode(sld, "UTF-8"));
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
    }

    @Test
    public void testNoLegendBelowMinScaleDenominator() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=scaleDependent&format=image/png&width=20&height=20&scale=5000", "image/png");
        Assert.assertEquals((long)1L, (long)image.getHeight());
    }

    @Test
    public void testNoLegendAboveMinScaleDenominator() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=scaleDependent&format=image/png&width=20&height=20&scale=150000", "image/png");
        Assert.assertEquals((long)1L, (long)image.getHeight());
    }

    @Test
    public void testLegendHeight() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20";
        BufferedImage image = this.getAsImage(base, "image/png");
        Assert.assertEquals((long)80L, (long)image.getHeight());
    }

    @Test
    public void testLegendOnRaster() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=wcs:World&style=raster_legend&format=image/png&width=22&height=22";
        BufferedImage image = this.getAsImage(base, "image/png");
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        BufferedImage expected = ImageIO.read(resource.file());
        Assert.assertEquals((long)this.getPixelColor(expected, 10, 2).getRGB(), (long)this.getPixelColor(image, 10, 2).getRGB());
    }

    @Test
    public void testJpegRasterLegend() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=wcs:World&style=raster&format=image/jpeg&width=32&height=32";
        BufferedImage image = this.getAsImage(base, "image/jpeg");
        BufferedImage expected = ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("../rasterLegend.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)image, (int)0);
    }
}

