/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.TextFeatureInfoOutputFormat;
import org.geoserver.wms.wms_1_3.GetMapIntegrationTest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetFeatureInfoTest
extends WMSTestSupport {
    public static String WCS_PREFIX = "wcs";
    public static String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    public static QName TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
    public static QName SQUARES = new QName(MockData.CITE_URI, "squares", MockData.CITE_PREFIX);
    public static QName CUSTOM = new QName(MockData.CITE_URI, "custom", MockData.CITE_PREFIX);
    public static QName POINT_TEST_2D = new QName(MockData.CITE_URI, "point_test_2d", MockData.CITE_PREFIX);
    public static QName POINT_TEST_3D = new QName(MockData.CITE_URI, "point_test_3d", MockData.CITE_PREFIX);
    public static QName STATES = new QName(MockData.SF_URI, "states", MockData.SF_PREFIX);
    protected static QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final String RAIN_RT_STYLE = "filteredRain";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        LayerInfo layer;
        super.onSetUp(testData);
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        this.setupOpaqueGroup(this.getCatalog());
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wmsInfo.setMaxBuffer(50);
        this.getGeoServer().save((ServiceInfo)wmsInfo);
        WFSInfo wfsInfo = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfsInfo.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfsInfo);
        if (RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo wms = cb.buildWMSStore("demo");
            wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
            this.getCatalog().save((StoreInfo)wms);
            cb.setStore((StoreInfo)wms);
            WMSLayerInfo states = cb.buildWMSLayer("topp:states");
            states.setName("rstates");
            this.getCatalog().add((ResourceInfo)states);
            layer = cb.buildLayer(states);
            this.getCatalog().add(layer);
        }
        Catalog catalog = this.getCatalog();
        testData.addStyle("thickStroke", "thickStroke.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("paramStroke", "paramStroke.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("raster", "raster.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("rasterScales", "rasterScales.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("squares", "squares.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("point_test", "point_test.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("scaleBased", "scaleBased.sld", GetFeatureInfoTest.class, catalog);
        testData.addStyle("stacker", "stacker.sld", GetFeatureInfoTest.class, catalog);
        testData.addVectorLayer(SQUARES, Collections.EMPTY_MAP, "squares.properties", GetFeatureInfoTest.class, catalog);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(TASMANIA_BM, "tazbm.tiff", "tiff", propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(CUSTOM, "custom.zip", null, propertyMap, GetFeatureInfoTest.class, catalog);
        testData.addRasterLayer(TIMESERIES, "timeseries.zip", null, null, SystemTestData.class, catalog);
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        HashMap<SystemTestData.LayerProperty, Object> properties = new HashMap<SystemTestData.LayerProperty, Object>();
        properties.put(SystemTestData.LayerProperty.LATLON_ENVELOPE, new ReferencedEnvelope(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.SRS, 4326);
        testData.addVectorLayer(POINT_TEST_2D, properties, "point_test_2d.properties", GetFeatureInfoTest.class, catalog);
        properties = new HashMap();
        properties.put(SystemTestData.LayerProperty.LATLON_ENVELOPE, new ReferencedEnvelope(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope3D(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, 95.1442741322517, 98.1069524121285, CRS.decode((String)"EPSG:4326")));
        properties.put(SystemTestData.LayerProperty.SRS, 4939);
        testData.addVectorLayer(POINT_TEST_3D, properties, "point_test_3d.properties", GetFeatureInfoTest.class, catalog);
        testData.addStyle("Population", "Population.sld", GetFeatureInfoTest.class, catalog);
        testData.addVectorLayer(STATES, Collections.emptyMap(), "states.properties", GetFeatureInfoTest.class, catalog);
        layer = catalog.getLayerByName(this.getLayerId(STATES));
        layer.setQueryable(false);
        catalog.save(layer);
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addStyle(RAIN_RT_STYLE, "filteredRain.sld", GetMapIntegrationTest.class, catalog);
    }

    @Test
    @Ignore
    public void testPoint3d() throws Exception {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.CITE_URI, "point_test_3d");
        ReferencedEnvelope b = info.getLatLonBoundingBox();
        String bbox = b.getMinX() + "," + b.getMinY() + "," + b.getMaxX() + "," + b.getMaxY() + "&srs=EPSG:4326";
        String layer2d = this.getLayerId(POINT_TEST_2D);
        String base2d = "wms?version=1.1.1&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer2d + "&query_layers=" + layer2d + "&styles=point_test&bbox=" + bbox + "&feature_count=10";
        Document dom2d = this.getAsDOM(base2d + "&width=" + 10 + "&height=" + 10 + "&x=" + 5 + "&y=" + 5);
        XMLAssert.assertXpathEvaluatesTo((String)"11", (String)"count(/html/body/table/tr)", (Document)dom2d);
        String layer3d = this.getLayerId(POINT_TEST_3D);
        String base3d = "wms?version=1.1.1&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer3d + "&query_layers=" + layer3d + "&styles=point_test&bbox=" + bbox + "&feature_count=10";
        Document dom3d = this.getAsDOM(base3d + "&width=" + 10 + "&height=" + 10 + "&x=" + 5 + "&y=" + 5);
        XMLAssert.assertXpathEvaluatesTo((String)"11", (String)"count(/html/body/table/tr)", (Document)dom3d);
    }

    @Test
    public void testPointStacker() throws Exception {
        String layerName = this.getLayerId(MockData.BRIDGES);
        String base2d = "wms?version=1.1.1&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layerName + "&query_layers=" + layerName + "&styles=stacker&bbox=-1,-1,1,1&srs=EPSG:4326&feature_count=10";
        Document dom2d = this.getAsDOM(base2d + "&width=" + 100 + "&height=" + 100 + "&x=" + 50 + "&y=" + 50);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/html/body/table/tr)", (Document)dom2d);
    }

    private void testGMLNoData(String contentType) throws Exception {
        String layer = this.getLayerId(MockData.PONDS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=" + contentType + "&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=20&y=20";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gml:featureMember)", (Document)dom);
    }

    @Test
    public void testGMLNoData() throws Exception {
        this.testGMLNoData("application/vnd.ogc.gml");
    }

    @Test
    public void testXMLNoData() throws Exception {
        this.testGMLNoData("text/xml");
    }

    @Test
    public void testXML311NoData() throws Exception {
        this.testGMLNoData("text/xml; subtype=gml/3.1.1");
    }

    @Test
    public void testSimple() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllowedMimeTypes() throws Exception {
        WMSInfo wms = this.getWMS().getServiceInfo();
        TextFeatureInfoOutputFormat format = new TextFeatureInfoOutputFormat(this.getWMS());
        wms.getGetFeatureInfoMimeTypes().add(format.getContentType());
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/vnd.ogc.gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("ForbiddenFormat") > 0 ? 1 : 0) != 0);
        wms.getGetFeatureInfoMimeTypes().clear();
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
        request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/vnd.ogc.gml/3.1.1&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        result = this.getAsString(request);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectPropertiesVector() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&service=wms&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&propertyName=NAME,FID";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        int idxGeom = result.indexOf("the_geom");
        int idxFid = result.indexOf("FID");
        int idxName = result.indexOf("NAME");
        Assert.assertEquals((long)-1L, (long)idxGeom);
        Assert.assertTrue((idxFid > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName < idxFid ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleHtml() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        Document dom = this.getAsDOM(request);
        Assert.assertNotNull((Object)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'Forests.')])", (Document)dom);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
    }

    @Test
    public void testBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.1.1&bbox=-4.5,-2.,4.5,7&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300";
        Document dom = this.getAsDOM(base + "&x=85&y=230");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(base + "&x=85&y=230&buffer=40");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
        dom = this.getAsDOM(base + "&x=85&y=230&buffer=300");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    @Test
    public void testAutoBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.1.1&bbox=-4.5,-2.,4.5,7&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300&x=111&y=229";
        String url = base + "&styles=";
        Document dom = this.getAsDOM(url);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(base + "&styles=thickStroke");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    @Test
    public void testParameterizedStyle() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.1.1&bbox=-4.5,-2.,4.5,7&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300&x=111&y=229&styles=paramStroke";
        Document dom = this.getAsDOM(base);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(base + "&env=thickness:12");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    @Test
    public void testBufferScales() throws Exception {
        String layer = this.getLayerId(SQUARES);
        String base = "wms?version=1.1.1&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=squares&bbox=0,0,10000,10000&feature_count=10&srs=EPSG:32632";
        int w = 357142;
        Document dom = this.getAsDOM(base + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        w = 714285;
        dom = this.getAsDOM(base + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        w = 3571428;
        dom = this.getAsDOM(base + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.2'])", (Document)dom);
    }

    @Test
    public void testTwoLayers() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("<style type=\"text/css\">") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectPropertiesTwoVectorLayers() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&buffer=10&service=wms&feature_count=2&propertyName=(FID)(NAME)";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        int idxGeom = result.indexOf("the_geom");
        int idxLakes = result.indexOf("Lakes");
        int idxFid = result.indexOf("FID");
        int idxName = result.indexOf("NAME");
        Assert.assertEquals((long)-1L, (long)idxGeom);
        Assert.assertTrue((idxFid > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxLakes > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxFid < idxLakes ? 1 : 0) != 0);
        Assert.assertTrue((idxName > idxLakes ? 1 : 0) != 0);
    }

    @Test
    public void testSelectPropertiesTwoVectorLayersOneList() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&buffer=10&service=wms&feature_count=2&propertyName=NAME";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        int idxGeom = result.indexOf("the_geom");
        int idxLakes = result.indexOf("Lakes");
        int idxName1 = result.indexOf("NAME");
        int idxName2 = result.indexOf("NAME", idxLakes);
        Assert.assertEquals((long)-1L, (long)idxGeom);
        Assert.assertTrue((idxName1 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxLakes > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName1 < idxLakes ? 1 : 0) != 0);
        Assert.assertTrue((idxName2 > idxLakes ? 1 : 0) != 0);
    }

    @Test
    public void testTwoLayersFeatureCount() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-0.002356%2C-0.004819%2C0.005631%2C0.004781&SERVICE=WMS&VERSION=1.1.0&X=267&Y=325&INFO_FORMAT=application/vnd.ogc.gml&QUERY_LAYERS=" + layer + "&Layers=" + layer + " &Styles=&WIDTH=426&HEIGHT=512&format=image%2Fpng&srs=EPSG%3A4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Forests)", (Document)dom);
        dom = this.getAsDOM(request + "&FEATURE_COUNT=2");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gml:featureMember)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Forests)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Lakes)", (Document)dom);
    }

    @Test
    public void testUknownFormat() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=unknown/format&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport/ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidFormat", (String)"/ServiceExceptionReport/ServiceException/@code", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"info_format", (String)"/ServiceExceptionReport/ServiceException/@locator", (Document)doc);
    }

    @Test
    public void testCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=text/html&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    @Test
    public void testCoveragePropertySelection() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=text/html&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326&propertyName=RED_BAND";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    @Test
    public void testCoverageGML() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=application/vnd.ogc.gml&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    @Test
    public void testCoverageScales() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=rasterScales&bbox=146.5,-44.5,148,-43&info_format=text/html&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request + "&width=300&height=300");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
        dom = this.getAsDOM(request + "&width=600&height=600");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    @Test
    public void testOutsideCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=raster&bbox=0,-90,148,-43&info_format=text/html&query_layers=" + layer + "&width=300&height=300&x=10&y=150&srs=EPSG:4326";
        Document dom = this.getAsDOM(request + "");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
    }

    @Test
    public void testUnkonwnQueryLayer() throws Exception {
        String layers1 = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.LAKES);
        String layers2 = this.getLayerId(MockData.FORESTS) + "," + this.getLayerId(MockData.BRIDGES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers1 + "&query_layers=" + layers2 + "&width=20&height=20&x=10&y=10&info";
        Document dom = this.getAsDOM(request + "");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ServiceExceptionReport)", (Document)dom);
    }

    @Test
    public void testLayerQualified() throws Exception {
        String layer = "Forests";
        String q = "?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String request = "cite/Ponds/wms" + q;
        Document dom = this.getAsDOM(request);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        request = "cite/Forests/wms" + q;
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupWorkspaceQualified() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=text/plain&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2";
        String result = this.getAsString(url);
        Assert.assertTrue((result.indexOf("Blue Lake") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = this.getAsString("cite/" + url);
        Assert.assertTrue((result.indexOf("Blue Lake") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        Document dom = this.getAsDOM("cdf/" + url);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testNonExactVersion() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.0.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        request = "wms?version=1.1.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRasterFilterRed() throws Exception {
        String response = this.getAsString("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'red%25' + &query_layers=sf:mosaic&x=10&y=10");
        Assert.assertTrue((response.indexOf("RED_BAND = 255.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("GREEN_BAND = 0.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("BLUE_BAND = 0.0") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRasterFilterGreen() throws Exception {
        String response = this.getAsString("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25' + &query_layers=sf:mosaic&x=10&y=10");
        Assert.assertTrue((response.indexOf("RED_BAND = 0.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("GREEN_BAND = 255.0") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("BLUE_BAND = 0.0") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPropertySelectionWmsCascade() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testPropertySelectionWmsCascade");
            return;
        }
        String result = this.getAsString("wms?REQUEST=GetFeatureInfo&BBOX=-132.835937%2C21.132813%2C-64.867187%2C55.117188&SERVICE=WMS&INFO_FORMAT=text/plain&QUERY_LAYERS=rstates&FEATURE_COUNT=50&Layers=rstates&WIDTH=300&HEIGHT=150&format=image%2Fpng&styles=&srs=EPSG%3A4326&version=1.1.1&x=149&y=70&propertyName=STATE_ABBR,STATE_NAME");
        int idxGeom = result.indexOf("the_geom");
        int idxName = result.indexOf("STATE_NAME");
        int idxFips = result.indexOf("STATE_FIPS");
        int idxAbbr = result.indexOf("STATE_ABBR");
        Assert.assertEquals((long)-1L, (long)idxGeom);
        Assert.assertEquals((long)-1L, (long)idxFips);
        Assert.assertTrue((idxAbbr > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxName > 0 ? 1 : 0) != 0);
        Assert.assertTrue((idxAbbr < idxName ? 1 : 0) != 0);
    }

    @Test
    public void testRasterKeepNative() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(CUSTOM));
        ci.setProjectionPolicy(ProjectionPolicy.NONE);
        this.getCatalog().save((ResourceInfo)ci);
        String result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.1.1&x=177&y=225");
        Assert.assertTrue((boolean)result.contains("0.0"));
        result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.1.1&x=135&y=223");
        Assert.assertTrue((boolean)result.contains("2.0"));
    }

    @Test
    public void testRasterReprojectToDeclared() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(CUSTOM));
        ci.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        ci.setSRS("EPSG:900913");
        this.getCatalog().save((ResourceInfo)ci);
        String result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.1.1&x=177&y=225");
        Assert.assertTrue((boolean)result.contains("0.0"));
        result = this.getAsString("wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-887430.34934%2C4467316.30601%2C-885862.361705%2C4468893.535223&SERVICE=WMS&INFO_FORMAT=text%2Fplain&QUERY_LAYERS=cite%3Acustom&FEATURE_COUNT=50&Layers=custom&WIDTH=509&HEIGHT=512&format=image%2Fjpeg&styles=&srs=epsg%3A900913&version=1.1.1&x=135&y=223");
        Assert.assertTrue((boolean)result.contains("2.0"));
    }

    @Test
    public void testGMLWithPostFilter() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo l = cat.getLayerByName(this.getLayerId(MockData.NAMED_PLACES));
        StyleInfo style = l.getDefaultStyle();
        Style s = style.getStyle();
        FeatureTypeStyle fts = (FeatureTypeStyle)s.featureTypeStyles().get(0);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        for (int i = 0; i < 21; ++i) {
            PropertyIsEqualTo f = ff.equals((Expression)ff.literal(1), (Expression)ff.literal(1));
            Rule r = sf.createRule();
            r.setFilter((Filter)f);
            r.symbolizers().add(sf.createPolygonSymbolizer());
            fts.rules().add(r);
        }
        cat.getResourcePool().writeStyle(style, s);
        cat.save(style);
        String layer = this.getLayerId(MockData.NAMED_PLACES);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=0.000004,-0.00285,0.005596,0.00415&width=409&height=512&info_format=application/vnd.ogc.gml&query_layers=" + layer + "&x=194&y=229&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testScaleTolerance() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String getMap = "wms?version=1.1.1&bbox=-10000,20000,10000,40000&srs=EPSG:900913&styles=scaleBased&format=image/png&info_format=text/html&request=GetMap&layers=" + layer + "&query_layers=" + layer + "&width=2041&height=2041";
        BufferedImage image = this.getAsImage(getMap, "image/png");
        this.assertPixel(image, 150, 150, Color.BLUE);
    }

    @Test
    public void testGroupLayerWithNotQueryableLayers() throws Exception {
        Catalog catalog = this.getCatalog();
        CatalogFactory factory = catalog.getFactory();
        WorkspaceInfo workspace = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        String groupLayer = "glqueryable";
        LayerInfo buildingsLayer = catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        buildingsLayer.setQueryable(false);
        catalog.save(buildingsLayer);
        LayerInfo bridgesLayer = catalog.getLayerByName(this.getLayerId(MockData.BRIDGES));
        bridgesLayer.setQueryable(false);
        catalog.save(bridgesLayer);
        LayerInfo forestLayer = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        forestLayer.setQueryable(true);
        catalog.save(forestLayer);
        LayerGroupInfo layerGroup = factory.createLayerGroup();
        layerGroup.setName(groupLayer);
        layerGroup.setWorkspace(workspace);
        layerGroup.getLayers().add(buildingsLayer);
        layerGroup.getLayers().add(bridgesLayer);
        layerGroup.getLayers().add(forestLayer);
        layerGroup.getStyles().add(null);
        layerGroup.getStyles().add(null);
        layerGroup.getStyles().add(null);
        new CatalogBuilder(catalog).calculateLayerGroupBounds(layerGroup);
        catalog.add(layerGroup);
        String name = MockData.CITE_PREFIX + ":" + groupLayer;
        String request = "wms?bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + name + "&query_layers=" + name + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        buildingsLayer.setQueryable(true);
        catalog.save(buildingsLayer);
        bridgesLayer.setQueryable(true);
        catalog.save(bridgesLayer);
        catalog.remove(layerGroup);
    }

    @Test
    public void testNotQueryableGroupLayer() throws Exception {
        Catalog catalog = this.getCatalog();
        CatalogFactory factory = catalog.getFactory();
        WorkspaceInfo workspace = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        String groupLayer = "glnotqueryable";
        LayerGroupInfo layerGroup = factory.createLayerGroup();
        layerGroup.setName(groupLayer);
        layerGroup.setWorkspace(workspace);
        layerGroup.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.FORESTS)));
        layerGroup.getStyles().add(null);
        new CatalogBuilder(catalog).calculateLayerGroupBounds(layerGroup);
        catalog.add(layerGroup);
        String name = MockData.CITE_PREFIX + ":" + groupLayer;
        String request = "wms?bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + name + "&query_layers=" + name + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        layerGroup.setQueryDisabled(true);
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("no layer was queryable") > 0 ? 1 : 0) != 0);
        catalog.remove(layerGroup);
    }

    @Test
    public void testGetFeatureInfoOpaqueGroup() throws Exception {
        String url = "wms?LAYERS=opaqueGroup&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.0043,-0.0025,0.0043,0.0025&info_format=text/plain&request=GetFeatureInfo&&query_layers=opaqueGroup&x=105&y=107";
        String response = this.getAsString(url);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"FID = 102"));
    }

    @Test
    public void testFeatureInfoLayersInOpaqueGroup() throws Exception {
        LayerGroupInfo group = this.getCatalog().getLayerGroupByName("opaqueGroup");
        for (PublishedInfo pi : group.layers()) {
            String layerName = pi.prefixedName();
            String url = "wms?LAYERS=" + layerName + "&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=-0.0043,-0.0025,0.0043,0.0025&info_format=text/plain&request=GetFeatureInfo&&query_layers=" + layerName + "&x=105&y=107";
            Document dom = this.getAsDOM(url);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ServiceExceptionReport)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"layers", (String)"//ServiceException/@locator", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
        }
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithStyles() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&x=10&y=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=Population,Forests";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithCqlFilter() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&x=10&y=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=&cql_filter=PERSONS>25000000;NAME='Green Forest'";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryableAndNonQueryableLayersWithFilter() throws Exception {
        String states = this.getLayerId(STATES);
        String forests = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=20&height=20&x=10&y=10&layers=" + states + "," + forests + "&query_layers=" + states + "," + forests + "&styles=&filter=(%3CFilter%3E%3CPropertyIsGreaterThan%3E%3CPropertyName%3EPERSONS%3C/PropertyName%3E%3CLiteral%3E25000000%3C/Literal%3E%3C/PropertyIsGreaterThan%3E%3C/Filter%3E)(%3CFilter%3E%3CPropertyIsEqualTo%3E%3CPropertyName%3ENAME%3C/PropertyName%3E%3CLiteral%3EGreen%20Forest%3C/Literal%3E%3C/PropertyIsEqualTo%3E%3C/Filter%3E)";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOnNodataValueGetNans() throws Exception {
        String timeseries = this.getLayerId(TIMESERIES);
        String request = "wms?version=1.1.1&BBOX=1,42,2,44&format=jpeg&info_format=text/plain&request=GetFeatureInfo&width=90&height=45&x=35&y=38&layers=" + timeseries + "&query_layers=" + timeseries + "&time=2014-01-01T00:00:00.000Z&FEATURE_COUNT=1";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("-30000") > 0 ? 1 : 0) != 0);
        String request2 = request + "&EXCLUDE_NODATA_RESULT=true";
        result = this.getAsString(request2);
        Assert.assertTrue((result.indexOf("NaN") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClipParam() throws Exception {
        Polygon geom = JTS.toGeometry((Envelope)new Envelope(0.0, 0.002, 0.0, -0.002));
        String wkt = geom.toText();
        String layer = this.getLayerId(MockData.FORESTS);
        CoordinateReferenceSystem crs = this.getCatalog().getLayerByName(MockData.FORESTS.getLocalPart()).getResource().getCRS();
        int srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        String insideXY = "&x=18&y=18";
        String outsideXY = "&x=5&y=20";
        String clipBorderXY = "&x=10&y=10";
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + insideXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        JSONObject responseJson = JSONObject.fromObject((Object)result);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + outsideXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        responseJson = JSONObject.fromObject((Object)result);
        Assert.assertTrue((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=application/json&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20" + clipBorderXY + "&srs=EPSG:" + srid + "&clip=" + wkt;
        result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        responseJson = JSONObject.fromObject((Object)result);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        JSONObject geoJson = responseJson.getJSONArray("features").getJSONObject(0);
        JSONArray coordsArray = geoJson.getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0).getJSONArray(0);
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coordinates = (Coordinate[])Arrays.stream(coordsArray.toArray()).map(new Function<Object, Coordinate>(){

            @Override
            public Coordinate apply(Object t) {
                JSONArray cArray = (JSONArray)t;
                return new Coordinate(cArray.getDouble(0), cArray.getDouble(1));
            }
        }).toArray(Coordinate[]::new);
        Polygon clippedPolygon = gf.createPolygon(coordinates);
        Assert.assertTrue((boolean)clippedPolygon.difference((Geometry)geom).isEmpty());
    }

    @Test
    public void testCoverageClipParam() throws Exception {
        Polygon geom = JTS.toGeometry((Envelope)new Envelope(147.25, 148.0, -43.75, -44.5));
        String wkt = geom.toText();
        String insideXY = "&x=400&y=400";
        String outsideXY = "&x=5&y=5";
        String clipBorderXY = "&x=300&y=300";
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=application/json&query_layers=" + layer + insideXY + "&srs=EPSG:4326&clip=" + wkt;
        String json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        JSONObject responseJson = JSONObject.fromObject((Object)json);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=application/json&query_layers=" + layer + clipBorderXY + "&srs=EPSG:4326&clip=" + wkt;
        json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        responseJson = JSONObject.fromObject((Object)json);
        Assert.assertFalse((boolean)responseJson.getJSONArray("features").isEmpty());
        request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600&info_format=application/json&query_layers=" + layer + outsideXY + "&srs=EPSG:4326&clip=" + wkt;
        json = this.getAsString(request);
        Assert.assertNotNull((Object)json);
        responseJson = JSONObject.fromObject((Object)json);
        Assert.assertTrue((boolean)responseJson.getJSONArray("features").isEmpty());
    }

    @Test
    public void testRasterRenderingTransformation() throws Exception {
        JSONObject jsonUnfiltered = (JSONObject)this.getAsJSON("wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=rain&styles=&bbox=-180,-90,180,90&width=600&height=300&x=20&y=150&info_format=application/json&query_layers=rain&srs=EPSG:4326", 200);
        Assert.assertEquals((double)491.0, (double)jsonUnfiltered.getJSONArray("features").getJSONObject(0).getJSONObject("properties").getDouble("rain"), (double)0.0);
        JSONObject jsonFiltered = (JSONObject)this.getAsJSON("wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=rain&styles=filteredRain&bbox=-180,-90,180,90&width=600&height=300&x=20&y=150&info_format=application/json&query_layers=rain&srs=EPSG:4326");
        this.print((JSON)jsonFiltered);
        Assert.assertEquals((Object)JSONNull.getInstance(), (Object)jsonFiltered.getJSONArray("features").getJSONObject(0).getJSONObject("properties").get("jiffle"));
    }

    protected String getLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }
}

