/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.List;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public class GetFeatureInfoRestrictedTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        ResourceAccessManager mockManager = (ResourceAccessManager)EasyMock.createMock(ResourceAccessManager.class);
        EasyMock.expect((Object)mockManager.getAccessLimits((Authentication)EasyMock.anyObject(), (WorkspaceInfo)EasyMock.anyObject())).andReturn((Object)new WorkspaceAccessLimits(CatalogMode.HIDE, true, false, false)).anyTimes();
        EasyMock.expect((Object)mockManager.getAccessLimits((Authentication)EasyMock.anyObject(), (ResourceInfo)EasyMock.anyObject())).andReturn((Object)new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.INCLUDE, null, (Filter)Filter.EXCLUDE)).anyTimes();
        EasyMock.expect((Object)mockManager.getAccessLimits((Authentication)EasyMock.anyObject(), (LayerInfo)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.INCLUDE, null, (Filter)Filter.EXCLUDE)).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockManager});
        this.getGeoServer().setCatalog((Catalog)new SecureCatalogImpl(this.getGeoServer().getCatalog(), mockManager));
    }

    @Test
    public void testRestrictedReprojection() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?SERVICE=WMS&REQUEST=GetFeatureInfo&EXCEPTIONS=application/vnd.ogc.se_xml&VERSION=1.1.1&BBOX=-0.002,-0.002,0.002,0.002&X=109&Y=204&INFO_FORMAT=text/html&QUERY_LAYERS=" + layer + "&FEATURE_COUNT=50&SRS=EPSG:4326&LAYERS=" + layer + "&STYLES=&WIDTH=256&HEIGHT=256&FORMAT=image/png";
        String result = this.getAsString(request);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.indexOf("ServiceExceptionReport") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }
}

