/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.geoserver.wms.WMSFilterMosaicTestSupport;

public class FilterMosaicGetMapTest
extends WMSFilterMosaicTestSupport {
    static final String layer = WATTEMP.getLocalPart();
    static final String BASE_URL = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + layer + "&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png";
    static final String MIME = "image/png";
    static final String cql_filter = "elevation=100 AND ingestion='2008-10-31T00:00:00.000Z'";

    public void testAsCQL() throws Exception {
        super.setupMosaicFilter(cql_filter, layer);
        BufferedImage image = this.getAsImage(BASE_URL, MIME);
        this.assertPixel(image, 36, 31, new Color(0, 0, 0));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    public void testCaseDefault() throws Exception {
        super.setupMosaicFilter("", layer);
        BufferedImage image = this.getAsImage(BASE_URL, MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 182, 182));
    }

    public void testCaseElev100andIngestion31Oct() throws Exception {
        BufferedImage image = this.getAsImage(BASE_URL + "&cql_filter=elevation=100 AND ingestion='2008-10-31T00:00:00.000Z'", MIME);
        super.setupMosaicFilter(cql_filter, layer);
        this.assertPixel(image, 36, 31, new Color(0, 0, 0));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    public void testCaseElev100andIngestion01Nov() throws Exception {
        BufferedImage image = this.getAsImage(BASE_URL + "&cql_filter=elevation=100 AND ingestion='2008-11-01T00:00:00.000Z'", MIME);
        super.setupMosaicFilter(cql_filter, layer);
        this.assertPixel(image, 36, 31, new Color(0, 0, 0));
        this.assertPixel(image, 68, 72, new Color(246, 246, 255));
    }

    public void testCaseElev0andIngestion31Oct() throws Exception {
        BufferedImage image = this.getAsImage(BASE_URL + "&cql_filter=elevation=0 AND ingestion='2008-10-31T00:00:00.000Z'", MIME);
        super.setupMosaicFilter(cql_filter, layer);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 182, 182));
    }

    public void testCaseElev0andIngestion01Nov() throws Exception {
        BufferedImage image = this.getAsImage(BASE_URL + "&cql_filter=elevation=0 AND ingestion='2008-11-01T00:00:00.000Z'", MIME);
        super.setupMosaicFilter(cql_filter, layer);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 185, 185));
    }
}

