/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.staticRasterStore;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import org.geoserver.wms.staticRasterStore.StaticRasterFormat;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

final class StaticRasterReader
extends AbstractGridCoverage2DReader {
    private static final BufferedImage STATIC_IMAGE = new BufferedImage(1, 1, 2);

    StaticRasterReader(Object source) {
        this.coverageFactory = new GridCoverageFactory();
        this.crs = DefaultGeographicCRS.WGS84;
        this.originalEnvelope = new GeneralEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)this.crs));
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.originalGridRange = new GeneralGridEnvelope((Envelope)this.originalEnvelope, PixelInCell.CELL_CENTER);
        this.setlayout(new ImageLayout((RenderedImage)STATIC_IMAGE));
    }

    public Format getFormat() {
        return new StaticRasterFormat();
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] readParameters) throws IOException {
        return this.coverageFactory.create((CharSequence)coverageName, (RenderedImage)STATIC_IMAGE, (Envelope)this.originalEnvelope);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IOException {
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)STATIC_IMAGE, (Envelope)this.originalEnvelope);
    }

    public String[] getGridCoverageNames() {
        return new String[]{"STATIC_IMAGE"};
    }

    protected boolean checkName(String coverageName) {
        return true;
    }
}

