/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map.png;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetMapIntegrationTest
extends WMSTestSupport {
    String bbox = "-2,0,2,6";
    String layers = this.getLayerId(MockData.BASIC_POLYGONS);

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs11RasterLayers();
    }

    @Test
    public void testPngOpaque() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        ColorModel cm = bi.getColorModel();
        Assert.assertFalse((boolean)cm.hasAlpha());
        Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
    }

    @Test
    public void testPngTransparent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        ColorModel cm = bi.getColorModel();
        Assert.assertTrue((boolean)cm.hasAlpha());
        Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
    }

    @Test
    public void testPng8Opaque() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)1L, (long)cm.getTransparency());
        Assert.assertEquals((long)-1L, (long)cm.getTransparentPixel());
    }

    @Test
    public void testPng8ForceBitmask() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true&format_options=quantizer:octree");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)2L, (long)cm.getTransparency());
        Assert.assertTrue((cm.getTransparentPixel() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPng8Translucent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&transparent=true");
        Assert.assertEquals((Object)"image/png; mode=8bit", (Object)response.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(response);
        BufferedImage bi = ImageIO.read(is);
        IndexColorModel cm = (IndexColorModel)bi.getColorModel();
        Assert.assertEquals((long)3L, (long)cm.getTransparency());
    }
}

