/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RasterSymbolizerVisitorTest;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VectorToRasterTransformTest
extends WMSTestSupport {
    @Test
    public void testVectorToRasterTransformUsesBBox() throws IOException {
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(request);
        ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 45.0, 0.0, 45.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.getViewport().setBounds(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(CiteTestData.STREAMS.getNamespaceURI(), CiteTestData.STREAMS.getLocalPart());
        final SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        final MutableBoolean containsBBox = new MutableBoolean(false);
        DecoratingFeatureSource source = new DecoratingFeatureSource((FeatureSource)featureSource){

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                query.getFilter().accept((FilterVisitor)new NullFilterVisitor(){

                    public Object visit(BBOX filter, Object data) {
                        containsBBox.setValue(true);
                        return data;
                    }
                }, null);
                return featureSource.getFeatures(query);
            }
        };
        Style style = this.parseStyle("HeatmapTransform.sld");
        map.addLayer((Layer)new FeatureLayer((FeatureSource)source, style));
        request.setFormat("image/gif");
        RenderingVariables.setupEnvironmentVariables((WMSMapContent)map);
        RenderedImageMap imageMap = new RenderedImageMapOutputFormat(this.getWMS()).produceMap(map);
        imageMap.dispose();
        Assert.assertTrue((String)"The query filter should have a BBOX", (boolean)containsBBox.booleanValue());
    }

    private Style parseStyle(String styleName) throws IOException {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(RasterSymbolizerVisitorTest.class.getResource(styleName));
        StyledLayerDescriptor sld = parser.parseSLD();
        NamedLayer ul = (NamedLayer)sld.getStyledLayers()[0];
        return ul.getStyles()[0];
    }
}

