/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import java.util.List;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Function;

public class RasterSymbolizerVisitorTest {
    @Test
    public void testRasterRenderingTransformation() throws IOException {
        Style style = this.parseStyle("CropTransform.sld");
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(1000.0, null);
        style.accept((StyleVisitor)visitor);
        List symbolizers = visitor.getRasterSymbolizers();
        Assert.assertEquals((long)1L, (long)symbolizers.size());
        Function tx = (Function)visitor.getRasterRenderingTransformation();
        Assert.assertNotNull((Object)tx);
        Assert.assertEquals((Object)"ras:CropCoverage", (Object)tx.getName());
    }

    @Test
    public void testRasterToVectorTransformation() throws IOException {
        Style style = this.parseStyle("ContourTransform.sld");
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(1000.0, null);
        style.accept((StyleVisitor)visitor);
        List symbolizers = visitor.getRasterSymbolizers();
        Assert.assertEquals((long)0L, (long)symbolizers.size());
        Function tx = (Function)visitor.getRasterRenderingTransformation();
        Assert.assertNull((Object)tx);
    }

    @Test
    public void testVectorToRasterRenderingTransformation() throws IOException {
        Style style = this.parseStyle("HeatmapTransform.sld");
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(1000.0, null);
        style.accept((StyleVisitor)visitor);
        List symbolizers = visitor.getRasterSymbolizers();
        Assert.assertEquals((long)1L, (long)symbolizers.size());
        Function tx = (Function)visitor.getRasterRenderingTransformation();
        Assert.assertNotNull((Object)tx);
        Assert.assertEquals((Object)"vec:Heatmap", (Object)tx.getName());
    }

    private Style parseStyle(String styleName) throws IOException {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(RasterSymbolizerVisitorTest.class.getResource(styleName));
        StyledLayerDescriptor sld = parser.parseSLD();
        NamedLayer ul = (NamedLayer)sld.getStyledLayers()[0];
        return ul.getStyles()[0];
    }
}

