/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.text.PDFTextStripper;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.PDFMapResponse;
import org.geoserver.wms.wms_1_1_1.GetMapIntegrationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class PDFGetMapTest
extends WMSTestSupport {
    String bbox = "-1.5,-0.5,1.5,1.5";
    String layers = this.getLayerId(MockData.BASIC_POLYGONS);
    String buildings = this.getLayerId(MockData.BUILDINGS);
    String requestBase = "wms?bbox=" + this.bbox + "&layers=" + this.layers + "&Format=application/pdf&request=GetMap&width=300&height=300&srs=EPSG:4326";
    static boolean tilingPatterDefault = PDFMapResponse.ENCODE_TILING_PATTERNS;

    @After
    public void setupTilingPatternEncoding() {
        PDFMapResponse.ENCODE_TILING_PATTERNS = tilingPatterDefault;
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        boolean res;
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("burg-fill", "burg-fill.sld", PDFGetMapTest.class, catalog);
        testData.addStyle("triangle-fill", "triangle-fill.sld", PDFGetMapTest.class, catalog);
        testData.addStyle("hatch-fill", "hatch-fill.sld", PDFGetMapTest.class, catalog);
        testData.addStyle("Population", "Population.sld", GetMapIntegrationTest.class, catalog);
        testData.addVectorLayer(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), Collections.emptyMap(), "states.properties", GetMapIntegrationTest.class, catalog);
        File root = testData.getDataDirectoryRoot();
        File layouts = new File(root, "layouts");
        if (!layouts.exists() && !(res = layouts.mkdir())) {
            Assert.fail((String)"could not create layouts directory");
        }
        try (InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("testLayout.xml");){
            testData.copyTo(input, "layouts/test.xml");
        }
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("burg02.svg");){
            testData.copyTo(is, "styles/burg02.svg");
        }
    }

    @Test
    public void testBasicPolygonMap() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(this.requestBase + "&styles=");
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        PDTilingPattern tilingPattern = this.getTilingPattern(response.getContentAsByteArray());
        Assert.assertNull((Object)tilingPattern);
    }

    @Test
    public void testDecoratedMap() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?SERVICE=WMS&VERSION=1.3.0&REQUEST=GetMap&FORMAT=application/pdf&TRANSPARENT=true&LAYERS=sf:states&STYLES=Population&FORMAT_OPTIONS=layout:test;fontAntiAliasing:true&LEGEND_OPTIONS=forceLabels:on;fontAntiAliasing:true&EXCEPTIONS=application/vnd.ogc.se_inimage&CRS=EPSG:4326&WIDTH=1273&HEIGHT=300&BBOX=24.873046875,-151.7431640625,51.240234375,-39.8583984375");
        if (!"application/pdf".equalsIgnoreCase(response.getContentType())) {
            System.err.println(response.getContentAsString());
        }
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        byte[] contents = response.getContentAsByteArray();
        String text = this.getText(contents);
        Assert.assertNotNull((Object)text);
        Assert.assertTrue((boolean)text.contains("500 km"));
    }

    @Test
    public void testSvgFillOptimization() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(this.requestBase + "&styles=burg-fill&featureId=BasicPolygons.1107531493630");
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        PDTilingPattern tilingPattern = this.getTilingPattern(response.getContentAsByteArray());
        Assert.assertNotNull((Object)tilingPattern);
        Assert.assertEquals((double)20.0, (double)tilingPattern.getXStep(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tilingPattern.getYStep(), (double)0.0);
    }

    @Test
    public void testSvgFillOptimizationDisabled() throws Exception {
        PDFMapResponse.ENCODE_TILING_PATTERNS = false;
        MockHttpServletResponse response = this.getAsServletResponse(this.requestBase + "&styles=burg-fill&featureId=BasicPolygons.1107531493630");
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        PDTilingPattern tilingPattern = this.getTilingPattern(response.getContentAsByteArray());
        Assert.assertNull((Object)tilingPattern);
    }

    @Test
    public void testTriangleFillOptimization() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(this.requestBase + "&styles=triangle-fill&featureId=BasicPolygons.1107531493630");
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        File file = new File("./target/test.pdf");
        FileUtils.writeByteArrayToFile((File)file, (byte[])response.getContentAsByteArray());
        PDTilingPattern tilingPattern = this.getTilingPattern(response.getContentAsByteArray());
        Assert.assertNotNull((Object)tilingPattern);
        Assert.assertEquals((double)20.0, (double)tilingPattern.getXStep(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tilingPattern.getYStep(), (double)0.0);
    }

    @Test
    public void testHatchFillOptimization() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(this.requestBase + "&styles=hatch-fill&featureId=BasicPolygons.1107531493630");
        Assert.assertEquals((Object)"application/pdf", (Object)response.getContentType());
        PDTilingPattern tilingPattern = this.getTilingPattern(response.getContentAsByteArray());
        Assert.assertNull((Object)tilingPattern);
    }

    String getText(byte[] pdfDocument) throws InvalidPasswordException, IOException {
        PDDocument doc = PDDocument.load((byte[])pdfDocument);
        StringWriter writer = new StringWriter();
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.writeText(doc, (Writer)writer);
        String contents = writer.getBuffer().toString();
        return contents;
    }

    PDTilingPattern getTilingPattern(byte[] pdfDocument) throws InvalidPasswordException, IOException {
        PDDocument doc = PDDocument.load((byte[])pdfDocument);
        PDPage page = doc.getPage(0);
        final AtomicReference pattern = new AtomicReference();
        PDFGraphicsStreamEngine engine = new PDFGraphicsStreamEngine(page){

            public void strokePath() throws IOException {
            }

            public void shadingFill(COSName shadingName) throws IOException {
            }

            public void moveTo(float x, float y) throws IOException {
            }

            public void lineTo(float x, float y) throws IOException {
            }

            public Point2D getCurrentPoint() throws IOException {
                return null;
            }

            public void fillPath(int windingRule) throws IOException {
            }

            public void fillAndStrokePath(int windingRule) throws IOException {
            }

            public void endPath() throws IOException {
            }

            public void drawImage(PDImage pdImage) throws IOException {
            }

            public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
            }

            public void closePath() throws IOException {
            }

            public void clip(int windingRule) throws IOException {
            }

            public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
            }
        };
        engine.addOperator((OperatorProcessor)new SetNonStrokingColorN(){

            public void process(Operator operator, List<COSBase> arguments) throws IOException {
                PDPattern colorSpace;
                PDAbstractPattern ap;
                super.process(operator, arguments);
                PDColor color = this.context.getGraphicsState().getNonStrokingColor();
                if (this.context.getGraphicsState().getNonStrokingColorSpace() instanceof PDPattern && (ap = (colorSpace = (PDPattern)this.context.getGraphicsState().getNonStrokingColorSpace()).getPattern(color)) instanceof PDTilingPattern) {
                    pattern.set((PDTilingPattern)ap);
                }
            }
        });
        engine.processPage(page);
        return (PDTilingPattern)pattern.get();
    }
}

