/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.template.TemplateUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.OpenLayersMapOutputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenLayersMapTemplateTest
extends WMSTestSupport {
    @Test
    public void test() throws Exception {
        Configuration cfg = TemplateUtils.getSafeConfiguration();
        cfg.setClassForTemplateLoading(OpenLayersMapOutputFormat.class, "");
        cfg.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        Template template = cfg.getTemplate("OpenLayers2MapTemplate.ftl");
        Assert.assertNotNull((Object)template);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        WMSMapContent mapContent = new WMSMapContent();
        mapContent.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        mapContent.setRequest(request);
        mapContent.setMapWidth(256);
        mapContent.setMapHeight(256);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", mapContent);
        map.put("request", mapContent.getRequest());
        map.put("maxResolution", 5.0E-4);
        map.put("baseUrl", "http://localhost:8080/geoserver/wms");
        map.put("relBaseUrl", "//localhost:8080/geoserver/wms");
        map.put("parameters", new ArrayList());
        map.put("layerName", "layer");
        map.put("units", "degrees");
        map.put("pureCoverage", "false");
        map.put("supportsFiltering", "true");
        map.put("styles", new ArrayList());
        map.put("servicePath", "wms");
        map.put("yx", "false");
        template.process(map, (Writer)new OutputStreamWriter(output));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        });
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"html", (Object)document.getDocumentElement().getNodeName());
    }
}

