/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderIterator;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class MockHttpClientConnectionManager
implements HttpClientConnectionManager {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private String response;
    private boolean enableCache;
    private int connections = 0;

    public MockHttpClientConnectionManager(String response, boolean enableCache) {
        this.response = response;
        this.enableCache = enableCache;
    }

    public void closeExpiredConnections() {
    }

    public void closeIdleConnections(long arg0, TimeUnit arg1) {
    }

    public void connect(HttpClientConnection arg0, HttpRoute arg1, int arg2, HttpContext arg3) throws IOException {
    }

    public void releaseConnection(HttpClientConnection arg0, Object arg1, long arg2, TimeUnit arg3) {
    }

    public int getConnections() {
        return this.connections;
    }

    public ConnectionRequest requestConnection(HttpRoute arg0, Object arg1) {
        return new ConnectionRequest(){

            public boolean cancel() {
                return false;
            }

            public HttpClientConnection get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                MockHttpClientConnectionManager.this.connections++;
                return new HttpClientConnection(){

                    public void shutdown() throws IOException {
                    }

                    public void setSocketTimeout(int arg0) {
                    }

                    public boolean isStale() {
                        return false;
                    }

                    public boolean isOpen() {
                        return true;
                    }

                    public int getSocketTimeout() {
                        return 0;
                    }

                    public HttpConnectionMetrics getMetrics() {
                        return null;
                    }

                    public void close() throws IOException {
                    }

                    public void sendRequestHeader(HttpRequest arg0) throws HttpException, IOException {
                    }

                    public void sendRequestEntity(HttpEntityEnclosingRequest arg0) throws HttpException, IOException {
                    }

                    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
                        return new HttpResponse(){
                            List<Header> headers = new ArrayList<Header>();

                            public void addHeader(Header arg0) {
                            }

                            public void addHeader(String arg0, String arg1) {
                            }

                            public boolean containsHeader(String arg0) {
                                return false;
                            }

                            public Header[] getAllHeaders() {
                                return this.headers.toArray(new Header[0]);
                            }

                            public Header getHeader(String header) {
                                if ("transfer-encoding".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, "identity");
                                }
                                if ("date".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, dateFormat.format(new GregorianCalendar().getTime()));
                                }
                                if ("cache-control".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, MockHttpClientConnectionManager.this.enableCache ? "public" : "no-cache");
                                }
                                if ("content-length".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, MockHttpClientConnectionManager.this.response.length() + "");
                                }
                                if ("content-encoding".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, "identity");
                                }
                                if ("age".equalsIgnoreCase(header)) {
                                    return new BasicHeader(header, "0");
                                }
                                if ("expires".equalsIgnoreCase(header) && MockHttpClientConnectionManager.this.enableCache) {
                                    GregorianCalendar expires = new GregorianCalendar();
                                    expires.add(12, 30);
                                    return new BasicHeader(header, dateFormat.format(expires.getTime()));
                                }
                                return new BasicHeader(header, "");
                            }

                            public Header getFirstHeader(String header) {
                                Header value = this.getHeader(header);
                                this.headers.add(value);
                                return value;
                            }

                            public Header[] getHeaders(String header) {
                                return new Header[]{this.getFirstHeader(header)};
                            }

                            public Header getLastHeader(String header) {
                                return new BasicHeader(header, "");
                            }

                            public HttpParams getParams() {
                                return null;
                            }

                            public ProtocolVersion getProtocolVersion() {
                                return HttpVersion.HTTP_1_1;
                            }

                            public HeaderIterator headerIterator() {
                                return new BasicHeaderIterator(this.headers.toArray(new Header[0]), "mock");
                            }

                            public HeaderIterator headerIterator(String header) {
                                return new BasicHeaderIterator(this.headers.toArray(new Header[0]), "mock");
                            }

                            public void removeHeader(Header arg0) {
                            }

                            public void removeHeaders(String arg0) {
                            }

                            public void setHeader(Header arg0) {
                            }

                            public void setHeader(String arg0, String arg1) {
                            }

                            public void setHeaders(Header[] arg0) {
                            }

                            public void setParams(HttpParams arg0) {
                            }

                            public HttpEntity getEntity() {
                                BasicHttpEntity entity = new BasicHttpEntity();
                                entity.setContentLength((long)MockHttpClientConnectionManager.this.response.length());
                                entity.setContent((InputStream)new ByteArrayInputStream(MockHttpClientConnectionManager.this.response.getBytes(StandardCharsets.UTF_8)));
                                return entity;
                            }

                            public Locale getLocale() {
                                return Locale.ENGLISH;
                            }

                            public StatusLine getStatusLine() {
                                return new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
                            }

                            public void setEntity(HttpEntity arg0) {
                            }

                            public void setLocale(Locale arg0) {
                            }

                            public void setReasonPhrase(String arg0) throws IllegalStateException {
                            }

                            public void setStatusCode(int arg0) throws IllegalStateException {
                            }

                            public void setStatusLine(StatusLine arg0) {
                            }

                            public void setStatusLine(ProtocolVersion arg0, int arg1) {
                            }

                            public void setStatusLine(ProtocolVersion arg0, int arg1, String arg2) {
                            }
                        };
                    }

                    public void receiveResponseEntity(HttpResponse arg0) throws HttpException, IOException {
                    }

                    public boolean isResponseAvailable(int arg0) throws IOException {
                        return true;
                    }

                    public void flush() throws IOException {
                    }
                };
            }
        };
    }

    public void routeComplete(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
    }

    public void shutdown() {
    }

    public void upgrade(HttpClientConnection arg0, HttpRoute arg1, HttpContext arg2) throws IOException {
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

