/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import junit.framework.Test;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.map.GetMapXmlReader;
import org.geotools.styling.Style;
import org.opengis.filter.PropertyIsEqualTo;

public class GetMapXmlReaderTest
extends KvpRequestReaderTestSupport {
    GetMapXmlReader reader;
    Dispatcher dispatcher;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapXmlReaderTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
    }

    protected void oneTimeTearDown() throws Exception {
        super.oneTimeTearDown();
        GeoServerLoader.setLegacy((boolean)false);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        WMS wms = new WMS(this.getGeoServer());
        this.reader = new GetMapXmlReader(wms);
    }

    public void testCreateRequest() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        GetMapXmlReaderTest.assertNotNull((Object)request);
    }

    public void testResolveStylesForLayerGroup() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        BufferedReader input = this.getResourceInputStream("WMSPostLayerGroupNonDefaultStyle.xml");
        request = (GetMapRequest)this.reader.read((Object)request, (Reader)input, new HashMap());
        String layer = MockData.BASIC_POLYGONS.getLocalPart();
        GetMapXmlReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapXmlReaderTest.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
        GetMapXmlReaderTest.assertEquals((int)1, (int)request.getStyles().size());
        Style expected = this.getCatalog().getStyleByName("polygon").getStyle();
        Style style = (Style)request.getStyles().get(0);
        GetMapXmlReaderTest.assertEquals((Object)expected, (Object)style);
    }

    public void testLayerFeatureConstraintFilterParsing() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        BufferedReader input = this.getResourceInputStream("WMSPostLayerFeatureConstraintFilter.xml");
        request = (GetMapRequest)this.reader.read((Object)request, (Reader)input, new HashMap());
        String linesLayer = MockData.LINES.getLocalPart();
        GetMapXmlReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapXmlReaderTest.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(linesLayer));
        GetMapXmlReaderTest.assertEquals((int)1, (int)request.getFilter().size());
        PropertyIsEqualTo parsed = (PropertyIsEqualTo)request.getFilter().get(0);
        GetMapXmlReaderTest.assertEquals((String)"[ NAME = VALUE ]", (String)parsed.toString());
    }

    public void testAllowDynamicStyles() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        BufferedReader input = this.getResourceInputStream("WMSPostLayerGroupNonDefaultStyle.xml");
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        GetMapXmlReader reader = new GetMapXmlReader(wms);
        boolean error = false;
        try {
            request = (GetMapRequest)reader.read((Object)request, (Reader)input, new HashMap());
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        GetMapXmlReaderTest.assertTrue((boolean)error);
    }

    private BufferedReader getResourceInputStream(String classRelativePath) throws IOException {
        InputStream resourceStream = ((Object)((Object)this)).getClass().getResource(classRelativePath).openStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(resourceStream));
        return input;
    }
}

