/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.legendgraphic.GetLegendGraphicKvpReader;
import org.geotools.feature.NameImpl;
import org.geotools.styling.Style;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.springframework.mock.web.MockHttpServletRequest;

public class GetLegendGraphicKvpReaderTest
extends WMSTestSupport {
    GetLegendGraphicKvpReader requestReader;
    Map<String, String> requiredParameters;
    Map<String, String> optionalParameters;
    Map<String, String> allParameters;
    MockHttpServletRequest httpRequest;
    WMS wms;

    @Before
    public void setParameters() throws Exception {
        this.requiredParameters = new HashMap<String, String>();
        this.requiredParameters.put("VERSION", "1.0.0");
        this.requiredParameters.put("REQUEST", "GetLegendGraphic");
        this.requiredParameters.put("LAYER", "cite:Ponds");
        this.requiredParameters.put("FORMAT", "image/png");
        this.optionalParameters = new HashMap<String, String>();
        this.optionalParameters.put("STYLE", "Ponds");
        this.optionalParameters.put("FEATURETYPE", "fake_not_used");
        this.optionalParameters.put("SCALE", "1000");
        this.optionalParameters.put("WIDTH", "120");
        this.optionalParameters.put("HEIGHT", "90");
        this.optionalParameters.put("LANGUAGE", "en");
        this.allParameters = new HashMap<String, String>(this.requiredParameters);
        this.allParameters.putAll(this.optionalParameters);
        this.wms = this.getWMS();
        this.requestReader = new GetLegendGraphicKvpReader(this.wms);
        this.httpRequest = this.createRequest("wms", this.allParameters);
    }

    @Test
    public void testRemoteSLDMultipleStyles() throws Exception {
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        this.allParameters.put("STYLE", "Ponds");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Style selectedStyle = ((GetLegendGraphicRequest.LegendRequest)request.getLegends().get(0)).getStyle();
        Assert.assertNotNull((Object)selectedStyle);
        Assert.assertEquals((Object)"Ponds", (Object)selectedStyle.getName());
        this.allParameters.put("LAYER", "cite:Lakes");
        this.allParameters.put("STYLE", "Lakes");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        selectedStyle = ((GetLegendGraphicRequest.LegendRequest)request.getLegends().get(0)).getStyle();
        Assert.assertNotNull((Object)selectedStyle);
        Assert.assertEquals((Object)"Lakes", (Object)selectedStyle.getName());
    }

    @Test
    public void testMissingLayerParameter() throws Exception {
        this.requiredParameters.remove("LAYER");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"LayerNotDefined", (Object)e.getCode());
        }
    }

    @Test
    public void testMissingFormatParameter() throws Exception {
        this.requiredParameters.remove("FORMAT");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"MissingFormat", (Object)e.getCode());
        }
    }

    @Test
    public void testStrictParameter() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertTrue((boolean)request.isStrict());
        this.allParameters.put("STRICT", "false");
        this.allParameters.remove("LAYER");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertFalse((boolean)request.isStrict());
    }

    @Test
    public void testLayerGroup() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertTrue((request.getLegends().size() == 1 ? 1 : 0) != 0);
        this.requiredParameters.put("LAYER", "nature");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertTrue((request.getLegends().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLanguage() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertNull((Object)request.getLocale());
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)request.getLocale());
    }

    @Test
    public void testStylesForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        this.requiredParameters.put("STYLE", "style1,style2");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertTrue((request.getLegends().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRulesForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        this.requiredParameters.put("RULE", "rule1,rule2");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertTrue((request.getLegends().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testLabelsForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertNotNull((Object)request.getLegend((Name)new NameImpl("http://www.opengis.net/cite", "Lakes")).getTitle());
    }
}

