/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.georss.AtomGeoRSSTransformer;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geotools.data.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomGeoRSSTransformerTest
extends WMSTestSupport {
    static WMSMapContent map;

    @Before
    public void initializeMap() throws Exception {
        map = new WMSMapContent(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
    }

    @Test
    public void testLatLongInternal() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer(this.getWMS());
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"feed", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("geo:long").getLength());
        }
    }

    @Test
    public void testLatLongWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:latlong&format=application/atom+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"feed", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("geo:long").getLength());
        }
    }

    @Test
    public void testSimpleInternal() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer(this.getWMS());
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"feed", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:where").getLength());
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:polygon").getLength());
        }
    }

    @Test
    public void testSimpleWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:simple&format=application/atom+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"feed", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:where").getLength());
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:polygon").getLength());
        }
    }

    @Test
    public void testGmlWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:gml&format=application/atom+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"feed", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:where").getLength());
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("gml:Polygon").getLength());
        }
    }
}

