/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.describelayer.JSONDescribeLayerResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class DescribeLayerJsonTest
extends WMSTestSupport {
    @Test
    public void testBuild() throws Exception {
        try {
            new JSONDescribeLayerResponse(this.getWMS(), "fail");
            Assert.fail((String)"Should fails");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCustomJSONP() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.1.1&request=DescribeLayer&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&outputFormat=" + "text/javascript" + "&format_options=" + "callback" + ":DescribeLayer";
        JSONType.setJsonpEnabled((boolean)true);
        String result = this.getAsString(request);
        JSONType.setJsonpEnabled((boolean)false);
        this.checkJSONPDescribeLayer(result, layer);
    }

    @Test
    public void testSimpleJSON() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.1.1&request=DescribeLayer&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&outputFormat=" + "application/json";
        String result = this.getAsString(request);
        this.checkJSONDescribeLayer(result, layer);
    }

    private void checkJSONPDescribeLayer(String body, String layer) {
        Assert.assertNotNull((Object)body);
        Assert.assertTrue((boolean)body.startsWith("DescribeLayer("));
        Assert.assertTrue((boolean)body.endsWith(")\n"));
        body = body.substring(0, body.length() - 2);
        body = body.substring("DescribeLayer(".length(), body.length());
        this.checkJSONDescribeLayer(body, layer);
    }

    @Test
    public void testJSONLayerGroup() throws Exception {
        String layer = "nature";
        String request = "wms?version=1.1.1&request=DescribeLayer&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&outputFormat=" + "application/json";
        String result = this.getAsString(request);
        this.checkJSONDescribeLayerGroup(result, layer);
    }

    private void checkJSONDescribeLayer(String body, String layer) {
        Assert.assertNotNull((Object)body);
        JSONObject rootObject = JSONObject.fromObject((Object)body);
        JSONArray layerDescs = rootObject.getJSONArray("layerDescriptions");
        JSONObject layerDesc = layerDescs.getJSONObject(0);
        Assert.assertEquals((Object)layerDesc.get("layerName"), (Object)layer);
        Assert.assertEquals((Object)layerDesc.get("owsType"), (Object)"WFS");
    }

    private void checkJSONDescribeLayerGroup(String body, String layer) {
        Assert.assertNotNull((Object)body);
        JSONObject rootObject = JSONObject.fromObject((Object)body);
        JSONArray layerDescs = rootObject.getJSONArray("layerDescriptions");
        JSONObject layerDesc = layerDescs.getJSONObject(0);
        Assert.assertEquals((Object)layerDesc.get("layerName"), (Object)(MockData.LAKES.getPrefix() + ":" + MockData.LAKES.getLocalPart()));
        Assert.assertTrue((boolean)layerDesc.get("owsURL").toString().endsWith("geoserver/wfs?"));
        Assert.assertEquals((Object)layerDesc.get("owsType"), (Object)"WFS");
        layerDesc = layerDescs.getJSONObject(1);
        Assert.assertEquals((Object)layerDesc.get("layerName"), (Object)(MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart()));
        Assert.assertTrue((boolean)layerDesc.get("owsURL").toString().endsWith("geoserver/wfs?"));
        Assert.assertEquals((Object)layerDesc.get("owsType"), (Object)"WFS");
    }

    @Test
    public void testJSONDescribeLayerCharset() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.1.1&request=DescribeLayer&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&outputFormat=" + "application/json";
        MockHttpServletResponse result = this.getAsServletResponse(request, "");
        Assert.assertTrue((boolean)"UTF-8".equals(result.getCharacterEncoding()));
    }
}

