/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.Capabilities_1_3_0_Transformer;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.geotools.xml.transform.TransformerBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public class GetCapabilitiesTransformerTest
extends WMSTestSupport {
    private XpathEngine XPATH;
    private static final String baseUrl = "http://localhost/geoserver";
    private static final Set<String> mapFormats = Collections.singleton("image/png");
    private static final Set<String> legendFormats = Collections.singleton("image/png");
    private GeoServerImpl geosConfig;
    private GeoServerInfoImpl geosInfo;
    private WMSInfoImpl wmsInfo;
    private CatalogImpl catalog;
    private GetCapabilitiesRequest req;
    private WMS wmsConfig;

    @Before
    public void setUp() throws Exception {
        this.geosConfig = new GeoServerImpl();
        this.geosInfo = new GeoServerInfoImpl((GeoServer)this.geosConfig);
        this.geosInfo.setContact((ContactInfo)new ContactInfoImpl());
        this.geosConfig.setGlobal((GeoServerInfo)this.geosInfo);
        this.wmsInfo = new WMSInfoImpl();
        this.geosConfig.add((ServiceInfo)this.wmsInfo);
        this.catalog = new CatalogImpl();
        this.geosConfig.setCatalog((Catalog)this.catalog);
        this.wmsConfig = new WMS((GeoServer)this.geosConfig);
        this.req = new GetCapabilitiesRequest();
        this.req.setBaseUrl(baseUrl);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.XPATH = XMLUnit.newXpathEngine();
    }

    @Test
    public void testHeader() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        StringWriter writer = new StringWriter();
        tr.transform((Object)this.req, (Writer)writer);
        String content = writer.getBuffer().toString();
        Assert.assertTrue((boolean)content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        String dtdDef = "<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://localhost/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">";
        Assert.assertTrue((boolean)content.contains(dtdDef));
    }

    @Test
    public void testRootElement() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)root.getNodeName());
        Assert.assertEquals((Object)"1.1.1", (Object)root.getAttribute("version"));
        Assert.assertEquals((Object)"0", (Object)root.getAttribute("updateSequence"));
        this.geosInfo.setUpdateSequence(10L);
        tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        root = dom.getDocumentElement();
        Assert.assertEquals((Object)"10", (Object)root.getAttribute("updateSequence"));
    }

    @Test
    public void testServiceSection() throws Exception {
        this.wmsInfo.setTitle("title");
        this.wmsInfo.setAbstract("abstract");
        this.wmsInfo.getKeywords().add(new Keyword("k1"));
        this.wmsInfo.getKeywords().add(new Keyword("k2"));
        this.wmsInfo.setOnlineResource("http://onlineresource/fake");
        ContactInfoImpl contactInfo = new ContactInfoImpl();
        this.geosInfo.setContact((ContactInfo)contactInfo);
        contactInfo.setContactPerson("contactPerson");
        contactInfo.setContactOrganization("contactOrganization");
        contactInfo.setContactPosition("contactPosition");
        contactInfo.setAddress("address");
        contactInfo.setAddressType("addressType");
        contactInfo.setAddressCity("city");
        contactInfo.setAddressState("state");
        contactInfo.setAddressPostalCode("postCode");
        contactInfo.setAddressCountry("country");
        contactInfo.setContactVoice("voice");
        contactInfo.setContactEmail("email");
        contactInfo.setContactFacsimile("fax");
        this.wmsInfo.setFees("fees");
        this.wmsInfo.setAccessConstraints("accessConstraints");
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        String service = "/WMT_MS_Capabilities/Service";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(service + "/Name"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"title", (String)(service + "/Title"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract", (String)(service + "/Abstract"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k1", (String)(service + "/KeywordList/Keyword[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k2", (String)(service + "/KeywordList/Keyword[2]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)this.wmsInfo.getOnlineResource(), (String)(service + "/OnlineResource/@xlink:href"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPerson", (String)(service + "/ContactInformation/ContactPersonPrimary/ContactPerson"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactOrganization", (String)(service + "/ContactInformation/ContactPersonPrimary/ContactOrganization"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPosition", (String)(service + "/ContactInformation/ContactPosition"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"address", (String)(service + "/ContactInformation/ContactAddress/Address"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"addressType", (String)(service + "/ContactInformation/ContactAddress/AddressType"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"city", (String)(service + "/ContactInformation/ContactAddress/City"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"state", (String)(service + "/ContactInformation/ContactAddress/StateOrProvince"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"postCode", (String)(service + "/ContactInformation/ContactAddress/PostCode"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"country", (String)(service + "/ContactInformation/ContactAddress/Country"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"voice", (String)(service + "/ContactInformation/ContactVoiceTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fax", (String)(service + "/ContactInformation/ContactFacsimileTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"email", (String)(service + "/ContactInformation/ContactElectronicMailAddress"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fees", (String)(service + "/Fees"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"accessConstraints", (String)(service + "/AccessConstraints"), (Document)dom);
    }

    @Test
    public void testCRSList() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        supportedCodes.addAll(CRS.getSupportedCodes((String)"AUTO"));
        NodeList allCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        Assert.assertEquals((long)(supportedCodes.size() - 1), (long)allCrsCodes.getLength());
    }

    @Test
    public void testLimitedCRSList() throws Exception {
        this.wmsInfo.getSRS().add("EPSG:3246");
        this.wmsInfo.getSRS().add("EPSG:23030");
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        NodeList limitedCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        Assert.assertEquals((long)2L, (long)limitedCrsCodes.getLength());
    }

    @Test
    public void testVendorSpecificCapabilities() throws Exception {
        TestExtendedCapabilitiesProvider vendorCapsProvider = new TestExtendedCapabilitiesProvider();
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, Collections.singletonList(vendorCapsProvider));
        tr.setIndentation(2);
        this.checkVendorSpecificCapsProviders(tr);
    }

    @Test
    public void testVendorSpecificCapabilitiesWithEmptyProvider() throws Exception {
        EmptyExtendedCapabilitiesProvider emptyCapsProvider = new EmptyExtendedCapabilitiesProvider();
        TestExtendedCapabilitiesProvider vendorCapsProvider = new TestExtendedCapabilitiesProvider();
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, Arrays.asList(emptyCapsProvider, vendorCapsProvider));
        tr.setIndentation(2);
        this.checkVendorSpecificCapsProviders(tr);
    }

    private void checkVendorSpecificCapsProviders(GetCapabilitiesTransformer tr) throws Exception {
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/WMT_MS_Capabilities/Capability/Layer/SRS)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/WMT_MS_Capabilities/Capability/Layer[SRS='EPSG:4326'])", (Document)dom);
        NodeList list = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TestElement", dom);
        Assert.assertEquals((long)1L, (long)list.getLength());
        list = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TestElement/TestSubElement", dom);
        Assert.assertEquals((long)1L, (long)list.getLength());
    }

    @Test
    public void testLayerStyleSections() throws Exception {
        String LAYER_GROUP_NAME = "testLayerGroup";
        StyleInfo styleInfo = this.catalog.getFactory().createStyle();
        styleInfo.setName("testStyle");
        styleInfo.setFilename("testStyle.sld");
        this.catalog.add(styleInfo);
        NamespaceInfo namespaceInfo = this.catalog.getFactory().createNamespace();
        namespaceInfo.setURI("http://test");
        namespaceInfo.setPrefix("test");
        this.catalog.add(namespaceInfo);
        WorkspaceInfo workspaceInfo = this.catalog.getFactory().createWorkspace();
        workspaceInfo.setName("testDatastore");
        this.catalog.add(workspaceInfo);
        WMSStoreInfo wmsStoreInfo = this.catalog.getFactory().createWebMapServer();
        wmsStoreInfo.setName("testDatastore");
        wmsStoreInfo.setWorkspace(workspaceInfo);
        this.catalog.add((StoreInfo)wmsStoreInfo);
        WMSLayerInfo wmsLayerInfo = this.catalog.getFactory().createWMSLayer();
        wmsLayerInfo.setName("testDatastore:testLayer");
        wmsLayerInfo.setStore((StoreInfo)wmsStoreInfo);
        wmsLayerInfo.setNamespace(namespaceInfo);
        this.catalog.add((ResourceInfo)wmsLayerInfo);
        LayerInfo layerInfo = this.catalog.getFactory().createLayer();
        layerInfo.setDefaultStyle(styleInfo);
        layerInfo.setResource((ResourceInfo)wmsLayerInfo);
        this.catalog.add(layerInfo);
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        LayerGroupInfo layerGroupInfo = this.catalog.getFactory().createLayerGroup();
        layerGroupInfo.setName(LAYER_GROUP_NAME);
        layerGroupInfo.setBounds(nativeBounds);
        layerGroupInfo.setMode(LayerGroupInfo.Mode.NAMED);
        layerGroupInfo.getLayers().add(layerInfo);
        this.catalog.add(layerGroupInfo);
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        Document trDom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Element trRoot = trDom.getDocumentElement();
        Capabilities_1_3_0_Transformer tr130 = new Capabilities_1_3_0_Transformer(this.wmsConfig, baseUrl, this.wmsConfig.getAllowedMapFormats(), (Collection)this.wmsConfig.getAvailableExtendedCapabilitiesProviders());
        Document tr130Dom = WMSTestSupport.transform(this.req, (TransformerBase)tr130);
        Element tr130Root = tr130Dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)trRoot.getNodeName());
        Assert.assertEquals((long)1L, (long)trDom.getElementsByTagName("Style").getLength());
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)tr130Root.getNodeName());
        Assert.assertEquals((long)1L, (long)tr130Dom.getElementsByTagName("Style").getLength());
    }

    private static final class TestExtendedCapabilitiesProvider
    implements ExtendedCapabilitiesProvider {
        private TestExtendedCapabilitiesProvider() {
        }

        public String[] getSchemaLocations(String schemaBaseURL) {
            throw new UnsupportedOperationException();
        }

        public void registerNamespaces(NamespaceSupport namespaces) {
            throw new UnsupportedOperationException();
        }

        public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
            return Collections.singletonList("TestElement?");
        }

        public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
            return Collections.singletonList("<!ELEMENT TestSubElement (#PCDATA) >");
        }

        public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
            tx.start("TestElement");
            tx.start("TestSubElement");
            tx.end("TestSubElement");
            tx.end("TestElement");
        }

        public void customizeRootCrsList(Set<String> srs) {
            srs.clear();
            srs.add("EPSG:4326");
        }

        public NumberRange<Double> overrideScaleDenominators(PublishedInfo layer, NumberRange<Double> scaleDenominators) {
            return new NumberRange(Double.class, (Number)0.0, (Number)1000.0);
        }
    }

    private static final class EmptyExtendedCapabilitiesProvider
    implements ExtendedCapabilitiesProvider {
        private EmptyExtendedCapabilitiesProvider() {
        }

        public String[] getSchemaLocations(String schemaBaseURL) {
            throw new UnsupportedOperationException();
        }

        public void registerNamespaces(NamespaceSupport namespaces) {
            throw new UnsupportedOperationException();
        }

        public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
            return null;
        }

        public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
            return null;
        }

        public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
        }

        public void customizeRootCrsList(Set<String> srs) {
        }

        public NumberRange<Double> overrideScaleDenominators(PublishedInfo layer, NumberRange<Double> scaleDenominators) {
            return null;
        }
    }
}

