/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.Filter;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.animate.AnimatorFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class AnimatorFilterTest
extends WMSTestSupport {
    public List<Filter> getFilters() {
        return Arrays.asList(new AnimatorFilter());
    }

    @Test
    public void testDefaults() throws Exception {
        String requestURL = "cite/wms/animate?aparam=layers&avalues=MapNeatline,Buildings,Lakes";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
        Assert.assertEquals((long)3L, (long)this.extractImageCountFromGIF(resp));
    }

    @Test
    public void testGEOS_6006() throws Exception {
        String requestURL = "cite/wms/animate?request=getmap&aparam=layers&avalues=MapNeatline,Buildings,Lakes";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
        Assert.assertEquals((long)3L, (long)this.extractImageCountFromGIF(resp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int extractImageCountFromGIF(MockHttpServletResponse response) throws IOException {
        ByteArrayInputStream is = null;
        ImageInputStream iis = null;
        ImageReader r = null;
        try {
            is = this.getBinaryInputStream(response);
            iis = ImageIO.createImageInputStream(is);
            r = ImageIO.getImageReadersBySuffix("gif").next();
            r.setInput(iis);
            int n = r.getNumImages(true);
            return n;
        }
        finally {
            if (r != null) {
                r.dispose();
            }
            if (iis != null) {
                iis.close();
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

