/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.ScaleComputationMethod;
import org.geoserver.wms.WMSRequests;
import org.geoserver.wms.WMSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class WMSRequestsTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
    }

    @Test
    public void testGetGetMapUrlAllWithDimensions() {
        GetMapRequest request = this.initGetMapRequest(MockData.TASMANIA_DEM);
        request.getRawKvp().put("time", "2017-04-07T19:56:00.000Z");
        request.getRawKvp().put("elevation", "1013.2");
        request.getRawKvp().put("dim_my_dimension", "010");
        String url = WMSRequestsTest.getGetMapUrl(request);
        Assert.assertThat((Object)url, (Matcher)CoreMatchers.containsString((String)"&time=2017-04-07T19:56:00.000Z&"));
        Assert.assertThat((Object)url, (Matcher)CoreMatchers.containsString((String)"&elevation=1013.2&"));
        Assert.assertThat((Object)url, (Matcher)CoreMatchers.containsString((String)"&dim_my_dimension=010&"));
    }

    @Test
    public void testGetGetMapUrlWithDimensions() {
        GetMapRequest request = this.initGetMapRequest(MockData.TASMANIA_DEM);
        request.getRawKvp().put("time", "2017-04-07T19:56:00.000Z");
        request.getRawKvp().put("elevation", "1013.2");
        request.getRawKvp().put("dim_my_dimension", "010");
        List<String> urls = WMSRequestsTest.getGetMapUrls(request);
        Assert.assertEquals((long)1L, (long)urls.size());
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&time=2017-04-07T19:56:00.000Z&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&elevation=1013.2&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&dim_my_dimension=010&"));
    }

    @Test
    public void testGetGetMapUrlWithSingleLayer() throws Exception {
        GetMapRequest request = this.initGetMapRequest(MockData.LAKES);
        request.getRawKvp().put("cql_filter", "fid='123'");
        request.setExceptions("INIMAGE");
        request.setRemoteOwsType("WFS");
        request.setRemoteOwsURL(new URL("https://foo.com/geoserver/wfs"));
        request.setScaleMethod(ScaleComputationMethod.Accurate);
        List<String> urls = WMSRequestsTest.getGetMapUrls(request);
        Assert.assertEquals((long)1L, (long)urls.size());
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&cql_filter=fid='123'&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&remote_ows_type=WFS&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&remote_ows_url=https://foo.com/geoserver/wfs&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&scalemethod=Accurate"));
    }

    @Test
    public void testGetGetMapUrlWithMultipleLayers() {
        GetMapRequest request = this.initGetMapRequest(MockData.LAKES, MockData.TASMANIA_DEM);
        request.getRawKvp().put("cql_filter", "fid='123';INCLUDE");
        request.getRawKvp().put("bgcolor", "0x808080");
        request.setStyleFormat("ysld");
        request.setSldBody("foo");
        List<String> urls = WMSRequestsTest.getGetMapUrls(request);
        Assert.assertEquals((long)2L, (long)urls.size());
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&cql_filter=fid='123'&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&bgcolor=0x808080&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&style_format=ysld&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&sld_body=foo"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&cql_filter=INCLUDE&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&bgcolor=0x808080&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&style_format=ysld&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&sld_body=foo"));
    }

    @Test
    public void testGetGetMapUrlWithSingleLayerGroup() throws Exception {
        GetMapRequest request = this.initGetMapRequest(MockData.LAKES, MockData.FORESTS);
        request.getRawKvp().put("layers", "nature");
        request.getRawKvp().put("cql_filter", "name LIKE 'BLUE%'");
        request.getRawKvp().put("sortby", "name A");
        request.setStartIndex(Integer.valueOf(25));
        request.setMaxFeatures(Integer.valueOf(50));
        request.setStyleVersion("1.1.0");
        request.setSld(new URL("http://localhost/test.sld"));
        request.setValidateSchema(Boolean.valueOf(true));
        List<String> urls = WMSRequestsTest.getGetMapUrls(request);
        Assert.assertEquals((long)2L, (long)urls.size());
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&cql_filter=name LIKE 'BLUE%'&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&sortby=name A&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&startindex=25&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&maxfeatures=50&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&style_version=1.1.0&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&validateschema=true&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&sld=http://localhost/test.sld"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&cql_filter=name LIKE 'BLUE%'&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&sortby=name A&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&startindex=25&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&maxfeatures=50&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&style_version=1.1.0&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&validateschema=true&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&sld=http://localhost/test.sld"));
    }

    @Test
    public void testGetGetMapUrlWithLayerGroupAndLayers() {
        GetMapRequest request = this.initGetMapRequest(MockData.LAKES, MockData.LAKES, MockData.FORESTS, MockData.TASMANIA_DEM);
        request.getRawKvp().put("layers", ((MapLayerInfo)request.getLayers().get(0)).getName() + ',' + "nature" + ',' + ((MapLayerInfo)request.getLayers().get(3)).getName());
        request.getRawKvp().put("cql_filter", "fid='123';name LIKE 'BLUE%';INCLUDE");
        request.getRawKvp().put("interpolations", ",,nearest neighbor");
        request.getRawKvp().put("sortby", "(fid)(name D)()");
        List<String> urls = WMSRequestsTest.getGetMapUrls(request);
        Assert.assertEquals((long)4L, (long)urls.size());
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&cql_filter=fid='123'&"));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"&interpolations=")));
        Assert.assertThat((Object)urls.get(0), (Matcher)CoreMatchers.containsString((String)"&sortby=fid&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&cql_filter=name LIKE 'BLUE%'&"));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"&interpolations=")));
        Assert.assertThat((Object)urls.get(1), (Matcher)CoreMatchers.containsString((String)"&sortby=name D&"));
        Assert.assertThat((Object)urls.get(2), (Matcher)CoreMatchers.containsString((String)"&cql_filter=name LIKE 'BLUE%'&"));
        Assert.assertThat((Object)urls.get(2), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"&interpolations=")));
        Assert.assertThat((Object)urls.get(2), (Matcher)CoreMatchers.containsString((String)"&sortby=name D&"));
        Assert.assertThat((Object)urls.get(3), (Matcher)CoreMatchers.containsString((String)"&cql_filter=INCLUDE&"));
        Assert.assertThat((Object)urls.get(3), (Matcher)CoreMatchers.containsString((String)"&interpolations=nearest neighbor&"));
        Assert.assertThat((Object)urls.get(3), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"&sortby=")));
    }

    private GetMapRequest initGetMapRequest(QName ... names) {
        GetMapRequest request = this.createGetMapRequest(names);
        request.setRawKvp((Map)new KvpMap(request.getRawKvp()));
        String layers = request.getLayers().stream().map(MapLayerInfo::getName).collect(Collectors.joining(","));
        request.getRawKvp().put("layers", layers);
        request.setFormat(DefaultWebMapService.FORMAT);
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        return request;
    }

    private static String getGetMapUrl(GetMapRequest request) {
        String url = WMSRequests.getGetMapUrl((GetMapRequest)request, null, (int)0, null, null);
        return ResponseUtils.urlDecode((String)url);
    }

    private static List<String> getGetMapUrls(GetMapRequest request) {
        ArrayList<String> urls = new ArrayList<String>(request.getLayers().size());
        for (int i = 0; i < request.getLayers().size(); ++i) {
            String name = ((MapLayerInfo)request.getLayers().get(i)).getName();
            String url = WMSRequests.getGetMapUrl((GetMapRequest)request, (String)name, (int)i, null, null, null);
            urls.add(ResponseUtils.urlDecode((String)url));
        }
        return urls;
    }
}

