/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WebMap;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class GetMapTest {
    private WMSMockData mockData;
    private GetMapRequest request;
    private GetMap getMapOp;

    @Before
    public void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        this.request = this.mockData.createRequest();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testType", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        this.getMapOp = new GetMap(this.mockData.getWMS());
    }

    @Test
    public void testExecuteNoExtent() {
        this.request.setBbox(null);
        this.assertInvalidMandatoryParam("MissingBBox");
    }

    @Test
    public void testExecuteEmptyExtent() {
        this.request.setBbox(new Envelope());
        this.assertInvalidMandatoryParam("InvalidBBox");
    }

    @Test
    public void testSingleVectorLayer() throws IOException {
        this.request.setFormat("image/dummy");
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testSingleVectorLayer", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer();
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        this.getMapOp.run(this.request);
        Assert.assertTrue((boolean)producer.produceMapCalled);
    }

    @Test
    public void testExecuteNoLayers() throws Exception {
        this.request.setLayers(null);
        this.assertInvalidMandatoryParam("LayerNotDefined");
    }

    @Test
    public void testExecuteNoWidth() {
        this.request.setWidth(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setWidth(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    @Test
    public void testExecuteNoHeight() {
        this.request.setHeight(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setHeight(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    @Test
    public void testExecuteInvalidFormat() {
        this.request.setFormat("non-existent-output-format");
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    @Test
    public void testExecuteNoFormat() {
        this.request.setFormat(null);
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    @Test
    public void testExecuteNoStyles() {
        this.request.setStyles(null);
        this.assertInvalidMandatoryParam("StyleNotDefined");
    }

    @Test
    public void testEnviroment() {
        final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        EnvFunction.setLocalValues(Collections.singletonMap("myParam", 23));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer(){

            @Override
            public WebMap produceMap(WMSMapContent ctx) throws ServiceException, IOException {
                Assert.assertEquals((Object)23, (Object)ff.function("env", new Expression[]{ff.literal((Object)"myParam")}).evaluate(null));
                Assert.assertEquals((Object)10, (Object)ff.function("env", new Expression[]{ff.literal((Object)"otherParam"), ff.literal(10)}).evaluate(null));
                this.produceMapCalled = true;
                return null;
            }
        };
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        WebMap map = this.getMapOp.run(this.request);
        Assert.assertTrue((boolean)producer.produceMapCalled);
    }

    private void assertInvalidMandatoryParam(String expectedExceptionCode) {
        try {
            this.getMapOp.run(this.request);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)expectedExceptionCode, (Object)e.getCode());
        }
    }
}

