/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.impl.AttributeHandler;
import org.geotools.xsd.impl.DocumentHandler;
import org.geotools.xsd.impl.ElementHandler;
import org.geotools.xsd.impl.ElementHandlerImpl;
import org.geotools.xsd.impl.Handler;
import org.geotools.xsd.impl.HandlerFactory;
import org.geotools.xsd.impl.ParserHandler;

public class WFSHandlerFactory
implements HandlerFactory {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    Catalog catalog;
    FeatureTypeSchemaBuilder schemaBuilder;

    public WFSHandlerFactory(Catalog catalog, FeatureTypeSchemaBuilder schemaBuilder) {
        this.catalog = catalog;
        this.schemaBuilder = schemaBuilder;
    }

    public DocumentHandler createDocumentHandler(ParserHandler parser) {
        return null;
    }

    public ElementHandler createElementHandler(QName name, Handler parent, ParserHandler parser) {
        String namespaceURI = name.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = this.catalog.getDefaultNamespace().getURI();
        }
        try {
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, name.getLocalPart());
            if (meta != null) {
                XSDSchema schema = this.schemaBuilder.build(meta, null);
                for (XSDElementDeclaration element : schema.getElementDeclarations()) {
                    if (!name.getLocalPart().equals(element.getName())) continue;
                    return new ElementHandlerImpl(element, parent, parser);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error building schema", e);
        }
        return null;
    }

    public ElementHandler createElementHandler(XSDElementDeclaration e, Handler parent, ParserHandler parser) {
        return null;
    }

    public AttributeHandler createAttributeHandler(XSDAttributeDeclaration a, Handler parent, ParserHandler parser) {
        return null;
    }
}

