/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.OWS11ServiceExceptionHandler;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.JSONType;

public class Wfs2ExceptionHandler
extends OWS11ServiceExceptionHandler {
    GeoServer gs;

    public Wfs2ExceptionHandler(List<Service> services, GeoServer gs) {
        super(services);
        this.gs = gs;
    }

    public void handleServiceException(ServiceException exception, Request request) {
        String exceptions;
        boolean verbose = this.gs.getSettings().isVerboseExceptions();
        String charset = this.gs.getSettings().getCharset();
        this.setHttpHeaders(exception, request);
        try {
            exceptions = (String)request.getKvp().get("EXCEPTIONS");
            if (exceptions == null) {
                super.handleServiceException(exception, request);
                return;
            }
        }
        catch (Exception e) {
            super.handleServiceException(exception, request);
            return;
        }
        if (JSONType.isJsonMimeType(exceptions)) {
            JSONType.handleJsonException(LOGGER, exception, request, charset, verbose, false);
        } else if (JSONType.useJsonp(exceptions)) {
            JSONType.handleJsonException(LOGGER, exception, request, charset, verbose, true);
        } else {
            super.handleServiceException(exception, request);
        }
    }

    private void setHttpHeaders(ServiceException exception, Request request) {
        HttpServletResponse response = request.getHttpResponse();
        String code = exception.getCode();
        if (code == null) {
            exception.setCode("NoApplicableCode");
        }
        if ("OperationProcessingFailed".equals(code)) {
            response.setStatus(500);
        } else if ("NotFound".equals(code)) {
            response.setStatus(404);
        } else if ("LockHasExpired".equals(code)) {
            response.setStatus(403);
        } else {
            response.setStatus(400);
        }
    }
}

