/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.CreatedOrModifiedFeatureType;
import net.opengis.wfs20.TransactionResponseType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.filter.identity.FeatureId;

public abstract class TransactionResponse
extends RequestObject {
    public static TransactionResponse adapt(Object request) {
        if (request instanceof net.opengis.wfs.TransactionResponseType) {
            return new WFS11((EObject)request);
        }
        if (request instanceof TransactionResponseType) {
            return new WFS20((EObject)request);
        }
        return null;
    }

    protected TransactionResponse(EObject adaptee) {
        super(adaptee);
    }

    public BigInteger getTotalInserted() {
        return this.eGet(this.adaptee, "transactionSummary.totalInserted", BigInteger.class);
    }

    public void setTotalInserted(BigInteger inserted) {
        this.eSet(this.adaptee, "transactionSummary.totalInserted", inserted);
    }

    public BigInteger getTotalUpdated() {
        return this.eGet(this.adaptee, "transactionSummary.totalUpdated", BigInteger.class);
    }

    public void setTotalUpdated(BigInteger updated) {
        this.eSet(this.adaptee, "transactionSummary.totalUpdated", updated);
    }

    public BigInteger getTotalDeleted() {
        return this.eGet(this.adaptee, "transactionSummary.totalDeleted", BigInteger.class);
    }

    public void setTotalDeleted(BigInteger deleted) {
        this.eSet(this.adaptee, "transactionSummary.totalDeleted", deleted);
    }

    public BigInteger getTotalReplaced() {
        return this.eGet(this.adaptee, "transactionSummary.totalReplaced", BigInteger.class);
    }

    public void setTotalReplaced(BigInteger replaced) {
        this.eSet(this.adaptee, "transactionSummary.totalReplaced", replaced);
    }

    public List getInsertedFeatures() {
        return this.eGet(this.adaptee, "insertResults.feature", List.class);
    }

    @Override
    public abstract void setHandle(String var1);

    public abstract void addInsertedFeature(String var1, FeatureId var2);

    public abstract void addUpdatedFeatures(String var1, Collection<FeatureId> var2);

    public abstract void addReplacedFeatures(String var1, Collection<FeatureId> var2);

    public abstract void addAction(String var1, String var2, String var3);

    public static class WFS20
    extends TransactionResponse {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public void setHandle(String handle) {
        }

        @Override
        public void addInsertedFeature(String handle, FeatureId featureId) {
            CreatedOrModifiedFeatureType inserted = ((Wfs20Factory)this.getFactory()).createCreatedOrModifiedFeatureType();
            inserted.setHandle(handle);
            inserted.getResourceId().add((Object)featureId);
            TransactionResponseType tr = (TransactionResponseType)this.adaptee;
            if (tr.getInsertResults() == null) {
                tr.setInsertResults(((Wfs20Factory)this.getFactory()).createActionResultsType());
            }
            tr.getInsertResults().getFeature().add((Object)inserted);
        }

        @Override
        public void addUpdatedFeatures(String handle, Collection<FeatureId> ids) {
            CreatedOrModifiedFeatureType updated = ((Wfs20Factory)this.getFactory()).createCreatedOrModifiedFeatureType();
            updated.setHandle(handle);
            updated.getResourceId().addAll(ids);
            TransactionResponseType tr = (TransactionResponseType)this.adaptee;
            if (tr.getUpdateResults() == null) {
                tr.setUpdateResults(((Wfs20Factory)this.getFactory()).createActionResultsType());
            }
            tr.getUpdateResults().getFeature().add((Object)updated);
        }

        @Override
        public void addReplacedFeatures(String handle, Collection<FeatureId> ids) {
            CreatedOrModifiedFeatureType updated = ((Wfs20Factory)this.getFactory()).createCreatedOrModifiedFeatureType();
            updated.setHandle(handle);
            updated.getResourceId().addAll(ids);
            TransactionResponseType tr = (TransactionResponseType)this.adaptee;
            if (tr.getReplaceResults() == null) {
                tr.setReplaceResults(((Wfs20Factory)this.getFactory()).createActionResultsType());
            }
            tr.getReplaceResults().getFeature().add((Object)updated);
        }

        @Override
        public void addAction(String code, String locator, String message) {
        }
    }

    public static class WFS11
    extends TransactionResponse {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public void setHandle(String handle) {
            this.eSet(this.adaptee, "transactionResults.handle", handle);
        }

        @Override
        public void addInsertedFeature(String handle, FeatureId featureId) {
            InsertedFeatureType insertedFeature = ((WfsFactory)this.getFactory()).createInsertedFeatureType();
            insertedFeature.setHandle(handle);
            insertedFeature.getFeatureId().add((Object)featureId);
            ((net.opengis.wfs.TransactionResponseType)this.adaptee).getInsertResults().getFeature().add((Object)insertedFeature);
        }

        @Override
        public void addUpdatedFeatures(String handle, Collection<FeatureId> id) {
        }

        @Override
        public void addReplacedFeatures(String handle, Collection<FeatureId> ids) {
        }

        @Override
        public void addAction(String code, String locator, String message) {
            ActionType action = ((WfsFactory)this.getFactory()).createActionType();
            action.setCode(code);
            action.setLocator(locator);
            action.setMessage(message);
            ((net.opengis.wfs.TransactionResponseType)this.adaptee).getTransactionResults().getAction().add((Object)action);
        }

        public static net.opengis.wfs.TransactionResponseType unadapt(TransactionResponse response) {
            if (response instanceof WFS11) {
                return (net.opengis.wfs.TransactionResponseType)response.getAdaptee();
            }
            return null;
        }
    }
}

